'use strict';

(function ($) {
    var DejavoSE_timer = 0;

    $(document).on('click touch', '.dejavo_search input[type=search]',
        function () {
            var $this = $(this);


            var offset = $this.offset();
            var width = $this.outerWidth();
            var height = $this.outerHeight();

            $('#DejavoSE-area').css('top', offset.top + height).css('left', offset.left).css('width', width).css('max-width', width);
            DejavoSE_show('inline');


            if ($this.hasClass('DejavoSE-animated-placeholder') &&
                ($this.val() === '')) {
                var placeholder = $this.attr('placeholder');

                $this.val(placeholder).trigger('change');
                $('.DejavoSE-area').data('kw', placeholder);
                DejavoSE_ajax_search();
            }
        });

    $(document).on('keyup', '.dejavo_search input[type=search]',
        function () {

            DejavoSE_show('inline');
            var kw = $(this).val();

            if (kw !== '') {
                $('.DejavoSE-area').data('kw', kw);

                if (DejavoSE_timer != null) {
                    clearTimeout(DejavoSE_timer);
                }

                DejavoSE_timer = setTimeout(DejavoSE_ajax_search, 300);
                return false;
            }
        });

    if (DejavoSE_vars.animated_placeholder !== '' &&
        DejavoSE_vars.animated_placeholder !== '[]') {
        $(document).find('.dejavo_search input[type=search]').addClass('DejavoSE-animated-placeholder').placeholderTypewriter(JSON.parse(DejavoSE_vars.animated_placeholder));
    }


    $(document).on('click touch', function (e) {
        if (($(e.target).closest('.DejavoSE-area').length === 0) && ($(e.target).closest('.dejavo_search input[type=search]').length ===
            0) && ($(e.target).closest(DejavoSE_vars.manual_show).length === 0) ) {
            DejavoSE_hide();
        }
    });

    // manual show
    if (DejavoSE_vars.manual_show !== '') {
        $(document).on('click touch', DejavoSE_vars.manual_show, function (e) {
            DejavoSE_toggle('inline');
            e.preventDefault();
        });
    }


    $(document).on('click touch', 'a[href="#DejavoSE"]', function (e) {
        var kw = $(this).text();
        $('.dejavo_search input[type=search]').val(kw).trigger('keyup');
        e.preventDefault();
    });


    $(document).on('change', '#DejavoSE_search_cats', function () {
        if (DejavoSE_timer != null) {
            clearTimeout(DejavoSE_timer);
        }
        DejavoSE_timer = setTimeout(DejavoSE_ajax_search, 300);
        DejavoSE_show('inline');
        return false;
    });

    function DejavoSE_ajax_search() {
        if ($('.DejavoSE-area').data('kw') != undefined &&
            $('.DejavoSE-area').data('kw') != '') {
            $('.DejavoSE-search-result').addClass('DejavoSE-loading');
            // ajax search product
            DejavoSE_timer = null;

            var data = {
                action: 'DejavoSE_search',
                keyword: $('.DejavoSE-area').data('kw'),
                category: $('#DejavoSE_search_cats').length ?
                    $('#DejavoSE_search_cats').val() :
                    0,
                nonce: DejavoSE_vars.nonce,
            };

            $.post(DejavoSE_vars.ajax_url, data, function (response) {
                $('.DejavoSE-search-result').html(response).removeClass('DejavoSE-loading');
            });
        }
    }


})(jQuery);


function DejavoSE_show(context = '') {
    jQuery('body').addClass('DejavoSE-body-show DejavoSE-body-show-' + context);
    jQuery('.DejavoSE-area').addClass('DejavoSE-area-show DejavoSE-area-show-' + context);
    jQuery(document.body).trigger('DejavoSE_show_' + context);
    jQuery(document.body).trigger('DejavoSE_show');
}

function DejavoSE_hide(context = '') {
    jQuery('.DejavoSE-area').attr('style', '').removeClass('DejavoSE-area-show DejavoSE-area-show-inline');
    jQuery('body').removeClass('DejavoSE-body-show DejavoSE-body-show-inline');
    jQuery(document.body).trigger('DejavoSE_hide_' + context);
    jQuery(document.body).trigger('DejavoSE_hide');
}

function DejavoSE_toggle(context = '') {
    if (jQuery('body').hasClass('DejavoSE-body-show')) {
        DejavoSE_hide(context);
    } else {
        DejavoSE_show(context);
    }
    jQuery(document.body).trigger('DejavoSE_toggle_' + context);
    jQuery(document.body).trigger('DejavoSE_toggle');
}
