jQuery(document).ready(function () {
    const $ = jQuery;
    const Home = Dej_Auth.home_url;
    const Dej_Ajax = Home + "/dej_ajax";
    function validate_Email(email) {
        var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
        return regex.test(email);
    }
    function validate_Mobile(mob) {
        var regex = /(^09[0-9]{9}$)|(^\u06F0\u06F9[\u06F0-\u06F9]{9})$/;
        if (regex.test(mob)) {
            return true;
        } else {
            return false;
        }
    }
    function validate_UserName(text) {
        var regex = /^([a-z0-9]|[-._](?![-._])){4,20}$/;
        return regex.test(text);
    }
    $(document).on('input', '#dej-auth-code', function () {
        var that = $(this);
        if (that.val().length == that.attr('maxlength')) {
            that.closest('form').submit();
        }
    });

    $(document).on('submit', 'form.main_mobile_form', function (e) {
        e.preventDefault();
        let Ajax_url = Dej_Ajax + "/insert_code/";
        let AuthInput = $('input.dej_auth[name="login[email_phone]"]');
        let type = '';
        let input_val = AuthInput.val();

        if (validate_Email(input_val)) {
            type = 'email';
        } else if (validate_Mobile(input_val)) {
            type = 'mobile';
        } else {
            $('.dej_login_form').addClass('error');
            $('#input_error').css({'display': 'block'});
            return false;
        }
        let is_valid;
        let ParentEl = $('.dej_login_form');
        if ((ParentEl.hasClass('sms') && type == 'mobile') || (ParentEl.hasClass('email') && type == 'email') || (ParentEl.hasClass('both'))) {
            is_valid = true;
        }  else {
            is_valid = false;
        }

        let perNumPattern = /[\u06F0-\u06F9]/g; // matches all Persian digits
        let enNumMapping = {'۰': '0', '۱': '1', '۲': '2', '۳': '3', '۴': '4', '۵': '5', '۶': '6', '۷': '7', '۸': '8', '۹': '9'};
        let englishPhone = AuthInput.val().replace(perNumPattern, function (match) {
            return enNumMapping[match];
        });

        if (is_valid == true) {

            $.ajax({
                type: 'POST',
                url: Ajax_url,
                data: {
                    phone: englishPhone, type: type,
                },
                beforeSend: function () {
                    $('.dej_auth_form').html('<div class="loader-3"></div>');
                },
                success: function (resp) {
                    $('.dej_auth_form').html(resp);
                    $('.timer-holder').removeClass('d-none');
                    $('.send_again').removeClass('d-block');
                    let time = $('.dej-counter').data('countdown-timer');
                    dej_counter_timer(time);

                    $('.status').html(resp.text);
                }
            });
        } else {
            $('.dej_login_form').addClass('error');
            $('#input_error').css({'display': 'block'});
            return false;
        }

    })


    $(document).on('submit', 'form.insert_code_form', function (e) {
        e.preventDefault();

        var Ajax_url = Dej_Ajax + "/check_code/";
        var authInput = document.getElementById('dej-auth-code').value;
        var perNumPattern = /[\u06F0-\u06F9]/g; // matches all Persian digits
        let enNumMapping = {'۰': '0', '۱': '1', '۲': '2', '۳': '3', '۴': '4', '۵': '5', '۶': '6', '۷': '7', '۸': '8', '۹': '9'};
        var finalCode = authInput.replace(perNumPattern, function (match) {
            return enNumMapping[match];
        });
        let counter = document.getElementById('dej-counter').innerText;

        $.ajax({
            type: 'POST',
            url: Ajax_url,
            data: {
                phone: $('.phone_number').text(), code: finalCode, counter: counter,
            },
            beforeSend: function () {
                $('.confirm_code').html(Dej_Auth.sending);
            },
            success: function (resp) {
                $('.confirm_code').html(Dej_Auth.confirm);
                $('.status').html(resp.text);
                if (resp.status == true) {
                    setTimeout(function () {
                        location.reload();
                    }, 1500)
                }
            }
        });

    });


    $(document).on('click touch', '.send_again', function (e) {
        e.preventDefault();
        let ajax_url = Dej_Ajax + "/send_again/";

        let type = '';
        let input_val = $('.phone_number').text();

        if (validate_Email(input_val)) {
            type = 'email';
        } else if (validate_Mobile(input_val)) {
            type = 'mobile';
        } else {
            $('.dej_login_form').addClass('error');
            $('#input_error').css({'display': 'block'});
            return false;
        }
        $.ajax({
            type: 'POST',
            url: ajax_url,
            data: {
                phone: input_val, type: type,
            },
            beforeSend: function () {
                $('.status').html('');
                $('.send_again').html(Dej_Auth.sending);
            },
            success: function (resp) {
                $('.send_again').html(Dej_Auth.send_again);
                if (resp.status == true) {
                    $('.status').html(resp.text);
                    $('.send_again').removeClass('d-block');
                    $('.timer-holder, .confirm_code').removeClass('d-none');

                    let time = $('.dej-counter').data('countdown-timer');
                    dej_counter_timer(time);
                }
            }
        });

    });

    $(document).on('submit', 'form.with_password', function (e) {
        e.preventDefault();

        let emailInput = $('.with_password input[name="email"]');
        let passInput = $('.with_password input[name="password"]');
        let type = '';
        let email_val = emailInput.val();

        if (validate_Email(email_val)) {
            type = 'email';
        } else if (validate_Mobile(email_val)) {
            type = 'mobile';
        } else if (validate_UserName(email_val)){
            type = 'username';
        }

        let email_ajax = Dej_Ajax + "/static_pass_check/";
        $.ajax({
            type: 'POST',
            url: email_ajax,
            data: { email: emailInput.val(), pass: passInput.val(), type: type, },
            beforeSend: function () {
                $('.pass_login').html(Dej_Auth.sending);
            },
            success: function (resp) {
                $('.pass_login').html(Dej_Auth.login);
                $('.status').html(resp.text);
                if (resp.status == true) {
                    setTimeout(function () {
                        location.reload();
                    }, 1500)
                }
            }
        });
    })

    $(document).on('click touch', '.passbtn', function (e) {
        e.preventDefault();
        $(this).addClass('active');
        $('.auth_btn_form').removeClass('active');
        $('.dej_login_form').removeClass('error');

        var ajax_url = Dej_Ajax + "/with_password/";
        $.ajax({
            type: 'POST',
            url: ajax_url,
            beforeSend: function () {
                $('.dej_auth_form').html('<div class="loader-3"></div>');
            },
            success: function (response) {
                $('.dej_auth_form').html(response);
            }
        });
    });

    $(document).on('click touch', '.auth_btn_form, .edit_phone', function (e) {
        e.preventDefault();
        $(this).addClass('active');
        $('.passbtn').removeClass('active');
        $('.dej_login_form').removeClass('error');

        var Ajax_url = Dej_Ajax + "/auth_form_callback/";
        $.ajax({
            type: 'POST',
            url: Ajax_url,
            beforeSend: function () {
                $('.dej_auth_form').html('<div class="loader-3"></div>');
            },
            success: function (resp) {
                $('.dej_auth_form').html(resp);
            }
        });
    });
    function dej_counter_timer(ExpireDate) {
        var counter = 0;
        var dej_timer = setInterval(function () {
            var dej_rem = ExpireDate - counter;
            if (!document.getElementById("dej-counter")) {
                clearInterval(dej_timer)
            }
            document.getElementById("dej-counter").innerHTML = dej_convToMMSS(dej_rem);
            counter++;
            if (counter >= ExpireDate) {

                $('.timer-holder, .confirm_code').addClass('d-none');
                $('.send_again').addClass('d-block');
                $('.status').html('');

                let input = $('.phone_number').innerText;
                let Ajax_url = Dej_Ajax + "/dej_delete_code/";
                $.ajax({
                    url: Ajax_url,
                    type: 'post',
                    data: {input: input,},
                    success: function (response) {
                    },
                    error: function (error) {
                    }
                });
                clearInterval(dej_timer);
                document.getElementById("dej-counter").innerHTML = '00:00';
            }
        }, 1000, !0);

    }
    function dej_convToMMSS(Time) {
        var sec_num = parseInt(Time, 10);
        var hours = Math.floor(sec_num / 3600);
        var minutes = Math.floor((sec_num - (hours * 3600)) / 60);
        var seconds = sec_num - (hours * 3600) - (minutes * 60);

        if (minutes < 10) {
            minutes = "0" + minutes;
        }
        if (seconds < 10) {
            seconds = "0" + seconds;
        }
        return minutes + ':' + seconds;
    }
});
