'use strict';

(function($) {
  var DejavoCP_timer = 0;

  // ready
  $(function() {
    DejavoCP_change_count('first');
    DejavoCP_check_buttons();
    DejavoCP_hide_empty();

    if (DejavoCP_vars.open_bar === 'yes') {
      DejavoCP_load_data('bar');
      DejavoCP_open_bar();
    }


    if (DejavoCP_vars.button_action === 'show_message') {
      $.notiny.addTheme('DejavoCP', {
        notification_class: 'notiny-theme-DejavoCP',
      });
    }
  });



  // quick view
  $(document).
  on('click touch', '.DejavoCP_table .DejavoQV-btn, .DejavoCP_table .DejavoQV-link',
      function(e) {
        e.preventDefault();
        DejavoCP_close();
      });



  $(document).on('click touch', '.DejavoCP-bar-print', function(e) {
    e.preventDefault();
    $.print('#DejavoCP-area');
  });

  $(document).on('keydown', function(e) {
    if ((e.ctrlKey == true || e.metaKey == true) && (e.which == '80')) {
      //ctrl+p or command+p
      if ($('.DejavoCP-area').hasClass('DejavoCP-area-open-table')) {
        e.preventDefault();
        $.print('#DejavoCP-area');
      }
    }
  });

  $(document).on('click touch', '.DejavoCP-bar-share', function(e) {
    e.preventDefault();
    $('.DejavoCP-share').toggleClass('open');
    $('.DejavoCP-share-content').addClass('DejavoCP-loading');

    var data = {
      action: 'DejavoCP_share',
    };

    jQuery.post(DejavoCP_vars.ajax_url, data, function(response) {
      $('.DejavoCP-share-content').html(response).removeClass('DejavoCP-loading');
    });
  });

  // copy link
  $(document).
  on('click touch', '#DejavoCP_copy_url, #DejavoCP_copy_btn', function(e) {
    e.preventDefault();
    DejavoCP_copy_to_clipboard('#DejavoCP_copy_url');
  });

  // search
  $(document).on('click touch', '.DejavoCP-bar-search', function(e) {
    e.preventDefault();
    $('.DejavoCP-search').toggleClass('open');

    if ($('.DejavoCP-search-result').text() === '') {
      if (DejavoCP_timer != null) {
        clearTimeout(DejavoCP_timer);
      }

      DejavoCP_timer = setTimeout(DejavoCP_search, 300);
      return false;
    }
  });

  // popup
  $(document).on('click touch', '.DejavoCP-popup', function(e) {
    if ($(e.target).closest('.DejavoCP-popup-content').length === 0) {
      $(this).toggleClass('open');
    }
  });

  $(document).on('keyup', '#DejavoCP_search_input', function() {
    if ($('#DejavoCP_search_input').val() !== '') {
      if (DejavoCP_timer != null) {
        clearTimeout(DejavoCP_timer);
      }

      DejavoCP_timer = setTimeout(DejavoCP_search, 300);
      return false;
    }
  });

  $(document).on('click touch', '.DejavoCP-item-add', function(e) {
    e.preventDefault();
    var product_id = $(this).attr('data-id');

    $('.DejavoCP-search').toggleClass('open');
    DejavoCP_add_product(product_id);
    DejavoCP_load_data('table');
    DejavoCP_open_table();
  });

  $(document).on('click touch', '.DejavoCP-popup-close', function(e) {
    e.preventDefault();
    $(this).closest('.DejavoCP-popup').toggleClass('open');
  });


  // found variation
  $(document).on('found_variation', function(e, t) {
    var product_id = $(e['target']).attr('data-product_id');
    $('.DejavoCP-btn-' + product_id).removeClass('DejavoCP-btn-added DejavoCP-added').attr('data-id', t.variation_id).html(DejavoCP_vars.button_text);
  });

  // reset data
  $(document).on('reset_data', function(e) {
    var product_id = $(e['target']).attr('data-product_id');
    $('.DejavoCP-btn-' + product_id).removeClass('DejavoCP-btn-added DejavoCP-added').attr('data-id', product_id).html(DejavoCP_vars.button_text);
  });

  // remove all
  $(document).on('click touch', '.DejavoCP-bar-remove', function(e) {
    e.preventDefault();
    var r = confirm(DejavoCP_vars.remove_all);

    if (r == true) {
      DejavoCP_remove_product('all');
      DejavoCP_load_data('table');
    }
  });

  // add
  $(document).on('click touch', '.DejavoCP-btn', function(e) {
    e.preventDefault();
    var $this = $(this);
    var id = $this.attr('data-id');
    var pid = $this.attr('data-pid');
    var product_id = $this.attr('data-product_id');
    var product_name = $this.attr('data-product_name');
    var product_image = $this.attr('data-product_image');

    if (typeof pid !== typeof undefined && pid !== false) {
      id = pid;
    }

    if (typeof product_id !== typeof undefined && product_id !== false) {
      id = product_id;
    }

    $this.addClass('');

    if ($this.hasClass('DejavoCP-btn-added DejavoCP-added')) {
      if (DejavoCP_vars.click_again === 'yes') {
        // remove
        DejavoCP_remove_product(id);

        if (DejavoCP_vars.button_action === 'show_message') {
          $.notiny({
            theme: 'DejavoCP',
            position: DejavoCP_vars.message_position,
            image: product_image,
            text: DejavoCP_vars.message_removed.replace('{name}',
                '<strong>' + product_name + '</strong>'),
          });
        }
      } else {
        if (DejavoCP_vars.button_action === 'show_message') {
          $.notiny({
            theme: 'DejavoCP',
            position: DejavoCP_vars.message_position,
            image: product_image,
            text: DejavoCP_vars.message_exists.replace('{name}',
                '<strong>' + product_name + '</strong>'),
          });
        }
      }
    } else {
      $this.addClass('DejavoCP-btn-adding DejavoCP-adding');
      DejavoCP_add_product(id);

      if (DejavoCP_vars.button_action === 'show_message') {
        $.notiny({
          theme: 'DejavoCP',
          position: DejavoCP_vars.message_position,
          image: product_image,
          text: DejavoCP_vars.message_added.replace('{name}',
              '<strong>' + product_name + '</strong>'),
        });
      }
    }

    if (DejavoCP_vars.button_action === 'show_bar') {
      // show bar only
      DejavoCP_load_data('bar');
      DejavoCP_open_bar();
    }

    if (DejavoCP_vars.button_action === 'show_table') {
      // show bar & table
      DejavoCP_load_data('table');
      DejavoCP_open_bar();
      DejavoCP_open_table();
    }

    if ((DejavoCP_vars.button_action === 'show_message') ||
        (DejavoCP_vars.button_action === 'none')) {
      // load bar again
      if ($('.DejavoCP-bar').hasClass('DejavoCP-bar-open')) {
        DejavoCP_load_data('bar');
      }
    }


  });

  // remove on popup
  $(document).
  on('click touch',
      '#DejavoCP-area .DejavoCP-bar-item-remove, #DejavoCP-area .DejavoCP-remove',
      function(e) {
        e.preventDefault();
        var product_id = $(this).attr('data-id');

        $(this).parent().addClass('removing');
        DejavoCP_remove_product(product_id);
        DejavoCP_load_data('table');
        DejavoCP_check_buttons();
      });

  // remove on page
  $(document).
  on('click touch', '.DejavoCP-page .DejavoCP-remove',
      function(e) {
        e.preventDefault();
        var product_id = $(this).attr('data-id');

        DejavoCP_remove_product(product_id);
        location.reload();
      });



  // bar button
  $(document).on('click touch', '.DejavoCP-bar-btn', function(e) {
    e.preventDefault();

    if (!$('.DejavoCP-table-items').hasClass('DejavoCP-table-items-loaded')) {
      DejavoCP_load_data('table');
    }

    DejavoCP_toggle_table();
  });

  // close
  $(document).on('click touch', function(e) {
    if ((
        (DejavoCP_vars.click_outside === 'yes') ||
        ((DejavoCP_vars.click_outside === 'yes_empty') &&
            (parseInt($('.DejavoCP-bar').attr('data-count')) === 0))
    ) && (
        $(e.target).closest('.wpc_compare_count').length === 0
    ) && (
        $(e.target).closest('.DejavoCP-popup').length === 0
    ) && (
        $(e.target).closest('.DejavoCP-btn').length === 0
    ) && (
        $(e.target).closest('.DejavoCP-table').length === 0
    ) && (
        $(e.target).closest('.DejavoCP-bar').length === 0
    ) && (
        $(e.target).closest('.DejavoCP-menu-item a').length === 0
    ) && (
        $(e.target).closest('.DejavoCP-menu a').length === 0
    ) && (
        (
            DejavoCP_vars.open_button === ''
        ) || (
            $(e.target).closest(DejavoCP_vars.open_button).length === 0
        )
    )) {
      DejavoCP_close();
    }
  });




  // close
  $(document).on('click touch', '#DejavoCP-table-close', function(e) {
    e.preventDefault();
    DejavoCP_close_table();
  });


  // open button
  if (DejavoCP_vars.open_button !== '') {
    $(document).on('click touch', DejavoCP_vars.open_button, function(e) {
      e.preventDefault();

      if (DejavoCP_vars.open_button_action === 'open_page') {
        // open page
        if ((DejavoCP_vars.page_url !== '') && (DejavoCP_vars.page_url !== '#')) {
          window.location.href = DejavoCP_vars.page_url;
        }
      } else {
        if (DejavoCP_vars.open_button_action === 'open_popup') {
          // open compare popup
          if (!$('.DejavoCP-table-items').hasClass('DejavoCP-table-items-loaded')) {
            DejavoCP_load_data('table');
          }

          DejavoCP_open_bar();
          DejavoCP_open_table();
        }


      }
    });
  }

  // menu item
  $(document).
  on('click touch', '.DejavoCP-menu-item a, .DejavoCP-menu a', function(e) {
    if (DejavoCP_vars.menu_action === 'open_popup') {
      e.preventDefault();

      // open compare popup
      if (!$('.DejavoCP-table-items').hasClass('DejavoCP-table-items-loaded')) {
        DejavoCP_load_data('table');
      }

      DejavoCP_open_bar();
      DejavoCP_open_table();
    }

  });

  function DejavoCP_search() {
    $('.DejavoCP-search-result').html('').addClass('DejavoCP-loading');
    // ajax search product
    DejavoCP_timer = null;

    var data = {
      action: 'DejavoCP_search',
      keyword: $('#DejavoCP_search_input').val(),
    };

    $.post(DejavoCP_vars.ajax_url, data, function(response) {
      $('.DejavoCP-search-result').
      html(response).
      removeClass('DejavoCP-loading');
    });
  }

  function DejavoCP_set_cookie(cname, cvalue, exdays) {
    var d = new Date();

    d.setTime(d.getTime() + (
        exdays * 24 * 60 * 60 * 1000
    ));

    var expires = 'expires=' + d.toUTCString();

    document.cookie = cname + '=' + cvalue + '; ' + expires + '; path=/';
  }

  function DejavoCP_get_cookie(cname) {
    var name = cname + '=';
    var ca = document.cookie.split(';');

    for (var i = 0; i < ca.length; i++) {
      var c = ca[i];

      while (c.charAt(0) == ' ') {
        c = c.substring(1);
      }

      if (c.indexOf(name) == 0) {
        return decodeURIComponent(c.substring(name.length, c.length));
      }
    }

    return '';
  }

  function DejavoCP_get_products() {
    var cookie_products = DejavoCP_get_cookie_products();

    if (DejavoCP_get_cookie(cookie_products) != '') {
      return DejavoCP_get_cookie(cookie_products);
    } else {
      return '';
    }
  }

  function DejavoCP_save_products() {
    var cookie_products = DejavoCP_get_cookie_products();
    var products = [];

    $('.DejavoCP-bar-item').each(function() {
      var pid = $(this).attr('data-id');

      if (pid !== '') {
        products.push(pid);
      }
    });

    var products_str = products.join();

    DejavoCP_set_cookie(cookie_products, products_str, 7);
    DejavoCP_load_data('table');
  }



  function DejavoCP_add_product(product_id) {
    var count;
    var limit = false;
    var limit_notice = DejavoCP_vars.limit_notice;
    var cookie_products = DejavoCP_get_cookie_products();

    if (DejavoCP_get_cookie(cookie_products) !== '') {
      var products = DejavoCP_get_cookie(cookie_products).split(',');

      if (products.length < DejavoCP_vars.limit) {
        products = $.grep(products, function(value) {
          return value != product_id;
        });

        if (DejavoCP_vars.adding === 'append') {
          products.push(product_id);
        } else {
          products.unshift(product_id);
        }

        var products_str = products.join();

        DejavoCP_set_cookie(cookie_products, products_str, 7);
      } else {
        limit = true;
        limit_notice = limit_notice.replace('{limit}', DejavoCP_vars.limit);
      }

      count = products.length;
    } else {
      DejavoCP_set_cookie(cookie_products, product_id, 7);
      count = 1;
    }

    DejavoCP_change_count(count);
    $(document.body).trigger('DejavoCP_added', [count]);

    if (limit) {
      $('.DejavoCP-btn[data-id="' + product_id + '"]').removeClass('DejavoCP-btn-adding DejavoCP-adding');
      alert(limit_notice);
    } else {
      $('.DejavoCP-btn[data-id="' + product_id + '"]').
      removeClass('DejavoCP-btn-adding DejavoCP-adding').addClass('DejavoCP-btn-added DejavoCP-added').html(DejavoCP_vars.button_text_added);
    }
  }

  function DejavoCP_remove_product(product_id) {
    var count = 0;
    var cookie_products = DejavoCP_get_cookie_products();

    if (product_id !== 'all') {
      // remove one
      if (DejavoCP_get_cookie(cookie_products) != '') {
        var products = DejavoCP_get_cookie(cookie_products).split(',');

        products = $.grep(products, function(value) {
          return value != product_id;
        });

        var products_str = products.join();

        DejavoCP_set_cookie(cookie_products, products_str, 7);
        count = products.length;
      }

      $('.DejavoCP-btn[data-id="' + product_id + '"]').removeClass('DejavoCP-btn-added DejavoCP-added').html(DejavoCP_vars.button_text);

    } else {
      // remove all
      if (DejavoCP_get_cookie(cookie_products) != '') {
        DejavoCP_set_cookie(cookie_products, '', 7);
        count = 0;
      }

      $('.DejavoCP-btn').removeClass('DejavoCP-btn-added DejavoCP-added').html(DejavoCP_vars.button_text);
    }

    DejavoCP_change_count(count);
    $(document.body).trigger('DejavoCP_removed', [count]);
  }

  function DejavoCP_check_buttons() {
    var cookie_products = DejavoCP_get_cookie_products();

    if (DejavoCP_get_cookie(cookie_products) != '') {
      var products = DejavoCP_get_cookie(cookie_products).split(',');

      $('.DejavoCP-btn').removeClass('DejavoCP-btn-added DejavoCP-added').html(DejavoCP_vars.button_text);

      products.forEach(function(entry) {
        $('.DejavoCP-btn-' + entry).addClass('DejavoCP-btn-added DejavoCP-added').html(DejavoCP_vars.button_text_added);

      });
    }
  }

  function DejavoCP_load_data(get_data) {
    var data = {
      action: 'DejavoCP_load_data',
      get_data: get_data,
    };

    if (get_data === 'table') {
      $('.DejavoCP-table-inner').addClass('DejavoCP-loading');
    }



    $.post(DejavoCP_vars.ajax_url, data, function(response) {
      if (get_data === 'bar' || get_data === 'table') {
        // load bar
        $('.DejavoCP-bar-items').
        html(response.bar).
        addClass('DejavoCP-bar-items-loaded');

        $(document.body).trigger('DejavoCP_bar_loaded');
      }

      if (get_data === 'table') {
        // load table
        $('.DejavoCP-table-items').
        html(response.table).
        addClass('DejavoCP-table-items-loaded');

        if ($(window).width() >= 768) {
          if ((DejavoCP_vars.freeze_column === 'yes') &&
              (DejavoCP_vars.freeze_row === 'yes')) {
            // freeze row and column
            $('#DejavoCP_table').tableHeadFixer({'head': true, left: 1});
          } else if (DejavoCP_vars.freeze_column === 'yes') {
            // freeze column
            $('#DejavoCP_table').tableHeadFixer({'head': false, left: 1});
          } else if (DejavoCP_vars.freeze_row === 'yes') {
            // freeze row
            $('#DejavoCP_table').tableHeadFixer({'head': true});
          }
        } else {
          if (DejavoCP_vars.freeze_row === 'yes') {
            // freeze row
            $('#DejavoCP_table').tableHeadFixer({'head': true});
          }
        }



        $('.DejavoCP-table-inner').removeClass('DejavoCP-loading');
        DejavoCP_hide_empty();

        $(document.body).trigger('DejavoCP_table_loaded');
      }


    });
  }


  function DejavoCP_open_bar() {

    $('#DejavoCP-area').addClass('DejavoCP-area-open-bar');
    $('.DejavoCP-bar').addClass('DejavoCP-bar-open');

    $('.DejavoCP-bar-items').sortable({
      handle: 'img',
      update: function(event, ui) {
        DejavoCP_save_products();
      },
    });

    $(document.body).trigger('DejavoCP_bar_open');
  }

  function DejavoCP_close_bar() {
    $('#DejavoCP-area').removeClass('DejavoCP-area-open-bar');
    $('.DejavoCP-bar').removeClass('DejavoCP-bar-open');

    $(document.body).trigger('DejavoCP_bar_close');
  }



  function DejavoCP_open_table() {

    $('#DejavoCP-area').addClass('DejavoCP-area-open-table');
    $('.DejavoCP-table').addClass('DejavoCP-table-open');
    $('.DejavoCP-bar-btn').addClass('DejavoCP-bar-btn-open');

    if (DejavoCP_vars.bar_bubble === 'yes') {
      $('.DejavoCP-bar').removeClass('DejavoCP-bar-bubble');
    }

    $(document.body).trigger('DejavoCP_table_open');
  }

  function DejavoCP_close_table() {
    $('#DejavoCP-area').removeClass('DejavoCP-area-open DejavoCP-area-open-table');
    $('.DejavoCP-table').removeClass('DejavoCP-table-open');
    $('.DejavoCP-bar-btn').removeClass('DejavoCP-bar-btn-open');

    if (DejavoCP_vars.bar_bubble === 'yes') {
      $('.DejavoCP-bar').addClass('DejavoCP-bar-bubble');
    }

    $(document.body).trigger('DejavoCP_table_close');
  }

  function DejavoCP_toggle_table() {
    if ($('.DejavoCP-table').hasClass('DejavoCP-table-open')) {
      DejavoCP_close_table();
    } else {
      DejavoCP_open_table();
    }
  }

  function DejavoCP_open() {
    $('#DejavoCP-area').addClass('DejavoCP-area-open');
    DejavoCP_load_data('table');
    DejavoCP_open_bar();
    DejavoCP_open_table();

    $(document.body).trigger('DejavoCP_open');
  }

  function DejavoCP_close() {
    $('#DejavoCP-area').removeClass('DejavoCP-area-open');
    DejavoCP_close_bar();
    DejavoCP_close_table();

    $(document.body).trigger('DejavoCP_close');
  }

  function DejavoCP_toggle() {
    if ($('#DejavoCP-area').hasClass('DejavoCP-area-open')) {
      DejavoCP_close();
    } else {
      DejavoCP_open();
    }

    $(document.body).trigger('DejavoCP_toggle');
  }



  function DejavoCP_change_count(count) {
    if (count === 'first') {
      var products = DejavoCP_get_products();

      if (products != '') {
        var products_arr = products.split(',');

        count = products_arr.length;
      } else {
        count = 0;
      }
    }

    $('.DejavoCP-menu-item').each(function() {
      if ($(this).hasClass('menu-item-type-DejavoCP')) {
        $(this).find('.DejavoCP-menu-item-inner').attr('data-count', count);
      } else {
        $(this).
        addClass('menu-item-type-DejavoCP').
        find('a').
        wrapInner(
            '<span class="DejavoCP-menu-item-inner" data-count="' + count +
            '"></span>');
      }
    });

    $('#DejavoCP-area').attr('data-count', count);
    $('.DejavoCP-bar').attr('data-count', count);

    $('.DejavoCP-bar-items').removeClass('DejavoCP-bar-items-loaded');
    $('.DejavoCP-table-items').removeClass('DejavoCP-table-items-loaded');

    $(document.body).trigger('DejavoCP_change_count', [count]);
  }

  function DejavoCP_hide_empty() {
    $('.DejavoCP_table > tbody > tr').each(function() {
      var $tr = $(this);
      var _td = 0;
      var _empty = true;

      $tr.children('td').each(function() {
        if ((_td > 0) && ($(this).html().length > 0)) {
          _empty = false;
          return false;
        }
        _td++;
      });

      if (_empty) {
        $tr.addClass('tr-empty').remove();
      }
    });
  }




  function DejavoCP_copy_to_clipboard(el) {
    // resolve the element
    el = (typeof el === 'string') ? document.querySelector(el) : el;

    // handle iOS as a special case
    if (navigator.userAgent.match(/ipad|ipod|iphone/i)) {
      // save current contentEditable/readOnly status
      var editable = el.contentEditable;
      var readOnly = el.readOnly;

      // convert to editable with readonly to stop iOS keyboard opening
      el.contentEditable = true;
      el.readOnly = true;

      // create a selectable range
      var range = document.createRange();
      range.selectNodeContents(el);

      // select the range
      var selection = window.getSelection();
      selection.removeAllRanges();
      selection.addRange(range);
      el.setSelectionRange(0, 999999);

      // restore contentEditable/readOnly to original state
      el.contentEditable = editable;
      el.readOnly = readOnly;
    } else {
      el.select();
    }

    // execute copy command
    document.execCommand('copy');

    // alert
    alert(DejavoCP_vars.copied_text.replace('%s', el.value));
  }

  function DejavoCP_get_cookie_products() {
    return DejavoCP_vars.user_id !== '' ?
        'DejavoCP_products_' + DejavoCP_vars.user_id :
        'DejavoCP_products';
  }
})(jQuery);