jQuery(document).ready(function(){
    const $ = jQuery;
    const my_body = $('body');
    function Dej_decimal_places(num) {
        var match = ('' + num).match(/(?:\.(\d+))?(?:[eE]([+-]?\d+))?$/);
        if (!match) {
            return 0;
        }

        return Math.max(0, // Number of digits right of decimal point.
            (match[1] ? match[1].length : 0)
            - (match[2] ? +match[2] : 0));
    }

    $(document).on('click touch', '.minus_btn, .plus_btn',
        function() {
            // get values
            var $qty = $(this).closest('.quantity').find('.qty'),
                val = parseFloat($qty.val()),
                max = parseFloat($qty.attr('max')),
                min = parseFloat($qty.attr('min')), step = $qty.attr('step');

            // format values
            if (!val || val === '' || val === 'NaN') {
                val = 0;
            }
            if (max === '' || max === 'NaN') {
                max = '';
            }
            if (min === '' || min === 'NaN') {
                min = 0;
            }
            if (step === 'any' || step === '' || step === undefined ||
                parseFloat(step) === 'NaN') {
                step = 1;
            } else {
                step = parseFloat(step);
            }
            // change the value
            if ($(this).is('.plus_btn')) {
                if (max && (max === val || val > max)) {
                    $qty.val(max);
                } else {
                    $qty.val((val + step).toFixed(Dej_decimal_places(step)));
                }
            } else {

                if (min && (min === val || val < min)) {
                    $qty.val(min);
                } else if (val > 0) {
                    $qty.val((val - step).toFixed(Dej_decimal_places(step)));
                }
            }

            // trigger change event
            $qty.trigger('change');
        });


    $('.countdown_time').each(function() {
        var endTime = $(this).attr('data-times');
        $(this).countdown(endTime, function(tm) {
            $(this).html(tm.strftime('<div class="countdown_box"><span class="countdown days">%D </span><span class="cd_text">' + Dejavo_vars.countdown_d + '</span></div><div class="countdown_box"><span class="countdown hours">%H</span><span class="cd_text">' + Dejavo_vars.countdown_h + '</span></div><div class="countdown_box"><span class="countdown minutes">%M</span><span class="cd_text">' + Dejavo_vars.countdown_m + '</span></div><div class="countdown_box"><span class="countdown seconds"><div class="seconds">%S</div></span><span class="cd_text">' + Dejavo_vars.countdown_s + '</span></div>'));
        });
    });
    $('.countdown_time2').each(function() {
        var endTime = $(this).attr('data-times');
        $(this).countdown(endTime, function(tm) {
            $(this).html(tm.strftime('<span class="countdown days">%D</span> : <span class="countdown hours">%H</span> : <span class="countdown minutes">%M</span> : <span class="countdown seconds"><div class="seconds">%S</div></span>'));
        });
    });

    $('.search_cats_btn').click(function (e) {
        e.stopPropagation();
        $(this).parents('.dejavo_search').toggleClass('show-cats');
    });
    $(document).on("click", function (e) {
        const dejavo_search = $('.dejavo_search');
        if (!$(e.target).is(dejavo_search) && dejavo_search.hasClass('show-cats')  && dejavo_search.has(e.target).length === 0) {
            dejavo_search.removeClass('show-cats');
        }
    });

    $(document).scroll( function () {
        var distanceTop =$(document).scrollTop();
        if (distanceTop > 250) {
            $(".change_bg").addClass("active");
        } else if(distanceTop < 220){
             $(".change_bg").removeClass("active");
        }
    });

    const listItem = document.querySelectorAll('.mobile-list');

    function activateLink() {
        listItem.forEach( item => {
            item.classList.remove('active');
        });
        this.classList.add('active');
    }

    listItem.forEach( item => {
        item.addEventListener('click', activateLink);
    });


    if ($(window).width() < 992) {
        const subNavs = Array.prototype.slice.call(document.querySelectorAll('.dej_mobile_menu_side ul ul'));
        subNavs.forEach(function (el, i) {
            const containerli = el.parentNode.closest('li');
                const parentLink = containerli.querySelector(':scope > span');
                parentLink.addEventListener('click', function (ev) {
                    ev.stopPropagation();
                    $(this).parent('li').siblings().removeClass('open');
                    if (containerli.classList.contains('open')) {
                        containerli.classList.remove('open');
                    } else {
                        containerli.classList.add('open');
                    }
                });
            }
        );
    }


    $('.pro_size_pick span').on('click', function () {
        $($(this).addClass('active')).siblings().removeClass('active');
    });

    $(window).scroll(function () {
        if ($(this).scrollTop() > 400) {
            $('#BackToTop').css("display", "flex").fadeIn();
            $('#DejavoFC-count').css("display", "flex").fadeIn();
        } else {
            $('#BackToTop').fadeOut();
            $('#DejavoFC-count').fadeOut();
        }
    });
    // scroll body to 0px on click
    $('#BackToTop').click(function () {
        $('body,html').animate({
            scrollTop: 0
        }, 400);
        return false;
    });

    function dej_text_shorter(el, max_height) {
        let element = $(el)
        let text_height = element.innerHeight();

        if (text_height > max_height) {
            element.append('<button class="short_text_btn">' +
                '<span class="outer"><span>' + Dejavo_vars.see_more + ' </span> <i class="dej-angle-double-small-down"></i>' +
                '</span></button>');
        }

        $(document).on('click touch',el + ' .short_text_btn', function() {
            $(this).parents(el).toggleClass('show');
            if ($(this).parents(el).hasClass('show')) {
                $(this).find('.outer span').text(Dejavo_vars.shorter_txt);
            } else {
                $(this).find('.outer span').text(Dejavo_vars.see_more);
            }
        });

    }
    dej_text_shorter('.p_description', 200);
    dej_text_shorter('.dej_about_us.accordion .content', 100);


    const navdropdown = $('.mega_menu .parent, .mega_menu .mega_menu_el');
    const overlay2 = $('.overlay2');

    $(function() {
        navdropdown.on('mouseover', function() {
            overlay2.addClass('active');
        });
        navdropdown.on('mouseout', function() {
            overlay2.removeClass('active');
        });
    });
    let dejavo_loading = $('.dejavo_loading');
    dejavo_loading.delay(2500).addClass('hide');

    $(window).on('beforeunload', function () {
        dejavo_loading.removeClass('hide');
        setTimeout(function(){
            dejavo_loading.addClass('hide');
        } , 7500);
    });

    dejavo_loading.on('click', function() {
        dejavo_loading.addClass("hide");
    });


    $('#inline-popups, #share-popups, #video-popups, #login-popups').magnificPopup({
        delegate: 'a',
        removalDelay: 500,
        callbacks: {
            beforeOpen: function() {
                this.st.mainClass = this.st.el.attr('data-effect');
            }
        },
        midClick: true
    });
    if ($(window).width() < 600) {
        let acc_wid = $('.mob_accordion');
        let acc_title = $('.mob_accordion .w_title');
        let acc_content = $('.mob_accordion .accordion');
        acc_content.hide();
        acc_title.click(function () {
            if ($(this).parent(acc_wid).hasClass("active")) {
                acc_wid.removeClass("active").find(".accordion").slideUp();
            } else {
                $(".mob_accordion.active .accordion").slideUp();
                $(".mob_accordion.active").removeClass("active");
                $(this).parent(acc_wid).addClass("active").find(".accordion").slideDown();
            }
            return false;
        });
    }


    function Dejavo_show_side(element) {
        my_body.addClass(element).trigger('Dejavo_show_side');
    }
    function Dejavo_hide_side(element) {
        my_body.removeClass(element).trigger('Dejavo_hide_side');
    }
    function Dejavo_toggle_side(element) {
        if (my_body.hasClass(element)) {
            Dejavo_hide_side(element);
        } else {
            Dejavo_show_side(element);
        }
        my_body.trigger('Dejavo_toggle_side');
    }


    $(document).on('click touch', '.overlay-black, .Dejavo_close', function() {
        Dejavo_hide_side('dej_show_login_side');
        Dejavo_hide_side('show_shop_sidebar');
        Dejavo_hide_side('show_mobile_menu');
        Dejavo_hide_side('show_profile_sidebar');
    });
    $(document).on('click touch', '.open_login_side', function(e) {
        e.preventDefault();
        Dejavo_toggle_side('dej_show_login_side');
        if (my_body.hasClass('show_mobile_menu')) {
            Dejavo_hide_side('show_mobile_menu');
        }
        if (my_body.hasClass('show_shop_sidebar')) {
            Dejavo_hide_side('show_shop_sidebar');
        }

    });
    $(document).on('click touch', '.shop_sidebar_btn', function(e) {
        e.preventDefault();
        Dejavo_toggle_side('show_shop_sidebar');
    });
    $(document).on('click touch', '.dej_mobile_menu', function(e) {
        e.preventDefault();
        Dejavo_toggle_side('show_mobile_menu');
        if (my_body.hasClass('dej_show_login_side')) {
            Dejavo_hide_side('dej_show_login_side');
        }
        if (my_body.hasClass('show_shop_sidebar')) {
            Dejavo_hide_side('show_shop_sidebar');
        }

    });
    $(document).on('click touch', '.profile_sidebar_btn', function(e) {
        e.preventDefault();
        Dejavo_toggle_side('show_profile_sidebar');

    });
    $(document).on('click touch', '.cart-show', function(e) {
        if (my_body.hasClass('dej_show_login_side')) {
            Dejavo_hide_side('dej_show_login_side');
        }
        if (my_body.hasClass('show_mobile_menu')) {
            Dejavo_hide_side('show_mobile_menu');
        }
        if (my_body.hasClass('show_shop_sidebar')) {
            Dejavo_hide_side('show_shop_sidebar');
        }
    });
    $(document).on('click touch', '.dej_show_login', function (e) {
        e.preventDefault();
        $('.dej_login_form').toggleClass('show');
    });






    $(document).on('click touch', '.dej_tab_btn', function (e) {
        e.preventDefault();
        $(this).addClass('active');
        const Home = Dejavo_vars.home_url;
        const Dej_Ajax = Home + "/dej_ajax";
        let cat_id = $(this).data('cat-id');

        var ajax_url = Dej_Ajax + "/tabs_data/";
        $.ajax({
            type: 'POST',
            url: ajax_url,
            data: {
                cat_id: cat_id,
            },
            beforeSend: function () {
                $('.product_tabs').html('<div class="loader-3"></div>');
            },
            success: function (resp) {
                $('.product_tabs').html(resp);
            }
        });
    });


});






