'use strict';
(function($) {
  var DejavoFC_timeout = null;

  $(function() {
    // Reload the cart
    if (DejavoFC_vars.reload == 'yes') {
      DejavoFC_cart_reload();
    }
  });

  // Quick view
  $(document).on('click touch', '#DejavoFC-area .DejavoQV-link, #DejavoFC-area .DejavoQV-btn',
      function(e) {
        DejavoFC_hide_cart();
        e.preventDefault();
      });

  // Auto show
  $(document.body).on('added_to_cart', function(e, fragments, cart_hash, $button) {
    if (DejavoFC_vars.auto_show === 'yes') {
      setTimeout(function() {
        DejavoFC_show_cart();
      }, 100);
    }

    if ($button && $button.closest('.DejavoFC-save-for-later').length) {
      // refresh again
      $(document.body).trigger('wc_fragment_refresh');
    }
  });

  $(document.body).on('wc_fragments_loaded', function() {
    DejavoFC_cart_loaded();
  });

  $(document.body).on('wc_fragments_refreshed', function() {
    DejavoFC_cart_loaded();
  });

  // Reload cart/checkout
  $(document.body).on('DejavoFC_cart_reload', function() {
    if ((DejavoFC_vars.is_cart == '1') && $('form.woocommerce-cart-form').length) {
      $(document.body).trigger('wc_update_cart');
    }

    if ((DejavoFC_vars.is_checkout == '1') &&
        $('form.woocommerce-checkout').length) {
      $(document.body).trigger('update_checkout');
    }
  });

  // Manual show
  if (DejavoFC_vars.manual_show != '') {
    $(document).on('click touch', DejavoFC_vars.manual_show, function(e) {
      DejavoFC_toggle_cart();
      e.preventDefault();
    });
  }

  // Qty minus & plus
  $(document).
  on('click touch', '.DejavoFC-item-qty-plus, .DejavoFC-item-qty-minus',
      function() {
        // get values
        var $qty = $(this).closest('.DejavoFC-item-qty').find('.qty'),
            val = parseFloat($qty.val()),
            max = parseFloat($qty.attr('max')),
            min = parseFloat($qty.attr('min')), step = $qty.attr('step');

        // format values
        if (!val || val === '' || val === 'NaN') {
          val = 0;
        }

        if (max === '' || max === 'NaN') {
          max = '';
        }

        if (min === '' || min === 'NaN') {
          min = 0;
        }

        if (step === 'any' || step === '' || step === undefined ||
            parseFloat(step) === 'NaN') {
          step = 1;
        } else {
          step = parseFloat(step);
        }

        // change the value
        if ($(this).is('.DejavoFC-item-qty-plus')) {
          if (max && (max === val || val > max)) {
            $qty.val(max);
          } else {
            $qty.val((val + step).toFixed(DejavoFC_decimal_places(step)));
          }
        } else {
          if (val - step <= 0) {
            // remove item
            if ((DejavoFC_vars.confirm_remove === 'yes')) {
              if (confirm(DejavoFC_vars.confirm_remove_text)) {
                DejavoFC_remove_item($qty.closest('.DejavoFC-item'));
              }
            } else {
              DejavoFC_remove_item($qty.closest('.DejavoFC-item'));
            }

            return false;
          }

          if (min && (min === val || val < min)) {
            $qty.val(min);
          } else if (val > 0) {
            $qty.val((val - step).toFixed(DejavoFC_decimal_places(step)));
          }
        }

        // trigger change event
        $qty.trigger('change');
      });

  // Qty on change
  $(document).on('change', '.DejavoFC-area .qty', function() {
    var item_key = $(this).closest('.DejavoFC-item').attr('data-key');
    var item_qty = $(this).val();

    DejavoFC_update_qty(item_key, item_qty);
  });

  // Qty validate
  $(document).on('keyup', '.DejavoFC-area .qty', function() {
    var $this = $(this);

    if ($this.closest('.woopq-quantity-input').length) {
      // checked in WPC Product Quantity
      return;
    }

    if (DejavoFC_timeout != null) clearTimeout(DejavoFC_timeout);
    DejavoFC_timeout = setTimeout(DejavoFC_check_qty, 1000, $this);
  });

  // Remove item
  $(document).on('click touch', '.DejavoFC-area .DejavoFC-item-remove', function() {
    if (DejavoFC_vars.confirm_remove === 'yes') {
      if (confirm(DejavoFC_vars.confirm_remove_text)) {
        DejavoFC_remove_item($(this).closest('.DejavoFC-item'));
      }
    } else {
      DejavoFC_remove_item($(this).closest('.DejavoFC-item'));
    }
  });

  $(document).on('click touch', '.DejavoFC-overlay', function() {
    DejavoFC_hide_cart();
  });

  $(document).on('click touch', '.DejavoFC-close', function() {
    DejavoFC_hide_cart();
  });

  $(document).on('click touch', '.DejavoFC-continue-url', function() {
    var url = $(this).attr('data-url');

    DejavoFC_hide_cart();

    if (url !== '') {
      window.location.href = url;
    }
  });

  $(document).on('click touch', '.DejavoFC-empty-cart', function() {
    var data = {
      action: 'DejavoFC_empty_cart', security: DejavoFC_vars.nonce,
    };

    if (DejavoFC_vars.confirm_empty === 'yes') {
      if (confirm(DejavoFC_vars.confirm_empty_text)) {
        DejavoFC_cart_loading();

        $.post(DejavoFC_vars.ajax_url, data, function(response) {
          DejavoFC_cart_reload();
          $(document.body).trigger('DejavoFC_cart_emptied');
        });
      }
    } else {
      DejavoFC_cart_loading();

      $.post(DejavoFC_vars.ajax_url, data, function(response) {
        DejavoFC_cart_reload();
        $(document.body).trigger('DejavoFC_cart_emptied');
      });
    }
  });

  // Count button
  $(document).on('click touch', '.DejavoFC-count', function(e) {
    DejavoFC_toggle_cart();

    e.preventDefault();
  });

  // Menu item
  $(document).on('click touch', '.DejavoFC-menu-item a', function(e) {
    if (DejavoFC_vars.cart_url != '') {
      window.location.href = DejavoFC_vars.cart_url;
    } else {
      DejavoFC_toggle_cart();
    }

    e.preventDefault();
  });

  // Cart
  $(document).on('click touch', '.DejavoFC-cart, .DejavoFC-btn', function(e) {
    DejavoFC_toggle_cart();

    e.preventDefault();
  });

  // Cart link
  $(document).on('click touch', '.DejavoFC-cart-link a', function(e) {
    if (DejavoFC_vars.cart_url != '') {
      window.location.href = DejavoFC_vars.cart_url;
    } else {
      DejavoFC_toggle_cart();
    }

    e.preventDefault();
  });


  $(document).on('click touch', '.DejavoFC-undo a', function(e) {
    e.preventDefault();
    DejavoFC_cart_loading();

    var undo_key = $('body').attr('DejavoFC-undo-key');
    var data = {
      action: 'DejavoFC_undo_remove',
      item_key: undo_key,
      security: DejavoFC_vars.nonce,
    };

    $.post(DejavoFC_vars.ajax_url, data, function(response) {
      DejavoFC_cart_reload();
    });

    $('body').attr('DejavoFC-undo-key', '');
    $('body').attr('DejavoFC-undo-name', '');
  });
})(jQuery);

function DejavoFC_decimal_places(num) {
  var match = ('' + num).match(/(?:\.(\d+))?(?:[eE]([+-]?\d+))?$/);
  if (!match) {
    return 0;
  }

  return Math.max(0, // Number of digits right of decimal point.
      (match[1] ? match[1].length : 0)
      - (match[2] ? +match[2] : 0));
}

function DejavoFC_update_qty(cart_item_key, cart_item_qty) {
  DejavoFC_cart_loading();

  var data = {
    action: 'DejavoFC_update_qty',
    cart_item_key: cart_item_key,
    cart_item_qty: cart_item_qty,
    security: DejavoFC_vars.nonce,
  };

  jQuery.post(DejavoFC_vars.ajax_url, data, function(response) {
    DejavoFC_cart_reload();

    jQuery(document.body).
    trigger('DejavoFC_update_qty', [cart_item_key, cart_item_qty]);
  });
}

function DejavoFC_remove_item($item) {
  var cart_item_key = $item.attr('data-key');
  var cart_item_name = $item.attr('data-name');

  DejavoFC_cart_loading();

  var data = {
    action: 'DejavoFC_remove_item',
    cart_item_key: cart_item_key,
    security: DejavoFC_vars.nonce,
  };

  jQuery.post(DejavoFC_vars.ajax_url, data, function(response) {
    if (!response || !response.fragments) {
      return;
    }

    jQuery(document.body).
    trigger('removed_from_cart', [response.fragments, response.cart_hash]);

    jQuery('body').attr('DejavoFC-undo-key', cart_item_key);
    jQuery('body').attr('DejavoFC-undo-name', cart_item_name);

    DejavoFC_cart_reload();

    jQuery(document.body).
    trigger('DejavoFC_remove_item', [cart_item_key, cart_item_name, response]);
  });
}

function DejavoFC_cart_loading() {
  jQuery('.DejavoFC-inner').addClass('DejavoFC-inner-loading');
  jQuery('.DejavoFC-count').
  addClass('DejavoFC-count-loading').
  removeClass('DejavoFC-count-shake');

  jQuery(document.body).trigger('DejavoFC_cart_loading');
}

function DejavoFC_cart_reload() {
  jQuery(document.body).trigger('wc_fragment_refresh');
  jQuery(document.body).trigger('DejavoFC_cart_reload');
}

function DejavoFC_cart_loaded() {
  jQuery('.DejavoFC-inner').removeClass('DejavoFC-inner-loading');
  jQuery('.DejavoFC-count').
  removeClass('DejavoFC-count-loading').
  addClass('DejavoFC-count-shake');

  if ((DejavoFC_vars.undo_remove == 'yes') &&
      (jQuery('body').attr('DejavoFC-undo-key') != undefined) &&
      (jQuery('body').attr('DejavoFC-undo-key') != '')) {
    var undo_name = 'Item';

    if ((jQuery('body').attr('DejavoFC-undo-name') != undefined) &&
        (jQuery('body').attr('DejavoFC-undo-name') != '')) {
      undo_name = '"' + jQuery('body').attr('DejavoFC-undo-name') + '"';
    }

    jQuery('.DejavoFC-cart-area .DejavoFC-area-mid').find('.DejavoFC-undo').remove();
    jQuery('.DejavoFC-cart-area .DejavoFC-area-mid').
    prepend('<div class="DejavoFC-undo"><div class="DejavoFC-undo-inner">' +
        DejavoFC_vars.removed_text.replace('%s', undo_name) + ' <a href="#">' +
        DejavoFC_vars.undo_remove_text + '</a></div></div>');
  }
  jQuery(document.body).trigger('DejavoFC_cart_loaded');
}




function DejavoFC_show_cart() {
  jQuery('body').addClass('DejavoFC-show');

  jQuery(document.body).trigger('DejavoFC_show_cart');
}

function DejavoFC_hide_cart() {
  jQuery('body').removeClass('DejavoFC-show DejavoFC-show-checkout');

  jQuery(document.body).trigger('DejavoFC_hide_cart');
}

function DejavoFC_toggle_cart() {
  if (jQuery('body').hasClass('DejavoFC-show')) {
    DejavoFC_hide_cart();
  } else {
    DejavoFC_show_cart();
  }

  jQuery(document.body).trigger('DejavoFC_toggle_cart');
}

function DejavoFC_check_qty($qty) {
  var is_remove = false;
  var val = parseFloat($qty.val());
  var min = parseFloat($qty.attr('min'));
  var max = parseFloat($qty.attr('max'));
  var step = parseFloat($qty.attr('step'));
  var fix = Math.pow(10, Number(DejavoFC_decimal_places(step)) + 1);

  if ((val === '') || isNaN(val)) {
    val = 0;
  }

  if ((min === '') || isNaN(min)) {
    min = 0;
  }

  if ((step === '') || isNaN(step)) {
    step = 1;
  }

  var remainder = DejavoFC_float_remainder(val, step);

  if (remainder >= 0) {
    val = Math.round((val - remainder) * fix) / fix;
  }

  if (val < min || val <= 0) {
    is_remove = true;
    val = min;
  }

  if (!isNaN(max) && (val > max)) {
    val = max;
  }

  $qty.val(val);

  if (is_remove) {
    if ((DejavoFC_vars.confirm_remove === 'yes')) {
      if (confirm(DejavoFC_vars.confirm_remove_text)) {
        DejavoFC_remove_item($qty.closest('.DejavoFC-item'));
      }
    } else {
      DejavoFC_remove_item($qty.closest('.DejavoFC-item'));
    }
  }
}

function DejavoFC_decimal_places(num) {
  var match = ('' + num).match(/(?:\.(\d+))?(?:[eE]([+-]?\d+))?$/);

  if (!match) {
    return 0;
  }

  return Math.max(0, // Number of digits right of decimal point.
      (match[1] ? match[1].length : 0)
      // Adjust for scientific notation.
      - (match[2] ? +match[2] : 0));
}

function DejavoFC_float_remainder(val, step) {
  var valDecCount = (val.toString().split('.')[1] || '').length;
  var stepDecCount = (step.toString().split('.')[1] || '').length;
  var decCount = valDecCount > stepDecCount ? valDecCount : stepDecCount;
  var valInt = parseInt(val.toFixed(decCount).replace('.', ''));
  var stepInt = parseInt(step.toFixed(decCount).replace('.', ''));
  return (valInt % stepInt) / Math.pow(10, decCount);
}