'use strict';

var DejavoQV_ids = [], DejavoQV_products = [];

(function($) {
  $(function() {
    $('.DejavoQV-btn, .DejavoQV-link').each(function() {
      var id = $(this).attr('data-id');
      var pid = $(this).attr('data-pid');
      var product_id = $(this).attr('data-product_id');

      if (typeof pid !== typeof undefined && pid !== false) {
        id = pid;
      }

      if (typeof product_id !== typeof undefined && product_id !== false) {
        id = product_id;
      }
      if (-1 === $.inArray(id, DejavoQV_ids)) {
        DejavoQV_ids.push(id);
        DejavoQV_products.push({src: DejavoQV_vars.ajax_url + '?product_id=' + id});
      }
    });
  });

  $(document).on('click touch', '[href*="#DejavoQV-"]', function(e) {
    var $this = $(this);
    var href = $this.attr('href');
    var reg = /#DejavoQV-([0-9]+)/g;
    var match = reg.exec(href);

    if (match[1] !== undefined) {
      var id = match[1];
      var effect = $this.attr('data-effect');
      var context = $this.attr('data-context');

      DejavoQV_open(id, effect, context);
      e.preventDefault();
    }
  });

  $(document).on('click touch', '.DejavoQV-btn, .DejavoQV-link', function(e) {
    e.preventDefault();

    var $this = $(this);
    var id = $this.attr('data-id');
    var pid = $this.attr('data-pid');
    var product_id = $this.attr('data-product_id');
    var effect = $this.attr('data-effect');
    var context = $this.attr('data-context');

    if (typeof pid !== typeof undefined && pid !== false) {
      id = pid;
    }

    if (typeof product_id !== typeof undefined && product_id !== false) {
      id = product_id;
    }

    DejavoQV_open(id, effect, context);
  });

  $(document).on('added_to_cart', function() {
    if (DejavoQV_vars.auto_close === 'yes') {

      $.magnificPopup.close();


      DejavoQV_close();
    }
  });

  $(document).on('DejavoQV_loaded', function() {
    var form_variation = $('#DejavoQV-popup').find('.variations_form');

    form_variation.each(function() {
      $(this).wc_variation_form();
    });

    DejavoQV_init_content('loaded');

    // add redirect
    if (!$('#DejavoQV-popup .DejavoQV-redirect').length) {
      if ((DejavoQV_vars.cart_redirect === 'yes') &&
          (DejavoQV_vars.cart_url !== '')) {
        $('#DejavoQV-popup form').
        prepend(
            '<input class="DejavoQV-redirect" name="DejavoQV-redirect" type="hidden" value="' +
            DejavoQV_vars.cart_url + '"/>');
      } else {
        $('#DejavoQV-popup form').
        prepend(
            '<input class="DejavoQV-redirect" name="DejavoQV-redirect" type="hidden" value="' +
            window.location.href + '"/>');
      }
    }
  });

  $(window).on('resize', function() {
    DejavoQV_init_content('resize');
  });

  $(document).on('found_variation', function(e, t) {
    if ($(e['target']).closest('#DejavoQV-popup').length) {
      if (t['image_id'] !== undefined) {
        if ($('#DejavoQV-popup .thumbnails .thumbnail').length > 1) {
          var $thumb = $(
              '.thumbnail:not(.slick-cloned)[data-id="' + t['image_id'] + '"]');

          if ($thumb.length) {
            var pos = $('#DejavoQV-popup .thumbnails .thumbnail').index($thumb);
            var $images = $('#DejavoQV-popup .thumbnails .images');

            if ((pos > 0) && $images.hasClass('slick-initialized')) {
              setTimeout(function() {
                $images.slick('slickGoTo', pos - 1);
              }, 100);
            }
          }
        }
      }
    }
  });

  $(document).on('reset_data', function(e) {
    if ($(e['target']).closest('#DejavoQV-popup').length) {
      if (($('#DejavoQV-popup .thumbnails .thumbnail').length > 1) &&
          $('#DejavoQV-popup .thumbnails .images').hasClass('slick-initialized')) {
        $('#DejavoQV-popup .thumbnails .images').slick('slickGoTo', 0);
      }
    }
  });

  if (DejavoQV_vars.hashchange === 'yes') {
    $(window).on('hashchange', function() {
      if (location.href.indexOf('#DejavoQV') < 0) {
        $.magnificPopup.close();
        DejavoQV_close();
      }
    });
  }

  $(document).on('click touch', '.DejavoQV-overlay, .DejavoQV-close', function() {
    DejavoQV_close();
  });
})(jQuery);

function DejavoQV_open(id, effect, context) {
  jQuery('body').addClass('DejavoQV-open');
  // popup
  if (-1 === jQuery.inArray(id, DejavoQV_ids)) {
    DejavoQV_ids.push(id);
    DejavoQV_products.push({src: DejavoQV_vars.ajax_url + '?product_id=' + id});
  }

  var index = DejavoQV_get_key(DejavoQV_products, 'src',
      DejavoQV_vars.ajax_url + '?product_id=' + id);
  var main_class = 'mfp-DejavoQV';

  if (typeof context !== typeof undefined && context !== false) {
    main_class = main_class + ' mfp-DejavoQV-' + context;
  }

  if (typeof effect !== typeof undefined && effect !== false) {
    main_class = main_class + ' ' + effect;
  } else {
    main_class = main_class + ' ' + DejavoQV_vars.effect;
  }

  jQuery.magnificPopup.open({
    items: DejavoQV_products,
    type: 'ajax',
    mainClass: main_class,
    removalDelay: 160,
    overflowY: 'scroll',
    fixedContentPos: true,
    tClose: DejavoQV_vars.close,
    gallery: {
      tPrev: DejavoQV_vars.prev, tNext: DejavoQV_vars.next, enabled: true,
    },
    ajax: {
      settings: {
        type: 'GET', data: {
          action: 'DejavoQV_quickview',
        },
      },
    },
    callbacks: {
      open: function() {
        if (DejavoQV_vars.hashchange === 'yes') {
          location.href = location.href.split('#')[0] + '#DejavoQV';
        }
      }, ajaxContentAdded: function() {
        jQuery(document.body).trigger('DejavoQV_loaded', [id]);
      }, close: function() {
        if (DejavoQV_vars.hashchange === 'yes') {
          if (location.hash) history.go(-1);
        }
      }, afterClose: function() {
        jQuery(document.body).trigger('DejavoQV_close', [id]);
      },
    },
  }, index);


  jQuery(document.body).trigger('DejavoQV_open', [id]);
}

function DejavoQV_close() {
  jQuery('body').removeClass('DejavoQV-open');
  jQuery(document.body).trigger('DejavoQV_close');
}


function DejavoQV_init_content(context) {
  if (context === 'loaded') {
    DejavoQV_thumbnails_zoom();
    DejavoQV_thumbnails_slick();
    DejavoQV_related_slick();
  }

}

function DejavoQV_get_key(array, key, value) {
  for (var i = 0; i < array.length; i++) {
    if (array[i][key] === value) {
      return i;
    }
  }

  return -1;
}

function DejavoQV_thumbnails_zoom() {
  if (DejavoQV_vars.thumbnails_effect === 'zoom') {
    jQuery('#DejavoQV-popup .thumbnails .images .thumbnail').each(function() {
      var $this = jQuery(this);
      var zoom_params = JSON.parse(DejavoQV_vars.thumbnails_zoom_params);

      zoom_params.url = $this.find('img').attr('data-src');

      // destroy first
      $this.trigger('zoom.destroy');
      $this.zoom(zoom_params);
    });
  }
}

function DejavoQV_thumbnails_slick() {
  if (jQuery('#DejavoQV-popup .thumbnails .images .thumbnail').length > 1) {
    if (jQuery('#DejavoQV-popup .thumbnails .images').
    hasClass('slick-initialized')) {
      // unslick first
      jQuery('#DejavoQV-popup .thumbnails .images').slick('unslick');
    }

    jQuery('#DejavoQV-popup .thumbnails .images').
    slick(JSON.parse(DejavoQV_vars.thumbnails_slick_params));
  }
}

function DejavoQV_related_slick() {
  if (jQuery('.DejavoQV-related-products').hasClass('slick-initialized')) {
    // unslick first
    jQuery('.DejavoQV-related-products').slick('unslick');
  }

  if (jQuery('.DejavoQV-related-product').length > 1) {
    jQuery('.DejavoQV-related-products').
    slick(JSON.parse(DejavoQV_vars.related_slick_params));
  }
}