(function($) {
  $(document).on('found_variation', 'form.cart', function(e, t) {
    var pid = $(e['target']).closest('.variations_form.cart').attr('data-product_id');
      // change price
      if (t['price_html'] !== undefined && t['price_html'] !== '') {
          $('.DejavoSA-price-ori').hide();
          $('.DejavoSA-price-new').html(t['price_html']).show();
      } else {
          $('.DejavoSA-price-new').html('').hide();
          $('.DejavoSA-price-ori').show();
      }
      // change image
      if (t['image']['url'] && t['image']['url'] !== '') {
          var image_src = t['image']['url'];

          if (t['image']['thumb_src'] && t['image']['thumb_src'] !== '') {
              image_src = t['image']['thumb_src'];
          }
          $('.DejavoSA-image-ori').hide();

          if (t['image']['srcset'] && t['image']['srcset'] !== '') {
              $('.DejavoSA-image-new').
              html('<img src="' + image_src + '" srcset="' +
                  t['image']['srcset'] + '"/>').
              show();
          } else {
              $('.DejavoSA-image-new').
              html('<img src="' + image_src + '"/>').
              show();
          }
      } else {
          $('.DejavoSA-image-ori').show();
          $('.DejavoSA-image-new').html('').hide();
      }
    // change buttons
    $('.DejavoSA-wrapper .DejavoCP-btn, .DejavoSA-wrapper .DejavoWL-btn').
        attr('data-id', t['variation_id']);

    if (t['is_in_stock'] && t['is_purchasable']) {
      $('.DejavoSA-add-to-cart[data-product_id="' + pid + '"] .DejavoSA-btn').
          removeClass('DejavoSA-disabled');
    } else {
      $('.DejavoSA-add-to-cart[data-product_id="' + pid + '"] .DejavoSA-btn').
          addClass('DejavoSA-disabled');
    }
    $(document).trigger('DejavoSA_found_variation', [t]);
  });
  $(document).on('reset_data', function(e) {
    var pid = $(e['target']).
        closest('.variations_form').
        attr('data-product_id');

    // reset price
    $('.DejavoSA-price-new').html('').hide();
    $('.DejavoSA-price-ori').show();

    // reset image
    $('.DejavoSA-image-ori').show();
    $('.DejavoSA-image-new').html('').hide();

    // reset buttons
    $('.DejavoSA-wrapper .DejavoCP-btn, .DejavoSA-wrapper .DejavoWL-btn').
        attr('data-id', pid);

    // disable button
    $('.DejavoSA-add-to-cart[data-product_id="' + pid + '"] .DejavoSA-btn').
        addClass('DejavoSA-disabled');

    $(document).trigger('DejavoSA_reset_data');
  });
  $(document).on('click touch', '.DejavoSA-btn', function(e) {
    e.preventDefault();

    if ($(this).hasClass('DejavoSA-disabled')) {
      DejavoSA_scroll();
    } else {
      var $btn = $('.single_add_to_cart_button');

      if ($btn.hasClass('disabled') || $btn.hasClass('DejavoSA-disabled'))
          { DejavoSA_scroll(); } else {
        $btn.trigger('click');
      }
    }

    $(document).trigger('DejavoSA_btn_clicked');
  });
  $(document).on('click keyup keydown paste', '.DejavoSA-qty', function() {
    // DejavoSA-qty
    var qty = $(this).val();
    var product_id = $(this).closest('.DejavoSA-add-to-cart').data('product_id');

    $('.DejavoSA-id-' + product_id).
        closest('form.cart').
        find('.qty').
        val(qty).
        trigger('change');

    $(document).trigger('DejavoSA_change_qty', [qty, product_id]);
  });
  $(document).on('click keyup keydown paste', 'form.cart .qty', function() {
    // main qty
    var qty = $(this).val();
    var product_id = $(this).
        closest('form.cart').
        find('.DejavoSA-id').
        data('product_id');

    $('.DejavoSA-qty-' + product_id).val(qty).trigger('change');

    $(document).trigger('DejavoSA_change_main_qty', [qty, product_id]);
  });
  $(window).on('scroll', function() {
    if ((($(window).scrollTop() + $(window).height() +
            parseInt(350)) >= $(document).height()) ||
        (($(window).scrollTop() - parseInt(600)) <= 0)) {
      DejavoSA_hide();
    } else {
      DejavoSA_show();
    }
  });
  function DejavoSA_show() {
    $('.DejavoSA-wrapper').addClass('DejavoSA-active');
  }
  function DejavoSA_hide() {
    $('.DejavoSA-wrapper').removeClass('DejavoSA-active');
  }
  function DejavoSA_scroll() {
    $('html, body').animate({
      scrollTop: $('form.cart').offset().top - 100,
    }, 300);
    $(document).trigger('DejavoSA_scroll');
  }
})(jQuery);