'use strict';

(function($) {
  var $storage = true;
  var added_ids = [];
  var key = Cookies.get('DejavoWL_key');

  try {
    $storage = ('sessionStorage' in window && window.sessionStorage !== null);
    window.sessionStorage.setItem('DejavoWL', 'test');
    window.sessionStorage.removeItem('DejavoWL');
  } catch (err) {
    $storage = false;
  }

  $(function() {
    if (key === null || key === undefined || key === '') {
      key = DejavoWL_get_key();
      Cookies.set('DejavoWL_key', key, {expires: 7});
    }

    // Load data for the first time
    DejavoWL_load_data();

    if ($('.DejavoWL-custom-menu-item').length) {
      // load the count when having a custom menu item
      DejavoWL_load_count();
    }

    if (DejavoWL_vars.button_action === 'message') {
      $.notiny.addTheme('DejavoWL', {
        notification_class: 'notiny-theme-DejavoWL',
      });
    }
  });

  $(document).on('DejavoWL_refresh_count', function() {
    DejavoWL_load_count();
  });



  // found variation
  $(document).on('found_variation', function(e, t) {
    var product_id = $(e['target']).attr('data-product_id');

    // change id
    $('.DejavoWL-btn-' + product_id).
    attr('data-id', t.variation_id).
    removeClass('DejavoWL-btn-added DejavoWL-added');

    // refresh button
    DejavoWL_refresh_button_id(t.variation_id);
  });

  // reset data
  $(document).on('reset_data', function(e) {
    var product_id = $(e['target']).attr('data-product_id');

    // change id
    $('.DejavoWL-btn-' + product_id).
    attr('data-id', product_id).
    removeClass('DejavoWL-btn-added DejavoWL-added');

    // refresh button
    DejavoWL_refresh_button_id(product_id);
  });

  // quick view
  $(document).on('click touch',
      '#DejavoWL_wishlist .DejavoQV-link, #DejavoWL_wishlist .DejavoQV-btn',
      function(e) {
        DejavoWL_wishlist_hide();
        e.preventDefault();
      });

  // add to wishlist
  $(document).on('click touch', '.DejavoWL-btn', function(e) {
    var $this = $(this);
    var id = $this.attr('data-id');
    var pid = $this.attr('data-pid');
    var product_id = $this.attr('data-product_id');
    var product_name = $this.attr('data-product_name');
    var product_image = $this.attr('data-product_image');

    if (typeof pid !== typeof undefined && pid !== false) {
      id = pid;
    }

    if (typeof product_id !== typeof undefined && product_id !== false) {
      id = product_id;
    }

    var data = {
      action: 'wishlist_add', product_id: id,
    };

    if ($this.hasClass('DejavoWL-added')) {
      if (DejavoWL_vars.button_action_added === 'page') {
        // open wishlist page
        window.location.href = DejavoWL_vars.wishlist_url;
      } else {
        // open wishlist popup
        if ($('#DejavoWL_wishlist').hasClass('DejavoWL-loaded')) {
          DejavoWL_wishlist_show();
        } else {
          DejavoWL_wishlist_load();
        }
      }
    } else {
      $this.addClass('DejavoWL-adding');

      $.post(DejavoWL_vars.ajax_url, data, function(response) {
        $this.removeClass('DejavoWL-adding');

        if (DejavoWL_vars.button_action === 'list') {
          if (response.content != null) {
            $('#DejavoWL_wishlist').
            html(response.content).
            addClass('DejavoWL-loaded');
          }

          if (response.notice != null) {
            DejavoWL_notice(response.notice.replace('{name}',
                '<strong>' + product_name + '</strong>'));
          }

          DejavoWL_wishlist_show();
        }

        if (DejavoWL_vars.button_action === 'message') {
          $('#DejavoWL_wishlist').removeClass('DejavoWL-loaded');

          $.notiny({
            theme: 'DejavoWL',
            position: DejavoWL_vars.message_position,
            image: product_image,
            text: response.notice.replace('{name}',
                '<strong>' + product_name + '</strong>'),
          });
        }

        if (DejavoWL_vars.button_action === 'no') {
          // add to wishlist solely
          $('#DejavoWL_wishlist').removeClass('DejavoWL-loaded');
        }

        if (response.count != null) {
          DejavoWL_change_count(response.count);
        }

        if (response.status === 1) {
          DejavoWL_refresh_button_id(id);
        }

        if ($storage && response.data) {
          sessionStorage.setItem('DejavoWL_data_' + response.data.key,
              JSON.stringify(response.data));
        }

        if (response.data.fragments) {
          DejavoWL_refresh_fragments(response.data.fragments);
        }

        if (response.data.ids) {
          DejavoWL_refresh_buttons(response.data.ids);
          DejavoWL_refresh_ids(response.data.ids);
        }

        $(document.body).trigger('DejavoWL_add', [id]);
      });
    }

    e.preventDefault();
  });

  // remove from wishlist
  $(document).on('click touch', '.DejavoWL-item--remove span', function(e) {
    var $this = $(this);
    var key = $this.closest('.DejavoWL-popup-inner').data('key');
    var $this_item = $this.closest('.DejavoWL-item');
    var product_id = $this_item.attr('data-id');
    var data = {
      action: 'wishlist_remove', product_id: product_id, key: key,
    };

    $this.addClass('DejavoWL-removing');

    $.post(DejavoWL_vars.ajax_url, data, function(response) {
      $this.removeClass('DejavoWL-removing');
      $this_item.remove();

      if (response.content != null) {
        $('#DejavoWL_wishlist').html(response.content).addClass('DejavoWL-loaded');
      }

      if (response.notice != null) {
        DejavoWL_notice(response.notice);
      }

      if (response.count != null) {
        DejavoWL_change_count(response.count);
      }

      if ($storage && response.data) {
        sessionStorage.setItem('DejavoWL_data_' + response.data.key,
            JSON.stringify(response.data));
      }

      if (response.data.fragments) {
        DejavoWL_refresh_fragments(response.data.fragments);
      }

      if (response.data.ids) {
        DejavoWL_refresh_buttons(response.data.ids);
        DejavoWL_refresh_ids(response.data.ids);
      }

      $(document.body).trigger('DejavoWL_remove', [product_id]);
    });

    e.preventDefault();
  });

  // empty wishlist
  $(document).on('click touch', '.DejavoWL-empty', function(e) {
    var $this = $(this);

    if (confirm(DejavoWL_vars.empty_confirm)) {
      DejavoWL_popup_loading();

      var key = $this.closest('.DejavoWL-popup-inner').data('key');
      var data = {
        action: 'wishlist_empty', key: key,
      };

      $.post(DejavoWL_vars.ajax_url, data, function(response) {
        if (response.content != null) {
          $('#DejavoWL_wishlist').html(response.content).addClass('DejavoWL-loaded');
        }

        if (response.notice != null) {
          DejavoWL_notice(response.notice);
        }

        if (response.count != null) {
          DejavoWL_change_count(response.count);
        }

        if ($storage && response.data) {
          sessionStorage.setItem('DejavoWL_data_' + response.data.key,
              JSON.stringify(response.data));
        }

        if (response.data.fragments) {
          DejavoWL_refresh_fragments(response.data.fragments);
        }

        if (response.data.ids) {
          DejavoWL_refresh_buttons(response.data.ids);
          DejavoWL_refresh_ids(response.data.ids);
        }

        DejavoWL_popup_loaded();

        $(document.body).trigger('DejavoWL_empty', [key]);
      });
    }

    e.preventDefault();
  });

  // click on area
  $(document).on('click touch', '.DejavoWL-popup', function(e) {
    var DejavoWL_content = $('.DejavoWL-popup-content');

    if ($(e.target).closest(DejavoWL_content).length == 0) {
      DejavoWL_wishlist_hide();
      DejavoWL_manage_hide();
    }
  });

  // continue
  $(document).on('click touch', '.DejavoWL-continue', function(e) {
    var url = $(this).attr('data-url');
    DejavoWL_wishlist_hide();

    if (url !== '') {
      window.location.href = url;
    }

    e.preventDefault();
  });

  // close
  $(document).
  on('click touch', '#DejavoWL_wishlist .DejavoWL-popup-close', function(e) {
    DejavoWL_wishlist_hide();
    e.preventDefault();
  });

  // manage close
  $(document).
  on('click touch', '#DejavoWL_manage .DejavoWL-popup-close', function(e) {
    DejavoWL_manage_hide();
    e.preventDefault();
  });

  // manage wishlists
  $(document).on('click touch', '.DejavoWL-manage', function(e) {
    e.preventDefault();
    DejavoWL_popup_loading();

    var data = {
      action: 'manage_wishlists',
    };

    $.post(DejavoWL_vars.ajax_url, data, function(response) {
      DejavoWL_wishlist_hide();
      $('#DejavoWL_manage').html(response);
      DejavoWL_manage_show();
      DejavoWL_popup_loaded();
    });
  });

  // add wishlist
  $(document).on('click touch', '#DejavoWL_add_wishlist', function(e) {
    e.preventDefault();
    DejavoWL_popup_loading();

    var name = $('#DejavoWL_wishlist_name').val();
    var data = {
      action: 'add_wishlist', name: name,
    };

    $.post(DejavoWL_vars.ajax_url, data, function(response) {
      $('#DejavoWL_manage').html(response);
      $('#DejavoWL_wishlist').removeClass('DejavoWL-loaded');
      DejavoWL_popup_loaded();
    });
  });

  // set default
  $(document).on('click touch', '.DejavoWL-set-default', function(e) {
    e.preventDefault();
    DejavoWL_popup_loading();

    var key = $(this).data('key');
    var data = {
      action: 'set_default', key: key,
    };

    $.post(DejavoWL_vars.ajax_url, data, function(response) {
      if (response.count != null) {
        DejavoWL_change_count(response.count);
      }

      if ((response.products != null) && response.products.length) {
        response.products.forEach((product_id) => {
          DejavoWL_refresh_button_id(product_id);
        });
      }

      $('#DejavoWL_manage').html(response.content);

      if ($storage && response.data) {
        sessionStorage.setItem('DejavoWL_data_' + response.data.key,
            JSON.stringify(response.data));
      }

      if (response.data.fragments) {
        DejavoWL_refresh_fragments(response.data.fragments);
      }

      if (response.data.ids) {
        DejavoWL_refresh_buttons(response.data.ids);
        DejavoWL_refresh_ids(response.data.ids);
      }

      $('#DejavoWL_wishlist').removeClass('DejavoWL-loaded');
      DejavoWL_popup_loaded();
    });
  });

  // delete wishlist
  $(document).on('click touch', '.DejavoWL-delete-wishlist', function(e) {
    e.preventDefault();

    if (confirm(DejavoWL_vars.delete_confirm)) {
      DejavoWL_popup_loading();

      var key = $(this).data('key');
      var data = {
        action: 'delete_wishlist', key: key,
      };

      $.post(DejavoWL_vars.ajax_url, data, function(response) {
        $('#DejavoWL_manage').html(response);
        $('#DejavoWL_wishlist').removeClass('DejavoWL-loaded');
        DejavoWL_popup_loaded();
      });
    }
  });

  // view wishlist
  $(document).on('click touch', '.DejavoWL-view-wishlist', function(e) {
    e.preventDefault();
    DejavoWL_popup_loading();

    var key = $(this).data('key');
    var data = {
      action: 'view_wishlist', key: key,
    };

    $.post(DejavoWL_vars.ajax_url, data, function(response) {
      DejavoWL_manage_hide();
      $('#DejavoWL_wishlist').removeClass('DejavoWL-loaded').html(response);
      DejavoWL_wishlist_show();
      DejavoWL_popup_loaded();
    });
  });

  // menu item
  $(document).
  on('click touch', '.DejavoWL-menu-item a, .DejavoWL-menu a', function(e) {
    if (DejavoWL_vars.menu_action === 'open_popup') {
      e.preventDefault();

      if ($('#DejavoWL_wishlist').hasClass('DejavoWL-loaded')) {
        DejavoWL_wishlist_show();
      } else {
        DejavoWL_wishlist_load();
      }
    }
  });

  // copy link
  $(document).
  on('click touch', '#DejavoWL_copy_url, #DejavoWL_copy_btn', function(e) {
    e.preventDefault();

    DejavoWL_copy_to_clipboard('#DejavoWL_copy_url');
  });



  // resize
  $(window).on('resize', function() {
    DejavoWL_fix_height();
  });

  function DejavoWL_wishlist_load() {
    var data = {
      action: 'wishlist_load',
    };

    $.post(DejavoWL_vars.ajax_url, data, function(response) {
      if (response.content != null) {
        $('#DejavoWL_wishlist').html(response.content);
      }

      if (response.count != null) {
        if ($('#DejavoWL_wishlist .DejavoWL-items .DejavoWL-item').length &&
            ($('#DejavoWL_wishlist .DejavoWL-items .DejavoWL-item').length !=
                response.count)) {
          DejavoWL_change_count(
              $('#DejavoWL_wishlist .DejavoWL-items .DejavoWL-item').length);
        } else {
          DejavoWL_change_count(response.count);
        }
      }

      if (response.notice != null) {
        DejavoWL_notice(response.notice);
      }

      $('#DejavoWL_wishlist').addClass('DejavoWL-loaded');
      DejavoWL_wishlist_show();
    });
  }

  function DejavoWL_load_count() {
    var data = {
      action: 'wishlist_load_count',
    };

    $.post(DejavoWL_vars.ajax_url, data, function(response) {
      if (response.count != null) {
        var count = response.count;

        DejavoWL_change_count(count);
        $(document.body).trigger('DejavoWL_load_count', [count]);
      }
    });
  }

  function DejavoWL_wishlist_show() {
    $('#DejavoWL_wishlist').addClass('DejavoWL-show');
    DejavoWL_fix_height();

    $(document.body).trigger('DejavoWL_wishlist_show');
  }

  function DejavoWL_wishlist_hide() {
    $('#DejavoWL_wishlist').removeClass('DejavoWL-show');
    $(document.body).trigger('DejavoWL_wishlist_hide');
  }

  function DejavoWL_manage_show() {
    $('#DejavoWL_manage').addClass('DejavoWL-show');
    $(document.body).trigger('DejavoWL_manage_show');
  }

  function DejavoWL_manage_hide() {
    $('#DejavoWL_manage').removeClass('DejavoWL-show');
    $(document.body).trigger('DejavoWL_manage_hide');
  }

  function DejavoWL_popup_loading() {
    $('.DejavoWL-popup').addClass('DejavoWL-loading');
  }

  function DejavoWL_popup_loaded() {
    $('.DejavoWL-popup').removeClass('DejavoWL-loading');
  }

  function DejavoWL_change_count(count) {
    $('#DejavoWL_wishlist .DejavoWL-count').html(count);

    if (parseInt(count) > 0) {
      $('.DejavoWL-empty').show();
    } else {
      $('.DejavoWL-empty').hide();
    }

    if ($('.DejavoWL-menu-item .DejavoWL-menu-item-inner').length) {
      $('.DejavoWL-menu-item .DejavoWL-menu-item-inner').attr('data-count', count);
    } else {
      $('.DejavoWL-menu-item a').
      html('<span class="DejavoWL-menu-item-inner" data-count="' + count +
          '"><i class="DejavoWL-icon"></i><span>' + DejavoWL_vars.menu_text +
          '</span></span>');
    }

    $(document.body).trigger('DejavoWL_change_count', [count]);
  }

  function DejavoWL_notice(notice) {
    $('.DejavoWL-notice').html(notice);
    DejavoWL_notice_show();
    setTimeout(function() {
      DejavoWL_notice_hide();
    }, 3000);
  }

  function DejavoWL_notice_show() {
    $('#DejavoWL_wishlist .DejavoWL-notice').addClass('DejavoWL-notice-show');
  }

  function DejavoWL_notice_hide() {
    $('#DejavoWL_wishlist .DejavoWL-notice').removeClass('DejavoWL-notice-show');
  }



  function DejavoWL_copy_url() {
    var DejavoWLURL = document.getElementById('DejavoWL_copy_url');
    DejavoWLURL.select();
    document.execCommand('copy');
    alert(DejavoWL_vars.copied_text + ' ' + DejavoWLURL.value);
  }

  function DejavoWL_copy_to_clipboard(el) {
    // resolve the element
    el = (typeof el === 'string') ? document.querySelector(el) : el;

    // handle iOS as a special case
    if (navigator.userAgent.match(/ipad|ipod|iphone/i)) {
      // save current contentEditable/readOnly status
      var editable = el.contentEditable;
      var readOnly = el.readOnly;

      // convert to editable with readonly to stop iOS keyboard opening
      el.contentEditable = true;
      el.readOnly = true;

      // create a selectable range
      var range = document.createRange();
      range.selectNodeContents(el);

      // select the range
      var selection = window.getSelection();
      selection.removeAllRanges();
      selection.addRange(range);
      el.setSelectionRange(0, 999999);

      // restore contentEditable/readOnly to original state
      el.contentEditable = editable;
      el.readOnly = readOnly;
    } else {
      el.select();
    }

    // execute copy command
    document.execCommand('copy');

    // alert
    alert(DejavoWL_vars.copied_text + ' ' + el.value);
  }

  function DejavoWL_html_entities(str) {
    return String(str).
    replace(/&/g, '&amp;').
    replace(/</g, '&lt;').
    replace(/>/g, '&gt;').
    replace(/"/g, '&quot;');
  }

  function DejavoWL_get_key() {
    var result = [];
    var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    var charactersLength = characters.length;

    for (var i = 0; i < 6; i++) {
      result.push(
          characters.charAt(Math.floor(Math.random() * charactersLength)));
    }

    return result.join('');
  }

  function DejavoWL_fix_height() {
    // fix for center only
    jQuery('.DejavoWL-popup-center .DejavoWL-popup-content').height(2 * Math.floor(
            jQuery('.DejavoWL-popup-center .DejavoWL-popup-content').height() / 2) +
        2);
  }

  function DejavoWL_load_data() {
    if ($storage) {
      try {
        var data = JSON.parse(sessionStorage.getItem('DejavoWL_data_' + key));

        if (data.fragments) {
          DejavoWL_refresh_fragments(data.fragments);
        }

        if (data.ids) {
          DejavoWL_refresh_buttons(data.ids);
          DejavoWL_refresh_ids(data.ids);
        }

        if (data.key && (key === null || key === undefined || key === '')) {
          Cookies.set('DejavoWL_key', data.key, {expires: 7});
        }
      } catch (err) {
        DejavoWL_get_data();
      }
    } else {
      DejavoWL_get_data();
    }
  }

  function DejavoWL_get_data() {
    var data = {
      action: 'DejavoWL_get_data',
    };

    $.post(DejavoWL_vars.ajax_url, data, function(response) {
      if (response) {
        if ($storage) {
          sessionStorage.setItem('DejavoWL_data_' + response.key,
              JSON.stringify(response));
        }

        if (response.fragments) {
          DejavoWL_refresh_fragments(response.fragments);
        }

        if (response.ids) {
          DejavoWL_refresh_buttons(response.ids);
          DejavoWL_refresh_ids(response.ids);
        }

        if (response.key &&
            (key === null || key === undefined || key === '' || key !==
                response.key)) {
          Cookies.set('DejavoWL_key', response.key, {expires: 7});
        }

        $(document.body).trigger('DejavoWL_data_refreshed', [response]);
      }
    });
  }

  function DejavoWL_refresh_fragments(fragments) {
    $.each(fragments, function(key, value) {
      $(key).replaceWith(value);
    });

    $(document.body).trigger('DejavoWL_fragments_refreshed', [fragments]);
  }

  function DejavoWL_refresh_ids(ids) {
    added_ids = ids;
  }

  function DejavoWL_refresh_buttons(ids) {
    $('.DejavoWL-btn').removeClass('DejavoWL-btn-added DejavoWL-added').html(DejavoWL_vars.button_text);

    $.each(ids, function(key, value) {
      $('.DejavoWL-btn-' + key).addClass('DejavoWL-btn-added DejavoWL-added').html(DejavoWL_vars.button_text_added);

      if (value.parent !== undefined) {
        $('.DejavoWL-btn-' + value.parent).addClass('DejavoWL-btn-added DejavoWL-added').html(DejavoWL_vars.button_text_added);

      }
    });

    $(document.body).trigger('DejavoWL_buttons_refreshed', [ids]);
  }

  function DejavoWL_refresh_button_id(id) {
    $('.DejavoWL-btn[data-id="' + id + '"]').removeClass('DejavoWL-btn-added DejavoWL-added').html(DejavoWL_vars.button_text);
    $.each(added_ids, function(key) {
      if (parseInt(key) === parseInt(id)) {
        $('.DejavoWL-btn[data-id="' + id + '"]').addClass('DejavoWL-btn-added DejavoWL-added').html(DejavoWL_vars.button_text_added);
      }
    });

    $(document.body).trigger('DejavoWL_refresh_button_id', [id, added_ids]);
  }
})(jQuery);