(function ($) { 'use strict';
    $(document).ready(function () {
        jQuery('.dej-product-gallery-slider img').removeAttr('srcset');
        $('.single-product-main-image img').load(function () {
            var imageObj = $('.single-product-main-image img');
            if (!(imageObj.width() == 1 && imageObj.height() == 1)) {
                $('.dej-thumb-main-image').attr('src', imageObj.attr('src'));
                $('.dej-thumb-main-image').trigger('click');
            }
        });
        var get_thumb_first = $(document).find('.dej-thumb-main-image');
        var get_main_first = $(document).find('.single-product-main-image');
        get_main_first.find('img').removeAttr('srcset');
        jQuery(this).on('show_variation', 'form.cart',function (event, variation) {
            get_thumb_first.removeAttr('srcset');
            var thumb_src = variation.image.gallery_thumbnail_src, variable_image_caption, first_thumb_src = get_main_first.find('img').attr("src");
            get_main_first.find('img').attr('src', variation.image.src);
            get_main_first.find('img').removeAttr('srcset');
            get_thumb_first.find('img').attr('src', thumb_src);
            $('.single-product-main-image .wp-post-image').on('load', function () {
                $('.dej-image').slick('slickGoTo', 0);
                $('.single-product-main-image').find('.zoomImg').attr('src', variation.image.url);
                if (get_main_first.find('.wp-post-image').data("o_img") == get_main_first.find('.wp-post-image').attr("src")) {
                    get_main_first.find('.woocommerce-product-gallery__lightbox').data('caption', get_main_first.find('.wp-post-image').data('caption'));
                    get_thumb_first.find('img').attr('src', get_thumb_first.find('img').data("thumb"));
                    $('.single-product-main-image').find('.zoomImg').attr('src', get_main_first.find('.wp-post-image').data("zoom_image"));
                }
            });
        });

    });
})(jQuery);

jQuery(document).ready(function($){

    var link = $('#dejavo_product_tabs .link');

    link.on('click', function(e) {
        var target = $($(this).attr('href'));
        $('html, body').animate({
            scrollTop: target.offset().top-85
        }, 600);
        $(this).addClass('active');
        e.preventDefault();
    });

    // Run the dejTabs when scroll
    $(window).on('scroll', function(){
        dejTabs();
    });

    function dejTabs() {
        var sTop = $(window).scrollTop();
        $('section').each(function() {
            var id = $(this).attr('id'),
                offset = $(this).offset().top-85,
                height = $(this).height();
            if(sTop >= offset && sTop < offset + height) {
                link.removeClass('active');
                $('#dejavo_product_tabs').find('[data-scroll="' + id + '"]').addClass('active');
            }
        });
    }
    dejTabs();


});


jQuery(document).on( 'click', '.woocommerce-widget-layered-nav-list__item a, .woocommerce-pagination a.page-numbers,.widget_layered_nav_filters a, .wc-layered-nav-rating a, .dej_orderby li a, .dejavo_filter_color li a, .dejavo_filter_brand li a', function(event) {

    var page_url = jQuery(this).attr('href');
    event.preventDefault();
    jQuery(".dej_shop_wrapper").addClass('loading');
    jQuery('html, body').animate({scrollTop:140},700);

    jQuery('.dej_shop_wrapper').load(page_url + ' .dej_shop_wrapper', function(responseTxt, statusTxt, xhr){

        jQuery(".dej_shop_wrapper").removeClass('loading');

        if(statusTxt == "success"){
            window.history.pushState({path:page_url},'',page_url);
            change_price_filter();
        }
        if(statusTxt == "error"){
            alert("Error: " + xhr.status + ": " + xhr.statusText);
        }
    });
});



jQuery(document).on( 'click', '.widget_price_filter .price_slider_wrapper .button', function( event ) {
    event.preventDefault();
    var href = '';
    var t    = jQuery(this);
    var form = t.parents('form'),
        l = window.location,
        shop_uri = l.origin + l.pathname,
        is_filtered = shop_uri != l.href,
        search = l.search,
        min_price = jQuery('.price_slider_amount #min_price').val(),
        max_price = jQuery('.price_slider_amount #max_price').val(),
        regex_min = new RegExp('^min_price', 'i'),
        regex_max = new RegExp('^max_price', 'i');
    href = l.href;

    if (is_filtered == true) {
        href = RemoveParaFromUrl(href, 'min_price');
        href = RemoveParaFromUrl(href, 'max_price');
    }

    var concat = shop_uri == href  ? '?' : '&';

    href = href + concat + jQuery.param(
        {
            min_price: min_price,
            max_price: max_price
        }
    );

    jQuery('html, body').animate({scrollTop:140},700);
    jQuery(".dej_shop_wrapper").addClass('loading');
    jQuery('.dej_shop_wrapper').load(href + ' .dej_shop_wrapper', function(responseTxt, statusTxt, xhr){
        jQuery(".dej_shop_wrapper").removeClass('loading');
        if(statusTxt == "success"){
            window.history.pushState({path:href},'',href);
            change_price_filter();
        }
        if(statusTxt == "error"){
            alert("Error: " + xhr.status + ": " + xhr.statusText);
        }
    });
});

function RemoveParaFromUrl(url, parameter) {
    return url
        .replace(new RegExp('[?&]' + parameter + '=[^&#]*(#.*)?$'), '$1')
        .replace(new RegExp('([?&])' + parameter + '=[^&]*&'), '$1');
}


function change_price_filter(){

    jQuery( function( $ ) {

        // woocommerce_price_slidr_params is required to continue ajax
        if ( typeof woocommerce_price_slider_params === 'undefined' ) {
            return false;
        }
        $( document.body ).bind( 'price_slider_create price_slider_slide', function( event, min, max ) {

            $( '.price_slider_amount span.from' ).html( accounting.formatMoney( min, {
                symbol:    woocommerce_price_slider_params.currency_format_symbol,
                decimal:   woocommerce_price_slider_params.currency_format_decimal_sep,
                thousand:  woocommerce_price_slider_params.currency_format_thousand_sep,
                precision: woocommerce_price_slider_params.currency_format_num_decimals,
                format:    woocommerce_price_slider_params.currency_format
            } ) );

            $( '.price_slider_amount span.to' ).html( accounting.formatMoney( max, {
                symbol:    woocommerce_price_slider_params.currency_format_symbol,
                decimal:   woocommerce_price_slider_params.currency_format_decimal_sep,
                thousand:  woocommerce_price_slider_params.currency_format_thousand_sep,
                precision: woocommerce_price_slider_params.currency_format_num_decimals,
                format:    woocommerce_price_slider_params.currency_format
            } ) );

            $( document.body ).trigger( 'price_slider_updated', [ min, max ] );
        });

        function init_price_filter() {
            $( 'input#min_price, input#max_price' ).hide();
            $( '.price_slider, .price_label' ).show();

            var min_price       = $( '.price_slider_amount #min_price' ).data( 'min' ),
                max_price         = $( '.price_slider_amount #max_price' ).data( 'max' ),
                step              = $( '.price_slider_amount' ).data( 'step' ) || 1,
                current_min_price = $( '.price_slider_amount #min_price' ).val(),
                current_max_price = $( '.price_slider_amount #max_price' ).val();

            $( '.price_slider:not(.ui-slider)' ).slider({
                range: true,
                animate: true,
                min: min_price,
                max: max_price,
                step: step,
                values: [ current_min_price, current_max_price ],
                create: function() {

                    $( '.price_slider_amount #min_price' ).val( current_min_price );
                    $( '.price_slider_amount #max_price' ).val( current_max_price );

                    $( document.body ).trigger( 'price_slider_create', [ current_min_price, current_max_price ] );
                },
                slide: function( event, ui ) {

                    $( 'input#min_price' ).val( ui.values[0] );
                    $( 'input#max_price' ).val( ui.values[1] );

                    $( document.body ).trigger( 'price_slider_slide', [ ui.values[0], ui.values[1] ] );
                },
                change: function( event, ui ) {

                    $( document.body ).trigger( 'price_slider_change', [ ui.values[0], ui.values[1] ] );
                }
            });
        }

        init_price_filter();

        var hasSelectiveRefresh = (
            'undefined' !== typeof wp &&
            wp.customize &&
            wp.customize.selectiveRefresh &&
            wp.customize.widgetsPreview &&
            wp.customize.widgetsPreview.WidgetPartial
        );
        if ( hasSelectiveRefresh ) {
            wp.customize.selectiveRefresh.bind( 'partial-content-rendered', function() {
                init_price_filter();
            } );
        }
    });
}


