<?php
defined('ABSPATH') || exit;
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

	<?php if ( have_comments() ) { ?>
        <h5 class="comments-title">
			<?php
			printf( _nx( 'One نظر ثبت شده در "%2$s"', '%1$s نظر ثبت شده در "%2$s"', get_comments_number(), 'comments title' ),
				number_format_i18n( get_comments_number() ), '<span>' . get_the_title() . '</span>' );
			?>
        </h5>

        <ul class="comment_list comments">
			<?php
			wp_list_comments( array(
				'style'      => 'ul',
				'short_ping' => true,
				'callback'   => 'better_comments'
			) );
			?>
        </ul><!-- .comment-list -->

		<?php
		// Are there comments to navigate through?
		if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) {
			?>
            <nav class="navigation comment-navigation" role="navigation">
                <h1 class="screen-reader-text section-heading"><?php _e( 'صفحه بندی نظرات', 'dejavo' ); ?></h1>
                <div class="nav-previous"><?php previous_comments_link( __( '&larr; نظرات قدیمی تر', 'dejavo' ) ); ?></div>
                <div class="nav-next"><?php next_comments_link( __( 'نظرات جدید تر &rarr;', 'dejavo' ) ); ?></div>
            </nav><!-- .comment-navigation -->
		<?php } // Check for comment navigation ?>

<?php } if (comments_open()) {

	$commenter     = wp_get_current_commenter();
	$user          = wp_get_current_user();
	$user_identity = $user->exists() ? $user->display_name : '';
	$args          = [];
	$args          = wp_parse_args( $args );
	if ( ! isset( $args['format'] ) ) {
		$args['format'] = current_theme_supports( 'html5', 'comment-form' ) ? 'html5' : 'xhtml';
	}

	$req   = get_option( 'require_name_email' );
	$html5 = 'html5' === $args['format'];

	// Define attributes in HTML5 or XHTML syntax.
	$required_attribute = ( $html5 ? ' required' : ' required="required"' );
	$checked_attribute  = ( $html5 ? ' checked' : ' checked="checked"' );

        $required_indicator = ' ' . '*';

        $fields = array(
            'author' => sprintf(
                '<div class="dej_inputs">%s',
                sprintf(
                    '<input placeholder="%s%s" class="dej_input" id="author" name="author" type="text" value="%s" size="30" maxlength="245" autocomplete="name" %s />',
                    __( 'Name' ),
                    ( $req ? $required_indicator : '' ),
                    esc_attr( $commenter['comment_author'] ),
                    ( $req ? $required_attribute : '' )
                )
            ),
            'email'  => sprintf(
                '%s',

                sprintf(
                    '<input placeholder="%s%s" class="dej_input" id="email" name="email" %s value="%s" size="30" maxlength="100" aria-describedby="email-notes" autocomplete="email"%s />',
                    __( 'Email' ),
                    ( $req ? $required_indicator : '' ),
                    ( $html5 ? 'type="email"' : 'type="text"' ),
                    esc_attr( $commenter['comment_author_email'] ),
                    ( $req ? $required_attribute : '' )
                )
            ),
            'url'    => sprintf(
                '%s</div>',

                sprintf(
                    '<input  placeholder="%s" class="dej_input" id="url" name="url" %s value="%s" size="30" maxlength="200" autocomplete="url" />',
                    __( 'Website' ),
                    ( $html5 ? 'type="url"' : 'type="text"' ),
                    esc_attr( $commenter['comment_author_url'] )
                )
            ),
        );


	$comment_form = array(
		'title_reply' => 'شما هم میتوانید نظری در مورد این مقاله بدهید',
		'comment_field' => '<textarea id="comment" class="dej_input dej_textarea" placeholder="نظر شما چیست *" name="comment" rows="5"></textarea>',
		'class_form' => 'dej_comment_form',
        'submit_button' => '<button id="%2$s" class="dejavo_btn %3$s"  value="%4$s" type="submit">ارسال</button>',
		'fields' => $fields,
	);


    if (is_woo_activated()) {
        $account_page_url = wc_get_page_permalink('myaccount');
        /* translators: %s opening and closing link tags respectively */
        $comment_form['must_log_in'] = '<div class="must-log-in"><div class="text">' . sprintf(esc_html__('You must be %1$slogged in%2$s to post a review.', 'woocommerce'), '<a href="' . esc_url($account_page_url) . '">', '</a>') . '</div></div>';
    }
    comment_form($comment_form); 
	}

	 else { ?><p class="close-comments"><i class="dej-shield-exclamation"></i> <?php _e( 'امکان درج نظر جدید در حال حاضر غیر فعال است', 'dejavo' ); ?></p><?php }  ?>
</div><!-- #comments -->