<?php
defined('ABSPATH') || exit;

const DejavoQV_VERSION = '3.4.1';

if (class_exists('woocommerce') and dej_options('dej_show_quick_view' , '1')) {
    class DejavoQV
    {
        protected static $summary = [];
        protected static $summary_default = [];
        protected static $settings = [];
        protected static $instance = null;

        public static function instance()
        {
            if (is_null(self::$instance)) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        function __construct()
        {
            self::$settings = (array)get_option('DejavoQV_settings', []);
            self::$summary = [
                'title' => esc_html__('Title', 'dejavo'),
                'rating' => esc_html__('Rating', 'dejavo'),
                'price' => esc_html__('Price', 'dejavo'),
                'excerpt' => esc_html__('Short description', 'dejavo'),
                'add_to_cart' => esc_html__('Add to cart', 'dejavo'),
                'meta' => esc_html__('Meta', 'dejavo'),
                'description' => esc_html__('Description', 'dejavo'),
            ];
            self::$summary_default = [
                'title',
                'rating',
                'price',
                'excerpt',
                'add_to_cart',
                'meta'
            ];


            // menu
            add_action('admin_init', [$this, 'register_settings']);
            add_action('admin_menu', [$this, 'admin_menu']);


            // enqueue scripts
            add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);

            // footer
            add_action('wp_footer', [$this, 'footer']);

            // ajax
            add_action('wp_ajax_DejavoQV_quickview', [$this, 'quickview']);
            add_action('wp_ajax_nopriv_DejavoQV_quickview', [$this, 'quickview']);


            // add image to variation
            add_filter('woocommerce_available_variation', [$this, 'available_variation'], 10, 3);

            // summary
            add_action('DejavoQV_product_summary', [$this, 'before_title'], 4);
            add_action('DejavoQV_product_summary', 'woocommerce_template_single_title', 5);
            add_action('DejavoQV_product_summary', [$this, 'after_title'], 6);

            add_action('DejavoQV_product_summary', [$this, 'before_rating'], 9);
            add_action('DejavoQV_product_summary', 'woocommerce_template_single_rating');
            add_action('DejavoQV_product_summary', [$this, 'after_rating'], 11);

            add_action('DejavoQV_product_summary', [$this, 'before_price'], 14);
            add_action('DejavoQV_product_summary', 'woocommerce_template_single_price', 15);
            add_action('DejavoQV_product_summary', [$this, 'after_price'], 16);

            add_action('DejavoQV_product_summary', [$this, 'before_excerpt'], 19);
            add_action('DejavoQV_product_summary', 'woocommerce_template_single_excerpt', 20);
            add_action('DejavoQV_product_summary', [$this, 'after_excerpt'], 21);

            add_action('DejavoQV_product_summary', [$this, 'add_to_cart'], 25);

            add_action('DejavoQV_product_summary', [$this, 'before_meta'], 29);
            add_action('DejavoQV_product_summary', 'woocommerce_template_single_meta', 30);
            add_action('DejavoQV_product_summary', [$this, 'after_meta'], 31);

            // add to cart redirect
            add_filter('woocommerce_add_to_cart_redirect', [$this, 'add_to_cart_redirect']);

            // mini-cart
            add_action('woocommerce_before_mini_cart', function () {
                $GLOBALS['DejavoQV_mini_cart'] = true;
            });
            add_action('woocommerce_after_mini_cart', function () {
                unset($GLOBALS['DejavoQV_mini_cart']);
            });
            add_filter('woocommerce_cart_item_permalink', [$this, 'cart_item_link'], 99, 2);
            // wpml
            add_filter('wcml_multi_currency_ajax_actions', [$this, 'wcml_multi_currency'], 99);

        }



        function available_variation($data, $variable, $variation)
        {
            if ($image_id = $variation->get_image_id()) {
                $image_sz = apply_filters('DejavoQV_image_size', 'default');

                if ($image_sz === 'default') {
                    $image_size = self::get_setting('image_size', 'woocommerce_single');
                } else {
                    $image_size = $image_sz;
                }

                $image_src = wp_get_attachment_image_src($image_id, $image_size);
                $data['DejavoQV_image_id'] = $image_id;
                $data['DejavoQV_image_src'] = $image_src[0];
                $data['DejavoQV_image'] = wp_get_attachment_image($image_id, $image_size);
            }

            return $data;
        }

        function add_to_cart($product)
        {
            do_action('DejavoQV_before_add_to_cart', $product);

            if (self::get_setting('add_to_cart_button', 'single') === 'archive') {
                woocommerce_template_loop_add_to_cart();
            } else {
                if ($product->is_type('variation')) {
                    $variation_id = $product->get_id();
                    $product_id = $product->get_parent_id();
                    ?>
                    <form class="cart" method="post" enctype='multipart/form-data'
                          action="<?php echo esc_url(apply_filters('woocommerce_add_to_cart_form_action', $product->get_permalink())); ?>">
                        <?php woocommerce_single_variation_add_to_cart_button(); ?>
                    </form>
                    <script type="text/javascript">
                        (function ($) {
                            $('#DejavoQV-popup input[name="add-to-cart"]').val(<?php echo esc_attr($product_id); ?>);
                            $('#DejavoQV-popup input[name="product_id"]').val(<?php echo esc_attr($product_id); ?>);
                            $('#DejavoQV-popup input[name="variation_id"]').val(<?php echo esc_attr($variation_id); ?>);
                        })(jQuery);
                    </script>
                    <?php
                } else {
                    woocommerce_template_single_add_to_cart();
                }
            }

            do_action('DejavoQV_after_add_to_cart', $product);
        }

        function add_to_cart_redirect($url)
        {
            if (apply_filters('DejavoQV_redirect', true)) {
                if (isset($_REQUEST['DejavoQV-redirect']) && !empty($_REQUEST['DejavoQV-redirect'])) {
                    return esc_url(sanitize_url($_REQUEST['DejavoQV-redirect']));
                }
            }

            return $url;
        }

        function description($product)
        {
            do_action('DejavoQV_before_description', $product);

            $description = $product->get_description();

            if (!empty($description)) {
                echo '<div class="product-description">' . do_shortcode($description) . '</div>';
            }

            do_action('DejavoQV_after_description', $product);
        }

        function cart_item_link($link, $cart_item)
        {
            if (!empty($link)) {
                if ((isset($GLOBALS['DejavoQV_mini_cart']) && (self::get_setting('mini_cart', 'yes') === 'yes')) || (!isset($GLOBALS['DejavoQV_mini_cart']) && (self::get_setting('cart', 'yes') === 'yes'))) {
                    // mini-cart & cart
                    return $link . '#DejavoQV-' . (!empty($cart_item['variation_id']) ? $cart_item['variation_id'] : $cart_item['product_id']);
                }
            }

            return $link;
        }

        function quickview()
        {
            global $post, $product;
            $product_id = absint(sanitize_key($_REQUEST['product_id']));
            $product = wc_get_product($product_id);

            if ($product) {
                $post = get_post($product_id);
                setup_postdata($post);
                $thumb_ids = [];

                if (self::get_setting('content_image', 'all') === 'product_image') {
                    if ($product_image = $product->get_image_id()) {
                        $thumb_ids[] = $product_image;
                    }

                    if ($product->is_type('variable') && ($children = $product->get_visible_children())) {
                        foreach ($children as $child) {
                            if (($child_product = wc_get_product($child)) && ($child_product_image = $child_product->get_image_id())) {
                                $thumb_ids[] = $child_product_image;
                            }
                        }
                    }
                } else {
                    if (self::get_setting('content_image', 'all') === 'all') {
                        if ($product_image = $product->get_image_id()) {
                            $thumb_ids[] = $product_image;
                        }

                        if ($product->is_type('variable') && ($children = $product->get_visible_children())) {
                            foreach ($children as $child) {
                                if (($child_product = wc_get_product($child)) && ($child_product_image = $child_product->get_image_id())) {
                                    $thumb_ids[] = $child_product_image;
                                }
                            }
                        }
                    }

                    if (is_a($product, 'WC_Product_Variation')) {
                        // get images from WPC Additional Variation Images
                        $_images = array_filter(explode(',', get_post_meta($product_id, 'wpcvi_images', true)));

                        if (!empty($_images) && is_array($_images)) {
                            $thumb_ids = array_merge($thumb_ids, $_images);
                        }
                    } else {
                        $thumb_ids = array_merge($thumb_ids, $product->get_gallery_image_ids());
                    }
                }

                $thumb_ids = apply_filters('DejavoQV_thumbnails', $thumb_ids, $product);
                $thumb_ids = array_unique($thumb_ids);


                    echo '<div id="DejavoQV-popup" class="DejavoQV-popup mfp-with-anim ' . esc_attr(self::get_setting('content_view_details_button', 'no') === 'yes' ? 'view-details' : '') . '">';

                ?>
                <div class="woocommerce single-product DejavoQV-product">
                    <div id="product-<?php echo esc_attr($product_id); ?>" <?php wc_product_class('', $product); ?>>
                        <div class="thumbnails">
                            <?php
                            do_action('DejavoQV_before_thumbnails', $product);

                            echo '<div class="images">';

                            $image_sz = apply_filters('DejavoQV_image_size', 'default');

                            if ($image_sz === 'default') {
                                $image_size = self::get_setting('image_size', 'woocommerce_single');
                            } else {
                                $image_size = $image_sz;
                            }

                            if (!empty($thumb_ids)) {
                                foreach ($thumb_ids as $thumb_id) {
                                    if (self::get_setting('content_image_lightbox', 'zoom') !== 'no') {
                                        $image_full = wp_get_attachment_image_src($thumb_id, 'full');

                                        echo '<div class="thumbnail" data-id="' . $thumb_id . '">' . wp_get_attachment_image($thumb_id, $image_size, false, [
                                                'data-fancybox' => 'gallery',
                                                'data-src' => esc_url($image_full[0])
                                            ]) . '</div>';
                                    } else {
                                        echo '<div class="thumbnail" data-id="' . $thumb_id . '">' . wp_get_attachment_image($thumb_id, $image_size) . '</div>';
                                    }
                                }
                            } else {
                                echo '<div class="thumbnail">' . wc_placeholder_img($image_size) . '</div>';
                            }

                            echo '</div>';

                            do_action('DejavoQV_after_thumbnails', $product);
                            ?>

                        </div>
                        <div class="summary entry-summary">
                            <?php do_action('DejavoQV_before_summary', $product); ?>

                            <div class="summary-content">
                                <?php do_action('DejavoQV_product_summary', $product); ?>
                            </div>

                            <?php do_action('DejavoQV_after_summary', $product); ?>
                        </div>
                    </div>
                </div><!-- /woocommerce single-product -->
                <?php
                if (self::get_setting('content_view_details_button', 'no') === 'yes') {
                    $view_details_text = esc_html__('View product details', 'dejavo');

                    echo sprintf('<a class="view-details-btn" href="%s">%s</a>', $product->get_permalink(), esc_html($view_details_text));
                }


                echo '</div><!-- #DejavoQV-popup -->';


                wp_reset_postdata();
            }

            wp_die();
        }



        public static function qv_btn($attrs)
        {
            $output = '';

            $attrs = shortcode_atts([
                'id' => null,
                'text' => null,
                'effect' => self::get_setting('effect', 'mfp-3d-unfold'),
                'context' => 'default',
            ], $attrs, 'DejavoQV');

            if (!$attrs['id']) {
                global $product;

                if ($product && is_a($product, 'WC_Product')) {
                    $attrs['id'] = $product->get_id();
                }
            }

            if ($attrs['id']) {
                
                // button class
                $button_class = trim('DejavoQV-btn DejavoQV-btn-' . esc_attr($attrs['id']));

                $button_class = apply_filters('DejavoQV_button_class', $button_class, $attrs);

                $output = '<a href="' . esc_url('?quick-view=' . $attrs['id']) . '" class="' . esc_attr($button_class) . '" data-id="' . esc_attr($attrs['id']) . '" data-effect="' . esc_attr($attrs['effect']) . '" data-context="' . esc_attr($attrs['context']) . '"><i class="dej-search"></i></a>';

            }

            return apply_filters('DejavoQV_button_html', $output, $attrs['id']);
        }

        function before_title($product)
        {
            do_action('DejavoQV_before_title', $product);
        }

        function after_title($product)
        {
            do_action('DejavoQV_after_title', $product);
        }

        function before_rating($product)
        {
            do_action('DejavoQV_before_rating', $product);
        }

        function after_rating($product)
        {
            do_action('DejavoQV_after_rating', $product);
        }

        function before_price($product)
        {
            do_action('DejavoQV_before_price', $product);
        }

        function after_price($product)
        {
            do_action('DejavoQV_after_price', $product);
        }

        function before_excerpt($product)
        {
            do_action('DejavoQV_before_excerpt', $product);
        }

        function after_excerpt($product)
        {
            do_action('DejavoQV_after_excerpt', $product);
        }

        function before_meta($product)
        {
            do_action('DejavoQV_before_meta', $product);
        }

        function after_meta($product)
        {
            do_action('DejavoQV_after_meta', $product);
        }

        function register_settings()
        {
            // settings
            register_setting('DejavoQV_settings', 'DejavoQV_settings');
        }

        function admin_menu()
        {
            add_submenu_page('future', esc_html__('Quick view', 'dejavo'),
                esc_html__('Quick view', 'dejavo'), 'manage_options', 'future-dejavoqv',
                array(&$this, 'admin_menu_content'));
        }

        function admin_menu_content()
        {
            $active_tab = isset($_GET['tab']) ? sanitize_key($_GET['tab']) : 'settings';
            ?>
            <div class="dejavo_settings_page wrap">
                <?php if (isset($_GET['settings-updated']) && $_GET['settings-updated']) { ?>
                    <div class="notice notice-success is-dismissible">
                        <p><?php esc_html_e('Settings updated.', 'dejavo'); ?></p>
                    </div>
                <?php } ?>
               
                <div class="dejavo_settings_page_content">
                    <?php if ($active_tab === 'settings') {
                        $effect = self::get_setting('effect', 'mfp-3d-unfold');
                        $auto_close = self::get_setting('auto_close', 'yes');
                        $mini_cart = self::get_setting('mini_cart', 'yes');
                        $cart = self::get_setting('cart', 'yes');
                        $content_image = self::get_setting('content_image', 'all');
                        $content_image_lightbox = self::get_setting('content_image_lightbox', 'zoom');
                        $add_to_cart_button = self::get_setting('add_to_cart_button', 'single');
                        $view_details_button = self::get_setting('content_view_details_button', 'no');
                        $suggested = self::get_setting('related_products', []);

                        if (!is_array($suggested)) {
                            // backward compatible before 3.3.3
                            if ($suggested === 'yes') {
                                $suggested = ['related'];
                            } else {
                                $suggested = [];
                            }
                        }
                        ?>
                        <form method="post" action="options.php">
                            <table class="form-table">
                                <tr class="heading">
                                    <th colspan="2">
                                        <?php esc_html_e('General', 'dejavo'); ?>
                                    </th>
                                </tr>

                                <tr class="DejavoQV_view_type DejavoQV_view_type_popup">
                                    <th scope="row"><?php esc_html_e('Popup effect', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoQV_settings[effect]">
                                            <option value="mfp-fade" <?php selected($effect, 'mfp-fade'); ?>><?php esc_html_e('Fade', 'dejavo'); ?></option>
                                            <option value="mfp-zoom-in" <?php selected($effect, 'mfp-zoom-in'); ?>><?php esc_html_e('Zoom in', 'dejavo'); ?></option>
                                            <option value="mfp-zoom-out" <?php selected($effect, 'mfp-zoom-out'); ?>><?php esc_html_e('Zoom out', 'dejavo'); ?></option>
                                            <option value="mfp-newspaper" <?php selected($effect, 'mfp-newspaper'); ?>><?php esc_html_e('Newspaper', 'dejavo'); ?></option>
                                            <option value="mfp-move-horizontal" <?php selected($effect, 'mfp-move-horizontal'); ?>><?php esc_html_e('Move horizontal', 'dejavo'); ?></option>
                                            <option value="mfp-move-from-top" <?php selected($effect, 'mfp-move-from-top'); ?>><?php esc_html_e('Move from top', 'dejavo'); ?></option>
                                            <option value="mfp-3d-unfold" <?php selected($effect, 'mfp-3d-unfold'); ?>><?php esc_html_e('3d unfold', 'dejavo'); ?></option>
                                            <option value="mfp-slide-bottom" <?php selected($effect, 'mfp-slide-bottom'); ?>><?php esc_html_e('Slide bottom', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row"><?php esc_html_e('Auto close', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoQV_settings[auto_close]">
                                            <option value="yes" <?php selected($auto_close, 'yes'); ?>><?php esc_html_e('Yes', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($auto_close, 'no'); ?>><?php esc_html_e('No', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php esc_html_e('Auto close the popup after adding a product to the cart.', 'dejavo'); ?></span>
                                    </td>
                                </tr>


                                <tr>
                                    <th scope="row"><?php esc_html_e('Enable for mini-cart', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoQV_settings[mini_cart]">
                                            <option value="yes" <?php selected($mini_cart, 'yes'); ?>><?php esc_html_e('Yes', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($mini_cart, 'no'); ?>><?php esc_html_e('No', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php esc_html_e('Enable quick view for products on mini-cart.', 'dejavo'); ?></span>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row"><?php esc_html_e('Enable for cart page', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoQV_settings[cart]">
                                            <option value="yes" <?php selected($cart, 'yes'); ?>><?php esc_html_e('Yes', 'dejavo'); ?></option>
                                            <option value="no" <?php selected($cart, 'no'); ?>><?php esc_html_e('No', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php esc_html_e('Enable quick view for products on the cart page.', 'dejavo'); ?></span>
                                    </td>
                                </tr>
                                <tr class="heading">
                                    <th>
                                        <?php esc_html_e('Content', 'dejavo'); ?>
                                    </th>

                                </tr>
                                <tr>
                                    <th scope="row"><?php esc_html_e('Images', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoQV_settings[content_image]">
                                            <option value="all" <?php selected($content_image, 'all'); ?>><?php esc_html_e('Product image & Product gallery images', 'dejavo'); ?></option>
                                            <option value="product_image" <?php selected($content_image, 'product_image'); ?>><?php esc_html_e('Product image', 'dejavo'); ?></option>
                                            <option value="product_gallery" <?php selected($content_image, 'product_gallery'); ?>><?php esc_html_e('Product gallery images', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row"><?php esc_html_e('Image size', 'dejavo'); ?></th>
                                    <td>
                                        <?php
                                        $image_sz = apply_filters('DejavoQV_image_size', 'default');

                                        if ($image_sz === 'default') {
                                            $image_size = self::get_setting('image_size', 'woocommerce_single');
                                        } else {
                                            $image_size = $image_sz;
                                        }

                                        $image_sizes = $this->get_image_sizes();
                                        $image_sizes['full'] = [
                                            'width' => '',
                                            'height' => '',
                                            'crop' => false
                                        ];

                                        if (!empty($image_sizes)) {
                                            echo '<select name="DejavoQV_settings[image_size]" ' . ($image_sz !== 'default' ? 'disabled' : '') . '>';

                                            foreach ($image_sizes as $image_size_name => $image_size_data) {
                                                echo '<option value="' . esc_attr($image_size_name) . '" ' . ($image_size_name === $image_size ? 'selected' : '') . '>' . esc_attr($image_size_name) . (!empty($image_size_data['width']) ? ' ' . $image_size_data['width'] . '&times;' . $image_size_data['height'] : '') . ($image_size_data['crop'] ? ' (cropped)' : '') . '</option>';
                                            }

                                            echo '</select>';
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row"><?php esc_html_e('Product images effect', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoQV_settings[content_image_lightbox]">
                                            <option value="no" <?php selected($content_image_lightbox, 'no'); ?>><?php esc_html_e('None', 'dejavo'); ?></option>
                                            <option value="yes" <?php selected($content_image_lightbox, 'yes'); ?>><?php esc_html_e('Lightbox', 'dejavo'); ?></option>
                                            <option value="zoom" <?php selected($content_image_lightbox, 'zoom'); ?>><?php esc_html_e('Zoom', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row"><?php esc_html_e('Product summary', 'dejavo'); ?></th>
                                    <td>
                                        <ul class="DejavoQV-summary">
                                            <?php
                                            $saved_summary = [];
                                            $summary = self::get_setting('summary', self::$summary_default);

                                            foreach ($summary as $s) {
                                                $saved_summary[$s] = self::$summary[$s];
                                            }

                                            $merge_summary = array_merge($saved_summary, self::$summary);

                                            foreach ($merge_summary as $k => $s) {
                                                echo '<li><input type="checkbox" name="DejavoQV_settings[summary][]" value="' . esc_attr($k) . '" ' . (is_array($summary) && in_array($k, $summary, true) ? 'checked' : '') . '/><span class="label">' . $s . '</span></li>';
                                            }
                                            ?>
                                        </ul>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row"><?php esc_html_e('Add to cart button', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoQV_settings[add_to_cart_button]">
                                            <option value="archive" <?php selected($add_to_cart_button, 'archive'); ?>><?php esc_html_e('Like archive page', 'dejavo'); ?></option>
                                            <option value="single" <?php selected($add_to_cart_button, 'single'); ?>><?php esc_html_e('Like single page', 'dejavo'); ?></option>
                                        </select>
                                        <span class="description"><?php esc_html_e('Choose the functionally for the add to cart button.', 'dejavo'); ?></span>
                                    </td>
                                </tr>

                                <tr>
                                    <th scope="row"><?php esc_html_e('View details button', 'dejavo'); ?></th>
                                    <td>
                                        <select name="DejavoQV_settings[content_view_details_button]">
                                            <option value="no" <?php selected($view_details_button, 'no'); ?>><?php esc_html_e('No', 'dejavo'); ?></option>
                                            <option value="yes" <?php selected($view_details_button, 'yes'); ?>><?php esc_html_e('Yes', 'dejavo'); ?></option>
                                        </select>
                                    </td>
                                </tr>
                                <tr class="submit">
                                    <th colspan="2">
                                        <?php settings_fields('DejavoQV_settings'); ?><?php submit_button(); ?>
                                    </th>
                                </tr>
                            </table>
                        </form>
                    <?php } ?>
                </div>
            </div>
            <?php
        }

        function enqueue_scripts()
        {
            wp_dequeue_style('woocommerce_fancybox_styles');
            wp_dequeue_script('fancybox');
            wp_dequeue_script('zoom');

            // slick
            wp_enqueue_script( 'slick', DEJ_TUI . '/assets/libs/slick/slick.min.js', [ 'jquery' ], DejavoQV_VERSION );


            // fancybox
            wp_enqueue_style('fancybox', DEJ_TUI . '/assets/libs/fancybox/jquery.fancybox.min.css');
            wp_enqueue_script('fancybox', DEJ_TUI . '/assets/libs/fancybox/jquery.fancybox.min.js', ['jquery'], DejavoQV_VERSION, true);


            // zoom
            wp_enqueue_script('zoom', DEJ_TUI . '/assets/libs/zoom/jquery.zoom.min.js', ['jquery'], DejavoQV_VERSION, true);



            // main style & js
            wp_enqueue_style('DejavoQV-frontend', DEJ_TUI . '/assets/css/quickview.css', [], DejavoQV_VERSION);
            wp_enqueue_script('DejavoQV-frontend', DEJ_TUI . '/assets/js/quickview.js', [
                'jquery',
                'wc-add-to-cart-variation'
            ], DejavoQV_VERSION, true);
            wp_localize_script('DejavoQV-frontend', 'DejavoQV_vars', [
                    'ajax_url' => admin_url('admin-ajax.php'),
                    'effect' => self::get_setting('effect', 'mfp-3d-unfold'),
                    'auto_close' => self::get_setting('auto_close', 'yes'),
                    'hashchange' => apply_filters('DejavoQV_hashchange', 'no'),
                    'cart_redirect' => get_option('woocommerce_cart_redirect_after_add'),
                    'cart_url' => apply_filters('woocommerce_add_to_cart_redirect', wc_get_cart_url(), null),
                    'close' => esc_html__('Close (Esc)', 'dejavo'),
                    'next' => esc_html__('Next (Right arrow key)', 'dejavo'),
                    'prev' => esc_html__('Previous (Left arrow key)', 'dejavo'),
                    'thumbnails_effect' => self::get_setting('content_image_lightbox', 'zoom'),
                    'related_slick_params'    => apply_filters( 'DejavoQV_related_slick_params', json_encode( apply_filters( 'DejavoQV_related_slick_params_arr', [
                        'slidesToShow'   => 2,
                        'slidesToScroll' => 2,
                        'dots'           => true,
                        'arrows'         => false,
                        'adaptiveHeight' => true,
                        'rtl'            => is_rtl()
                    ] ) ) ),
                    'thumbnails_slick_params' => apply_filters( 'DejavoQV_thumbnails_slick_params', json_encode( apply_filters( 'DejavoQV_thumbnails_slick_params_arr', [
                        'slidesToShow'   => 1,
                        'slidesToScroll' => 1,
                        'dots'           => true,
                        'arrows'         => true,
                        'adaptiveHeight' => false,
                        'rtl'            => is_rtl()
                    ] ) ) ),
            

                    'thumbnails_zoom_params' => apply_filters('DejavoQV_thumbnails_zoom_params', json_encode(apply_filters('DejavoQV_thumbnails_zoom_params_arr', [
                        'duration' => 120,
                        'magnify' => 1
                    ]))),
                ]
            );
        }

        function footer()
        {

            if (isset($_REQUEST['quick-view'])) {
                ?>
                <script type="text/javascript">
                    jQuery(document).ready(function () {
                        setTimeout(function () {
                            DejavoQV_open(<?php echo absint(sanitize_key($_REQUEST['quick-view'])); ?>);
                        }, 1000);
                    });
                </script>
                <?php
            }
        }


        function get_image_sizes()
        {
            global $_wp_additional_image_sizes;
            $sizes = [];

            foreach (get_intermediate_image_sizes() as $_size) {
                if (in_array($_size, ['thumbnail', 'medium', 'medium_large', 'large'])) {
                    $sizes[$_size]['width'] = get_option("{$_size}_size_w");
                    $sizes[$_size]['height'] = get_option("{$_size}_size_h");
                    $sizes[$_size]['crop'] = (bool)get_option("{$_size}_crop");
                } elseif (isset($_wp_additional_image_sizes[$_size])) {
                    $sizes[$_size] = [
                        'width' => $_wp_additional_image_sizes[$_size]['width'],
                        'height' => $_wp_additional_image_sizes[$_size]['height'],
                        'crop' => $_wp_additional_image_sizes[$_size]['crop'],
                    ];
                }
            }

            return $sizes;
        }



        function wcml_multi_currency($ajax_actions)
        {
            $ajax_actions[] = 'DejavoQV_quickview';

            return $ajax_actions;
        }

        public static function get_settings()
        {
            return apply_filters('DejavoQV_get_settings', self::$settings);
        }

        public static function get_setting($name, $default = false)
        {
            if (!empty(self::$settings)) {
                if (isset(self::$settings[$name])) {
                    $setting = self::$settings[$name];
                } else {
                    $setting = $default;
                }
            } else {
                $setting = get_option('DejavoQV_' . $name, $default);
            }

            return apply_filters('DejavoQV_get_setting', $setting, $name, $default);
        }
        
    }

    return DejavoQV::instance();
}




