<?php
defined('ABSPATH') || exit;
if (class_exists('WC_Product') and dej_options('dej_show_variation_swatches' , '1')) {
    class DejavoVS
    {
        protected static $instance = null;

        public static function instance()
        {
            if (is_null(self::$instance)) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        function __construct()
        {

            add_action('wp_enqueue_scripts', [$this, 'scripts']);
            add_action('admin_enqueue_scripts', [$this, 'admin_scripts']);


            // add field for attributes
            add_filter('product_attributes_type_selector', [$this, 'type_selector']);

            $attribute_taxonomies = wc_get_attribute_taxonomies();

            foreach ($attribute_taxonomies as $attribute_taxonomy) {
                add_action('pa_' . $attribute_taxonomy->attribute_name . '_add_form_fields', [
                    $this,
                    'show_field'
                ]);
                add_action('pa_' . $attribute_taxonomy->attribute_name . '_edit_form_fields', [
                    $this,
                    'show_field'
                ]);
                add_action('create_pa_' . $attribute_taxonomy->attribute_name, [$this, 'save_field']);
                add_action('edited_pa_' . $attribute_taxonomy->attribute_name, [$this, 'save_field']);
                add_filter("manage_edit-pa_{$attribute_taxonomy->attribute_name}_columns", [
                    $this,
                    'custom_columns'
                ]);
                add_filter("manage_pa_{$attribute_taxonomy->attribute_name}_custom_column", [
                    $this,
                    'custom_columns_content'
                ], 10, 3);
            }

            add_filter('woocommerce_dropdown_variation_attribute_options_html', [
                $this,
                'variation_attribute_options_html'
            ], 199, 2);

            // ajax add to cart
            add_action('wp_ajax_DejavoVS_add_to_cart', [$this, 'ajax_add_to_cart']);
            add_action('wp_ajax_nopriv_DejavoVS_add_to_cart', [$this, 'ajax_add_to_cart']);

            // variation
            add_filter('woocommerce_available_variation', [$this, 'available_variation'], 100, 3);
        }

        function ajax_add_to_cart()
        {
            if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'DejavoVS_nonce')) {
                die(esc_html__('Permissions check failed!', 'dejavo'));
            }

            $product_id = (int)$_POST['product_id'];
            $variation_id = (int)$_POST['variation_id'];
            $quantity = (float)$_POST['quantity'];
            $variation = (array)json_decode(stripslashes($_POST['attributes']));

            if ($product_id && $variation_id) {
                $item_key = WC()->cart->add_to_cart($product_id, $quantity, $variation_id, $variation);

                if (!empty($item_key)) {
                    WC_AJAX::get_refreshed_fragments();
                }
            }

            $data = [
                'error' => true,
                'product_url' => apply_filters('woocommerce_cart_redirect_after_error', get_permalink($product_id), $product_id),
            ];

            wp_send_json($data);
        }

        function available_variation($available, $variable, $variation)
        {
            $thumbnail_id = $available['image_id'];
            $thumbnail_size = apply_filters('woocommerce_thumbnail_size', 'woocommerce_thumbnail');
            $thumbnail_src = wp_get_attachment_image_src($thumbnail_id, $thumbnail_size);

            if ($thumbnail_id) {
                $available['image']['DejavoVS_src'] = $thumbnail_src[0];
                $available['image']['DejavoVS_srcset'] = function_exists('wp_get_attachment_image_srcset') ? wp_get_attachment_image_srcset($thumbnail_id, $thumbnail_size) : false;
                $available['image']['DejavoVS_sizes'] = function_exists('wp_get_attachment_image_sizes') ? wp_get_attachment_image_sizes($thumbnail_id, $thumbnail_size) : false;
            }

            return $available;
        }

        function scripts()
        {

            if (dej_options('dej_attr_tooltip_lib', 'hint') === 'tippy') {
                wp_enqueue_script('popper', DEJ_LIB . 'tippy/popper.min.js', ['jquery'], DEJ_VERSION);
                wp_enqueue_script('tippy', DEJ_LIB . 'tippy/tippy-bundle.umd.min.js', ['jquery'], DEJ_VERSION);
            }


            wp_enqueue_script('DejavoVS-frontend', DEJ_JS . 'vs.js', ['jquery'], DEJ_VERSION, true);


            wp_localize_script('DejavoVS-frontend', 'DejavoVS_vars', [
                    'ajax_url' => admin_url('admin-ajax.php'),
                    'nonce' => wp_create_nonce('DejavoVS_nonce'),
                    'tooltip_lib' => dej_options('dej_attr_tooltip_lib', 'hint'),
                    'tooltip_pos' => dej_options('dej_attr_tooltip_position', 'top'),
                    'second_click' => dej_options('dej_attr_second_click', 'yes'),
                    'archive_product' =>  '.dej_var_product',
                    'archive_image' =>  '.image .two_image.variation_images',
                    'archive_atc' => '.add_to_cart_button',
                    'archive_atc_text' => '.add-to-cart',
                    'add_to_cart' =>  esc_html__('Add to cart', 'dejavo'),
                    'select_options' => apply_filters('DejavoVS_select_options', esc_html__('Select options', 'dejavo')),
                ]
            );
        }
        function admin_scripts()
        {
            $args = [
                'placeholder_img' => wc_placeholder_img_src()
            ];
            wp_enqueue_script('DejavoVS-backend', DEJ_TUI . '/assets/js/vs-backend.js', [
                'jquery',
                'wp-color-picker'
            ], DEJ_VERSION, true);
            wp_localize_script('DejavoVS-backend', 'DejavoVS_vars', $args);
        }

        function type_selector($types)
        {
            global $pagenow;

            if (($pagenow === 'post-new.php') || ($pagenow === 'post.php') || (defined('DOING_AJAX') && DOING_AJAX)) {
                return $types;
            } else {
                $types['select'] = esc_html__('Select', 'dejavo');
                $types['button'] = esc_html__('Button', 'dejavo');
                $types['color'] = esc_html__('Color', 'dejavo');
                $types['image'] = esc_html__('Image', 'dejavo');
                $types['radio'] = esc_html__('Radio', 'dejavo');

                return $types;
            }
        }

        function show_field($term_or_tax)
        {
            if (is_object($term_or_tax)) {
                // is term
                $term_id = $term_or_tax->term_id;
                $attr_id = wc_attribute_taxonomy_id_by_name($term_or_tax->taxonomy);
                $attr = wc_get_attribute($attr_id);
                $wrap_start = '<tr class="form-field"><th><label>';
                $wrap_mid = '</label></th><td>';
                $wrap_end = '</td></tr>';
            } else {
                // is taxonomy
                $term_id = 0;
                $attr_id = wc_attribute_taxonomy_id_by_name($term_or_tax);
                $attr = wc_get_attribute($attr_id);
                $wrap_start = '<div class="form-field"><label>';
                $wrap_mid = '</label>';
                $wrap_end = '</div>';
            }

            $DejavoVS_tooltip = get_term_meta($term_id, 'DejavoVS_tooltip', true);

            switch ($attr->type) {
                case 'button':
                    $DejavoVS_val = get_term_meta($term_id, 'DejavoVS_button', true);
                    echo $wrap_start . esc_html__('Button', 'dejavo') . $wrap_mid . '<input id="DejavoVS_button" name="DejavoVS_button" value="' . esc_attr($DejavoVS_val) . '" type="text"/>' . $wrap_end;
                    echo $wrap_start . esc_html__('Tooltip', 'dejavo') . $wrap_mid . '<input id="DejavoVS_tooltip" name="DejavoVS_tooltip" value="' . esc_attr($DejavoVS_tooltip) . '" type="text"/>' . $wrap_end;

                    break;
                case 'color':
                    $DejavoVS_val = get_term_meta($term_id, 'DejavoVS_color', true);
                    echo $wrap_start . esc_html__('Color', 'dejavo') . $wrap_mid . '<input class="DejavoVS_color" id="DejavoVS_color" name="DejavoVS_color" value="' . esc_attr($DejavoVS_val) . '" type="text"/>' . $wrap_end;
                    echo $wrap_start . esc_html__('Tooltip', 'dejavo') . $wrap_mid . '<input id="DejavoVS_tooltip" name="DejavoVS_tooltip" value="' . esc_attr($DejavoVS_tooltip) . '" type="text"/>' . $wrap_end;

                    break;
                case 'image':
                    wp_enqueue_media();
                    $DejavoVS_val = get_term_meta($term_id, 'DejavoVS_image', true);

                    if ($DejavoVS_val) {
                        $image = wp_get_attachment_thumb_url($DejavoVS_val);
                    } else {
                        $image = wc_placeholder_img_src();
                    }

                    echo $wrap_start . 'Image' . $wrap_mid; ?>
                    <div id="DejavoVS_image_thumbnail" style="float: left;"><img src="<?php echo esc_url($image); ?>" width="120px" height="60px" /></div>
                    <div style="line-height: 60px;">
                        <input type="hidden" id="DejavoVS_image" name="DejavoVS_image" value="<?php echo esc_attr($DejavoVS_val); ?>" />
                        <button id="DejavoVS_upload_image" type="button"
                                class="DejavoVS_upload_image button"><?php esc_html_e('Upload/Add image', 'dejavo'); ?>
                        </button>
                        <button id="DejavoVS_remove_image" type="button"
                                class="DejavoVS_remove_image button"><?php esc_html_e('Remove image', 'dejavo'); ?>
                        </button>
                    </div>
                    <?php
                    echo $wrap_end;
                    echo $wrap_start . 'Tooltip' . $wrap_mid . '<input id="DejavoVS_tooltip" name="DejavoVS_tooltip" value="' . esc_attr($DejavoVS_tooltip) . '" type="text"/>' . $wrap_end;

                    break;
                case 'radio':
                    $DejavoVS_val = get_term_meta($term_id, 'DejavoVS_radio', true);
                    echo $wrap_start . esc_html__('Label', 'dejavo') . $wrap_mid . '<input id="DejavoVS_radio" name="DejavoVS_radio" value="' . esc_attr($DejavoVS_val) . '" type="text"/>' . $wrap_end;
                    echo $wrap_start . esc_html__('Tooltip', 'dejavo') . $wrap_mid . '<input id="DejavoVS_tooltip" name="DejavoVS_tooltip" value="' . esc_attr($DejavoVS_tooltip) . '" type="text"/>' . $wrap_end;

                    break;
                default:
                    echo '';
            }
        }

        function save_field($term_id)
        {
            if (isset($_POST['DejavoVS_color'])) {
                update_term_meta($term_id, 'DejavoVS_color', sanitize_text_field($_POST['DejavoVS_color']));
            }

            if (isset($_POST['DejavoVS_button'])) {
                update_term_meta($term_id, 'DejavoVS_button', sanitize_text_field($_POST['DejavoVS_button']));
            }

            if (isset($_POST['DejavoVS_image'])) {
                update_term_meta($term_id, 'DejavoVS_image', sanitize_text_field($_POST['DejavoVS_image']));
            }

            if (isset($_POST['DejavoVS_radio'])) {
                update_term_meta($term_id, 'DejavoVS_radio', sanitize_text_field($_POST['DejavoVS_radio']));
            }

            if (isset($_POST['DejavoVS_tooltip'])) {
                update_term_meta($term_id, 'DejavoVS_tooltip', sanitize_text_field($_POST['DejavoVS_tooltip']));
            }
        }

        function variation_attribute_options_html($options_html, $args)
        {
            $options = $args['options'];
            $product = $args['product'];
            $attribute = $args['attribute'];
            $count = 0;
            $limit = absint(isset($args['limit']) ? $args['limit'] : 0);
            $tooltip_pos = dej_options('dej_attr_tooltip_position', 'top');
            $tooltip_lib = dej_options('dej_attr_tooltip_lib', 'hint');
            $style = dej_options('dej_attr_style', 'rounded');
            $attr_id = wc_attribute_taxonomy_id_by_name($attribute);
            $tooltip_class = '';

            if ($tooltip_pos !== 'no') {
                if ($tooltip_lib === 'hint') {
                    $tooltip_class = 'hint-tooltip hint--' . $tooltip_pos;
                }

                if ($tooltip_lib === 'tippy') {
                    $tooltip_class = 'tippy-tooltip tippy--' . $tooltip_pos;
                }
            }

            ob_start();

            if (empty($options) && !empty($product) && !empty($attribute)) {
                $attributes = $product->get_variation_attributes();
                $options = $attributes[$attribute];
            }

            if ($attr_id) {
                $attr = wc_get_attribute($attr_id);
                $attr_type = isset($attr->type) ? $attr->type : 'select';

                $terms = wc_get_product_terms(
                    $product->get_id(),
                    $attribute,
                    [
                        'fields' => 'all',
                    ]
                );

                if (($attr_type === 'select') && (dej_options('dej_attr_button_default', 'yes') === 'yes')) {
                    $attr_type = 'button';
                }

                if (($attr_type !== '') && ($attr_type !== 'select')) {
                    do_action('DejavoVS_terms_above', $args);

                    $terms_class = apply_filters('DejavoVS_terms_class', 'DejavoVS-terms DejavoVS-type-' . $attr_type . ' DejavoVS-style-' . $style, $terms, $args);
                    echo '<div class="' . esc_attr($terms_class) . '" data-attribute="' . esc_attr($attribute) . '">';
                    do_action('DejavoVS_terms_before', $args);

                    switch ($attr_type) {
                        case 'button' :
                            foreach ($terms as $term) {
                                if (!$limit || ($count < $limit)) {
                                    $val = get_term_meta($term->term_id, 'DejavoVS_button', true) ?: $term->name;
                                    $tooltip = get_term_meta($term->term_id, 'DejavoVS_tooltip', true) ?: $val;
                                    $class = apply_filters('DejavoVS_term_class', 'DejavoVS-term ' . $tooltip_class, $term, $args);

                                    if ($tooltip_lib === 'tippy') {
                                        $tooltip_content = 'data-tippy-content="' . esc_attr(htmlentities('<span class="DejavoVS-tippy DejavoVS-tippy-' . esc_attr($term->term_id) . '"><span class="DejavoVS-tippy-inner"><span class="DejavoVS-tippy-title">' . esc_html($tooltip) . '</span>' . (!empty($term->description) ? '<span class="DejavoVS-tippy-desc">' . esc_html($term->description) . '</span>' : '') . '</span></span>')) . '"';
                                    } elseif ($tooltip_lib === 'hint') {
                                        $tooltip_content = 'aria-label="' . esc_attr($tooltip) . '"';
                                    } else {
                                        $tooltip_content = '';
                                    }

                                    do_action('DejavoVS_term_before', $term);
                                    echo apply_filters('DejavoVS_term_html', '<span class="' . esc_attr($class) . '" ' . $tooltip_content . ' title="' . esc_attr($tooltip) . '" data-term="' . esc_attr($term->slug) . '"><span>' . esc_html($val) . '</span></span>', $term, $args);
                                    do_action('DejavoVS_term_after', $term);
                                }

                                $count++;
                            }

                            break;
                        case 'color':
                            foreach ($terms as $term) {
                                if (!$limit || ($count < $limit)) {
                                    $val = get_term_meta($term->term_id, 'DejavoVS_color', true) ?: '';
                                    $tooltip = get_term_meta($term->term_id, 'DejavoVS_tooltip', true) ?: $term->name;
                                    $class = apply_filters('DejavoVS_term_class', 'DejavoVS-term ' . $tooltip_class, $term, $args);

                                    if ($tooltip_lib === 'tippy') {
                                        $tooltip_content = 'data-tippy-content="' . esc_attr(htmlentities('<span class="DejavoVS-tippy DejavoVS-tippy-' . esc_attr($term->term_id) . '"><span class="DejavoVS-tippy-inner"><span class="DejavoVS-tippy-title">' . esc_html($tooltip) . '</span><span class="DejavoVS-tippy-swatches"><span class="DejavoVS-tippy-swatches--color" ' . (!empty($val) ? 'style="background-color: ' . esc_attr($val) . '"' : '') . '>' . esc_html($val) . '</span></span>' . (!empty($term->description) ? '<span class="DejavoVS-tippy-desc">' . esc_html($term->description) . '</span>' : '') . '</span></span>')) . '"';
                                    } elseif ($tooltip_lib === 'hint') {
                                        $tooltip_content = 'aria-label="' . esc_attr($tooltip) . '"';
                                    } else {
                                        $tooltip_content = '';
                                    }

                                    do_action('DejavoVS_term_before', $term);
                                    echo apply_filters('DejavoVS_term_html', '<span class="' . esc_attr($class) . '" ' . $tooltip_content . ' title="' . esc_attr($tooltip) . '" data-term="' . esc_attr($term->slug) . '"><span ' . (!empty($val) ? 'style="background-color: ' . esc_attr($val) . '"' : '') . '>' . esc_html($val) . '</span></span>', $term, $args);
                                    do_action('DejavoVS_term_after', $term);
                                }

                                $count++;
                            }

                            break;
                        case 'image':
                            foreach ($terms as $term) {
                                if (!$limit || ($count < $limit)) {
                                    $val = get_term_meta($term->term_id, 'DejavoVS_image', true) ? wp_get_attachment_thumb_url(get_term_meta($term->term_id, 'DejavoVS_image', true)) : wc_placeholder_img_src();
                                    $tooltip = get_term_meta($term->term_id, 'DejavoVS_tooltip', true) ?: $term->name;
                                    $class = apply_filters('DejavoVS_term_class', 'DejavoVS-term ' . $tooltip_class, $term, $args);

                                    if ($tooltip_lib === 'tippy') {
                                        $val_full = get_term_meta($term->term_id, 'DejavoVS_image', true) ? wp_get_attachment_image_url(get_term_meta($term->term_id, 'DejavoVS_image', true), 'full') : wc_placeholder_img_src();
                                        $tooltip_content = 'data-tippy-content="' . esc_attr(htmlentities('<span class="DejavoVS-tippy DejavoVS-tippy-' . esc_attr($term->term_id) . '"><span class="DejavoVS-tippy-inner"><span class="DejavoVS-tippy-title">' . esc_html($tooltip) . '</span><span class="DejavoVS-tippy-swatches"><span class="DejavoVS-tippy-swatches--image"><img src="' . esc_url($val_full) . '" alt="' . esc_attr($term->name) . '"/></span></span>' . (!empty($term->description) ? '<span class="DejavoVS-tippy-desc">' . esc_html($term->description) . '</span>' : '') . '</span></span>')) . '"';
                                    } elseif ($tooltip_lib === 'hint') {
                                        $tooltip_content = 'aria-label="' . esc_attr($tooltip) . '"';
                                    } else {
                                        $tooltip_content = '';
                                    }

                                    do_action('DejavoVS_term_before', $term);
                                    echo apply_filters('DejavoVS_term_html', '<span class="' . esc_attr($class) . '" ' . $tooltip_content . ' title="' . esc_attr($tooltip) . '" data-term="' . esc_attr($term->slug) . '"><span><img src="' . esc_url($val) . '" alt="' . esc_attr($term->name) . '"/></span></span>', $term, $args);
                                    do_action('DejavoVS_term_after', $term);
                                }

                                $count++;
                            }

                            break;
                        case 'radio':
                            $name = uniqid('DejavoVS_radio_');

                            foreach ($terms as $term) {
                                if (!$limit || ($count < $limit)) {
                                    $val = get_term_meta($term->term_id, 'DejavoVS_radio', true) ?: $term->name;
                                    $tooltip = get_term_meta($term->term_id, 'DejavoVS_tooltip', true) ?: $term->name;
                                    $class = apply_filters('DejavoVS_term_class', 'DejavoVS-term ' . $tooltip_class, $term, $args);

                                    if ($tooltip_lib === 'tippy') {
                                        $tooltip_content = 'data-tippy-content="' . esc_attr(htmlentities('<span class="DejavoVS-tippy DejavoVS-tippy-' . esc_attr($term->term_id) . '"><span class="DejavoVS-tippy-inner"><span class="DejavoVS-tippy-title">' . esc_html($tooltip) . '</span>' . (!empty($term->description) ? '<span class="DejavoVS-tippy-desc">' . esc_html($term->description) . '</span>' : '') . '</span></span>')) . '"';
                                    } elseif ($tooltip_lib === 'hint') {
                                        $tooltip_content = 'aria-label="' . esc_attr($tooltip) . '"';
                                    } else {
                                        $tooltip_content = '';
                                    }

                                    do_action('DejavoVS_term_before', $term);
                                    echo apply_filters('DejavoVS_term_html', '<span class="' . esc_attr($class) . '" ' . $tooltip_content . ' title="' . esc_attr($tooltip) . '" data-term="' . esc_attr($term->slug) . '"><span><input type="radio" name="' . esc_attr($name) . '" value="' . esc_attr($term->slug) . '"/> ' . esc_html($val) . '</span></span>', $term, $args);
                                    do_action('DejavoVS_term_after', $term);
                                }

                                $count++;
                            }

                            break;
                        default:
                            break;
                    }

                    if ($limit && ($count > $limit)) {
                        echo apply_filters('DejavoVS_more_html', '<span class="DejavoVS-more"><a href="' . esc_url($product->get_permalink()) . '">' . sprintf(esc_html__('+%d', 'dejavo'), ($count - $limit)) . '</a></span>', ($count - $limit));
                    }

                    do_action('DejavoVS_terms_after', $args);
                    echo '</div>';
                    do_action('DejavoVS_terms_below', $args);
                }
            } else {
                // custom attribute
                if (dej_options('dej_attr_button_default', 'yes') === 'yes') {
                    do_action('DejavoVS_terms_above', $args);

                    $terms_class = apply_filters('DejavoVS_terms_class', 'DejavoVS-terms DejavoVS-type-button DejavoVS-style-' . $style, $options, $args);
                    echo '<div class="' . esc_attr($terms_class) . '" data-attribute="' . esc_attr(wc_sanitize_taxonomy_name($attribute)) . '">';
                    do_action('DejavoVS_terms_before', $args);

                    foreach ($options as $option) {
                        if (!$limit || ($count < $limit)) {
                            $class = apply_filters('DejavoVS_term_class', 'DejavoVS-term ' . $tooltip_class, $option, $args);

                            if ($tooltip_lib === 'tippy') {
                                $tooltip_content = 'data-tippy-content="' . esc_attr(htmlentities('<span class="DejavoVS-tippy"><span class="DejavoVS-tippy-inner"><span class="DejavoVS-tippy-title">' . esc_html($option) . '</span></span></span>')) . '"';
                            } elseif ($tooltip_lib === 'hint') {
                                $tooltip_content = 'aria-label="' . esc_attr($option) . '"';
                            } else {
                                $tooltip_content = '';
                            }

                            do_action('DejavoVS_term_before', $option);
                            echo apply_filters('DejavoVS_term_html', '<span class="' . esc_attr($class) . '"  ' . $tooltip_content . ' title="' . esc_attr($option) . '" data-term="' . esc_attr($option) . '"><span>' . esc_html($option) . '</span></span>', $option, $args);
                            do_action('DejavoVS_term_after', $option);
                        }

                        $count++;
                    }

                    do_action('DejavoVS_terms_after', $args);
                    echo '</div>';
                    do_action('DejavoVS_terms_below', $args);
                }
            }

            return apply_filters('DejavoVS_terms_html', ob_get_clean(), $args) . $options_html;
        }

        function custom_columns($columns)
        {
            $columns['DejavoVS_value'] = esc_html__('Value', 'dejavo');
            $columns['DejavoVS_tooltip'] = esc_html__('Tooltip', 'dejavo');

            return $columns;
        }

        function custom_columns_content($columns, $column, $term_id)
        {
            if ($column === 'DejavoVS_value') {
                $term = get_term($term_id);
                $attr_id = wc_attribute_taxonomy_id_by_name($term->taxonomy);
                $attr = wc_get_attribute($attr_id);

                switch ($attr->type) {
                    case 'image':
                        $val = get_term_meta($term_id, 'DejavoVS_image', true);
                        echo '<img style="display: inline-block; border-radius: 3px; width: 40px; height: 40px; background-color: #eee; box-sizing: border-box; border: 1px solid #eee;" src="' . esc_url($val ? wp_get_attachment_thumb_url($val) : wc_placeholder_img_src()) . '"/>';

                        break;
                    case 'color':
                        $val = get_term_meta($term_id, 'DejavoVS_color', true);
                        echo '<span style="display: inline-block; border-radius: 3px; width: 40px; height: 40px; background-color: ' . esc_attr($val) . '; box-sizing: border-box; border: 1px solid #eee;"></span>';

                        break;
                    case 'button':
                        $val = get_term_meta($term_id, 'DejavoVS_button', true);
                        echo '<span style="display: inline-block; border-radius: 3px; height: 40px; line-height: 40px; padding: 0 15px; border: 1px solid #eee; background-color: #fff; min-width: 44px; box-sizing: border-box;">' . esc_html($val) . '</span>';

                        break;
                }
            }

            if ($column === 'DejavoVS_tooltip') {
                echo get_term_meta($term_id, 'DejavoVS_tooltip', true);
            }
        }

        public static function show_vs($product_id = null)
        {
            global $product;
            $global_product = $product;

            if ($product_id) {
                $product = wc_get_product($product_id);
            }

            if (!$product || !$product->is_type('variable')) {
                return;
            }

            $attributes = $product->get_variation_attributes();
            $available_variations = $product->get_available_variations();
            $variations_json = wp_json_encode($available_variations);
            $variations_attr = function_exists('wc_esc_json') ? wc_esc_json($variations_json) : _wp_specialchars($variations_json, ENT_QUOTES, 'UTF-8', true);

            if (is_array($attributes) && (count($attributes) > 0)) {
                do_action('DejavoVS_archive_variations_form_above', $product);
                echo '<div class="variations_form DejavoVS_archive" data-product_id="' . absint($product->get_id()) . '" data-product_variations="' . $variations_attr . '">';
                do_action('DejavoVS_archive_variations_form_before', $product);
                echo '<div class="variations">';
                do_action('DejavoVS_archive_variations_before', $product);

                foreach ($attributes as $attribute_name => $options) { ?>
                    <div class="variation">
                        <div class="label">
                            <?php echo wc_attribute_label($attribute_name); ?>
                        </div>
                        <div class="select">
                            <?php
                            $attr = 'attribute_' . sanitize_title($attribute_name);
                            $selected = isset($_REQUEST[$attr]) ? wc_clean(stripslashes(urldecode($_REQUEST[$attr]))) : $product->get_variation_default_attribute($attribute_name);
                            wc_dropdown_variation_attribute_options([
                                'options' => $options,
                                'attribute' => $attribute_name,
                                'product' => $product,
                                'limit' => dej_options('dej_attr_archive_limit', '6'),
                                'selected' => $selected,
                                'show_option_none' => esc_html__('Choose', 'dejavo') . ' ' . wc_attribute_label($attribute_name),
                            ]);
                            ?>
                        </div>
                    </div>
                <?php }

                echo '<div class="reset">' . apply_filters('woocommerce_reset_variations_link', '<a class="reset_variations" href="#">' . esc_html__('Clear', 'dejavo') . '</a>') . '</div>';
                do_action('DejavoVS_archive_variations_after', $product);
                echo '</div>';
                do_action('DejavoVS_archive_variations_form_after', $product);
                echo '</div>';
                do_action('DejavoVS_archive_variations_form_below', $product);
            }

            $product = $global_product;
        }

    }
    return DejavoVS::instance();

}


