<?php
defined('ABSPATH') || exit;

class dej_Banner_1 extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'dej_banner1';
    }

    public function get_title()
    {
        return esc_html__('بنر 1', 'dejavo');
    }


    public function get_icon()
    {
        return 'dej-picture';
    }



    public function get_categories()
    {
        return ['dejavo'];
    }


    public function get_keywords()
    {
        return ['بنر', 'banner'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'image',
            [
                'label' => esc_html__('Choose Image', 'elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('لینک دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );
        $this->add_control(
            'with-cap',
            [
                'label' => esc_html__('همراه متن و دکمه؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

            $this->add_control(
                'btn_title',
                [
                    'label' => esc_html__('متن دکمه', 'dejavo'),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'placeholder' => esc_html__('متن دکمه', 'dejavo'),
                    'default' => esc_html__('اکنون خرید کنید', 'dejavo'),
                    'label_block' => true,
                    'condition' => [
                        'with-cap' => 'yes',
                    ],

                ]
            );


            $this->add_control(
                'title',
                [
                    'label' => esc_html__('عنوان ', 'dejavo'),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'placeholder' => esc_html__('عنوان اصلی', 'dejavo'),
                    'default' => esc_html__('فروش فوق العاده', 'dejavo'),
                    'label_block' => true,
                    'condition' => [
                        'with-cap' => 'yes',
                    ],
                ]
            );
            $this->add_control(
                'subtitle',
                [
                    'label' => esc_html__('زیر عنوان', 'dejavo'),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'placeholder' => esc_html__('عنوان دوم', 'dejavo'),
                    'default' => esc_html__('مجموعه جدید', 'dejavo'),
                    'label_block' => true,
                    'condition' => [
                        'with-cap' => 'yes',
                    ],
                ]
            );


        $this->end_controls_section();

        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'style',
            [
                'label' => esc_html__('سبک نمایش', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('یک', 'dejavo'),
                    '2' => esc_html__('دو', 'dejavo'),
                    '3' => esc_html__('سه', 'dejavo'),
                    '4' => esc_html__('چهار', 'dejavo'),
                ],
            ]
        );
        $this->add_responsive_control(
            'min-height',
            [
                'label' => esc_html__( ' ارتفاع بنر', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 600,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner1 img, {{WRAPPER}} .banner1' => 'min-height: {{SIZE}}{{UNIT}};max-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'more_options2',
            [
                'label' => esc_html__( 'رنگ روکش تصویر', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'overlay-background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .banner1.overlay:before',
            ]
        );



        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله درونی بنر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر بنر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'margin',
            [
                'label' => esc_html__('فاصله بیرونی کپشن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner1 .info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'with-cap' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'margin-btn',
            [
                'label' => esc_html__('فاصله بیرونی دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner1 .link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'with-cap' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding-btn',
            [
                'label' => esc_html__('فاصله درونی دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner1.style2 .link a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'with-cap' => 'yes',
                ],
            ]
        );


        $this->add_control(
            'btn_border_radius',
            [
                'label' => esc_html__('کادر دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner1.style2 .link a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => esc_html__(' رنگ پس زمینه', 'dejavo'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .banner1',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان و دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner1 .info h3, {{WRAPPER}} .banner1 .info h5, {{WRAPPER}} .banner1 .link a, {{WRAPPER}} .banner1 .link.border a' => 'color: {{VALUE}} ; border-color: {{VALUE}} ',
                    '{{WRAPPER}} .banner1 .link a:hover, {{WRAPPER}} .banner1 .link.border a' => 'color: #fff; border-color:#fff',
                ],
            ]
        );
        $this->add_control(
            'bg_btn_color',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner1.style2 .link a' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .banner1.style1 .link a:before, {{WRAPPER}} .banner1.style3 .link a:before' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .banner1.style1 .link:hover a, {{WRAPPER}} .banner1.style3 .link:hover a' => 'box-shadow:inset -10em 0 0 0 {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'bg_btn_hover_color',
            [
                'label' => esc_html__('رنگ هاور پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner1.style2 .link a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'show_btn_icon',
            [
                'label' => esc_html__('تمایش آیکن درون دکمه؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_responsive_control(
            'font-size-h3',
            [
                'label' => esc_html__( 'سایز فونت عنوان اصلی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 14,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner1 .info h3' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'font-size-h5',
            [
                'label' => esc_html__( 'سایز فونت عنوان فرعی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 14,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner1 .info h5' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'font-size-btn',
            [
                'label' => esc_html__('سایز فونت دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 11,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner1 .link a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $style = $data['style'];
        $url = $data['btn_link']['url'];
        $btn_title = $data['btn_title'];
        if ($data['with-cap'] == 'yes') { ?>
        <div <?php if (!empty($url) ) {?> style="cursor:pointer" onclick="window.location.href='<?= $url ?>'" <?php } ?> class="banner1 overlay <?= 'style' . $style ?>">
            <?php if ($data['image']) { echo wp_get_attachment_image($data['image']['id'], 'original'); } ?>
            <div class="info">
                <?php if (!empty($data['title'])) { ?><h5><?= $data['title'] ?></h5>
                <?php } if (!empty($data['subtitle'])) { ?><h3><?= $data['subtitle'] ?></h3> <?php } ?>
            </div>
            <?php if (!empty($url) && !empty($btn_title)) { $this->add_link_attributes('btn_link', $data['btn_link']);
                if( $style == '1') {  ?>
                <div class="link"><a <?php echo $this->get_render_attribute_string('btn_link'); ?>><span><?= $data['btn_title'] ?></span></a></div>
            <?php  } elseif ( $style == '2' ) {  ?>
                <div class="link border"><a <?php echo $this->get_render_attribute_string('btn_link'); ?>><?= $data['btn_title'] ?> <?php if ($data['show_btn_icon']=='yes'){ ?><i class="dej-arrow-left"></i><?php } ?></a></div>
            <?php }  elseif ($style == '3' ) {  ?>
                <div class="link"><a <?php echo $this->get_render_attribute_string('btn_link'); ?>><?= $data['btn_title'] ?> </a></div>
            <?php } } ?>
        </div>
    <?php } else { ?>

        <div class="banner1 <?= 'style' . $style ?>">
                <?php if (!empty($url)) {
                    $this->add_link_attributes('btn_link', $data['btn_link']);
                    echo '<a ' . $this->get_render_attribute_string('btn_link') . ' >';  }
                if ($data['image']) {echo wp_get_attachment_image($data['image']['id'], 'original');}
                if (!empty($url)) { echo '</a>'; } ?>
        </div>

        <?php
    }

    }

}
