<?php
defined('ABSPATH') || exit;

class dej_Banner_3 extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'dej_banner3';
    }

    public function get_title()
    {
        return esc_html__('بنر 3', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-picture';
    }

    public function get_categories()
    {
        return ['dejavo'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'more_options',
            [
                'label' => esc_html__('پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => esc_html__('Choose Image', 'elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );

        $this->add_control(
            'with-cap',
            [
                'label' => esc_html__('همراه متن و دکمه؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );


        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('متن دکمه', 'dejavo'),
                'default' => esc_html__('اکنون خرید کنید', 'dejavo'),
                'label_block' => true,
                'condition' => [
                    'with-cap' => 'yes',
                ],

            ]
        );


        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان اصلی', 'dejavo'),
                'default' => esc_html__('فروش فوق العاده', 'dejavo'),
                'label_block' => true,
                'condition' => [
                    'with-cap' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('زیر عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان دوم', 'dejavo'),
                'default' => esc_html__('مجموعه جدید', 'dejavo'),
                'label_block' => true,
                'condition' => [
                    'with-cap' => 'yes',
                ],
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'img-zoom',
            [
                'label' => esc_html__('بزرگنمایی هاور پس زمینه؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'content_border_head',
            [
                'label' => esc_html__( 'مرز درون بنر', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'content_border',
                'selector' => '{{WRAPPER}} .banner3 .content',
            ]
        );
        $this->add_control(
            'button_border_head',
            [
                'label' => esc_html__( 'مرز دکمه', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .banner3 a',
            ]
        );

        $this->add_control(
            'btn_icon',
            [
                'label' => esc_html__('آیکن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-arrow-left',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'ob_head',
            [
                'label' => esc_html__('رنگ روکش تصویر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'overlay_background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .banner3:before',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner3 .title h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'sub_title_color',
            [
                'label' => esc_html__('رنگ زیر عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner3 .title h5' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_text_color',
            [
                'label' => esc_html__('رنگ متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner3 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_hover_text_color',
            [
                'label' => esc_html__('رنگ هاور متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner3 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'btn_hover_border_color',
            [
                'label' => esc_html__('رنگ هاور حاشیه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner3 a:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'bg_btn_color',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner3 a' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'bg_btn_hover_color',
            [
                'label' => esc_html__('رنگ هاور پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner3 a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'show_btn_icon',
            [
                'label' => esc_html__('تمایش آیکن درون دکمه؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );


        $this->add_responsive_control(
            'btn-margin',
            [
                'label' => esc_html__('فاصله بیرونی دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner3 a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'with-cap' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn-padding',
            [
                'label' => esc_html__('فاصله درونی دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner3 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'with-cap' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'btn_border_radius',
            [
                'label' => esc_html__('کادر دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner3 a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر بنر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner3, {{WRAPPER}} .banner3 .content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title-margin',
            [
                'label' => esc_html__('فاصله بیرونی عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .banner3 .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'with-cap' => 'yes',
                ],
            ]
        );



        $this->add_responsive_control(
            'font-size-h3',
            [
                'label' => esc_html__('سایز فونت عنوان اصلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 14,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner3 .title h3' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'font-size-h5',
            [
                'label' => esc_html__('سایز فونت عنوان فرعی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 14,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner3 .title h5' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'font-size-btn',
            [
                'label' => esc_html__('سایز فونت دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 11,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .banner3 a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );



        $this->end_controls_section();


    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $url = $data['btn_link']['url'];
        $btn_title = $data['btn_title'];
        $with_cap = $data['with-cap'];
        $with_zoom = $data['img-zoom'];
        ?>
        <div class="banner3 <?php if ($with_zoom=='yes') { echo ' zoom_hover';} ?>" <?php if (!empty($url) && $with_cap != 'yes' || (!empty($url) && $with_cap == 'yes' && empty($btn_title))) { ?> style="cursor:pointer" onclick="window.location.href='<?= $url ?>'" <?php } ?>>
            <div class="image"><?= wp_get_attachment_image($data['image']['id'], 'original') ?></div>
            <div class="content"><?php if ($with_cap) { ?>
                    <div class="title" <?php if (empty($url) || empty($btn_title)){?> style="transform: translateY(0px);" <?php }?> >
                        <?php if (!empty($data['title'])){ ?><h3><?= $data['title'] ?></h3><?php } ?>
                        <?php if (!empty($data['subtitle'])){ ?><h5><?= $data['subtitle'] ?></h5><?php } ?>
                    </div>
                    <?php if (!empty($url) && !empty($btn_title)){ $this->add_link_attributes('btn_link', $data['btn_link']); ?>
                        <a <?php echo $this->get_render_attribute_string('btn_link'); ?>><?= $btn_title ?>
            <?php if ($data['show_btn_icon']=='yes'){ ?><i class="<?= $data['btn_icon']['value'] ?>"></i><?php } ?></a>
                    <?php } } ?></div>
        </div>
        <?php
    }
}
