<?php
defined('ABSPATH') || exit;

class dej_Cart extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'dej_cart';
    }

    public function get_title()
    {
        return esc_html__('سبد خرید', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-shopping-cart';
    }

    public function get_categories()
    {
        return ['dejavo-header'];
    }

    public function get_keywords()
    {
        return ['سبد خرید', 'cart'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('سبد خرید', 'dejavo'),
                'default' => esc_html__('سبد خرید', 'dejavo'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => esc_html__('آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-shopping-cart',
                    'library' => '',
                ],
            ]
        );



        $this->end_controls_section();
        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_cart' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_cart' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__( 'مرز', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .dejavo_cart',
            ]
        );

        $this->add_control(
            'bor_hover_color',
            [
                'label' => esc_html__('رنگ هاور مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_cart:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'widget_bg',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_cart' => 'background: {{VALUE}}'
                ]
            ]
        );


        $this->add_control(
            'widget_hover_bg',
            [
                'label' => esc_html__('رنگ پس زمینه هاور ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_cart:hover' => 'background: {{VALUE}}'
                ]
            ]
        );



        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_cart .icon' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'hover_icon_color',
            [
                'label' => esc_html__('رنگ هاور آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_cart:hover .icon' => 'color: {{VALUE}}'
                ]
            ]
        );


        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_cart .title' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'hover_title_color',
            [
                'label' => esc_html__('رنگ  هاور عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_cart:hover .title' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('سایز فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_cart .icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_font_size',
            [
                'label' => esc_html__('سایز عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_cart .title' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );




        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .dejavo_cart',
            ]
        );


        $this->end_controls_section();

    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $title = $data['title'];
        $icon = $data['icon']['value'];
        global $dej_purchasable;
        if ($dej_purchasable) {
      ?>
        <div class="dejavo_cart header-cart-icon cart-show">
            <div class="icon"><i class="<?= $icon ?>"></i></div>
            <div class="title"><?= $title ?></div>
            <span class="icon_count" data-count="<?= WC()->cart->get_cart_contents_count(); ?>"></span>
            <div class="cart_box"><?php woocommerce_mini_cart(); ?></div>
        </div>
            <?php
        }

    }
}
