<?php
defined('ABSPATH') || exit;

class dej_HeaderIcon_1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_header_icon';
    }

    public function get_title()
    {
        return esc_html__('آیکن های سربرگ', 'dejavo');
    }


    public function get_icon()
    {
        return 'dej-megaphone';
    }


    public function get_categories()
    {
        return ['dejavo-header'];
    }


    public function get_keywords()
    {
        return ['آیکن'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_search',
            [
                'label' => esc_html__('نمایش جست و جو', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_account',
            [
                'label' => esc_html__('نمایش حساب کاربری', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );
        $this->add_control(
            'user_menu',
            [
                'label' => esc_html__('نمایش زیر منو حساب', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'show_account' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'align_acc',
            [
                'label' => esc_html__('چیدمان زیر منو حساب', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('راست', 'dejavo'),
                'label_off' => esc_html__('چپ', 'dejavo'),
                'return_value' => 'yes',
                'default' => '',
                'condition' => [
                    'user_menu' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'show_compare',
            [
                'label' => esc_html__('نمایش مقایسه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_wishlist',
            [
                'label' => esc_html__('نمایش علاقه مندی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_cart',
            [
                'label' => esc_html__('نمایش سبد خرید', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'mini_cart',
            [
                'label' => esc_html__('نمایش سبد خرید کوچک زیر منو', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'show_cart' => 'yes',
                ],
            ]
        );


        $this->add_control(
            'align_cart',
            [
                'label' => esc_html__('چیدمان سبد خرید کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('راست', 'dejavo'),
                'label_off' => esc_html__('چپ', 'dejavo'),
                'return_value' => 'yes',
                'default' => '',
                'condition' => [
                    'mini_cart' => 'yes',
                ],
            ]

        );

        $this->add_control(
            'show_menu',
            [
                'label' => esc_html__('نمایش منو همبرگری موبایل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',

            ]
        );

        $this->add_control(
            'justify_content',
            [
                'label' => esc_html__( 'چیدمان', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'flex-end',
                'options' => [
                    '' => esc_html__( 'Default', 'dejavo' ),
                    'flex-start' => esc_html__( 'start', 'dejavo' ),
                    'flex-end'  => esc_html__( 'end', 'dejavo' ),
                    'center' => esc_html__( 'center', 'dejavo' ),
                    'space-between' => esc_html__( 'between', 'dejavo' ),
                    'space-around' => esc_html__( 'around', 'dejavo' ),
                    'space-evenly' => esc_html__( 'evenly', 'dejavo' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_header_icons' => 'justify-content: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'max_width',
            [
                'label' => esc_html__('حداکثر عرض', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 400,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_header_icons' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'height',
            [
                'label' => esc_html__('ارتفاع ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_header_icons' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'margin',
            [
                'label' => esc_html__('فاصله بیرونی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_header_icons' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله درونی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_header_icons' => 'padding: 0 {{RIGHT}}{{UNIT}} 0 {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر گوشه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_header_icons' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__( 'مرز', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .dejavo_header_icons',
            ]
        );

        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'widget_bg',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_header_icons' => 'background: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_header_icons > li > a, .dejavo_header_icons > li > div > a' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'hover_icon_color',
            [
                'label' => esc_html__('رنگ هاور آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_header_icons > li > a:hover, .dejavo_header_icons > li > div > a:hover' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('سایز فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 27,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_header_icons > li > a, .dejavo_header_icons > li > div > a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .dejavo_header_icons',
            ]
        );



        $this->end_controls_section();

    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $align_cart = $data['align_cart'] === 'yes' ? 'right' : '';
        $align_acc = $data['align_acc'] === 'yes' ? 'right' : '';
        ?>
        <ul class="dejavo_header_icons">
        <?php if ($data['show_search']) { ?>
            <li class="header-search-icon" id="inline-popups"><a href="#dejavo_search" data-effect="mfp-move-from-top"><i class="dej-search"></i></a></li>
            <?php } if ($data['show_account']) { ?>
                <li class="user_header"><?php dej_login_link() ?><?php if ($data['user_menu'] ==='yes') { ?><div class="user_header_drop_menu <?= $align_acc ?>">
                        <ul><?php get_template_part('template/header/user-account-menu'); ?></ul>
                    </div><?php } ?>
                </li>
            <?php }   if ($data['show_compare'] && class_exists('DejavoCP')) {  ?>
                <li class="menu-item DejavoCP-menu-item menu-item-type-DejavoCP">
                    <a href="<?= DejavoCP::get_url() ?>"><i class="dej-shuffle"></i><span class="DejavoCP-menu-item-inner" data-count="<?= DejavoCP::get_count(); ?>"></span></a>
                </li>
            <?php  } if ($data['show_wishlist'] && class_exists('DejavoWL')) { ?>
                <li class="menu-item DejavoWL-menu-item menu-item-type-DejavoWL">
                    <a href="<?php echo DejavoWL::get_url(); ?>"><i class="dej-heart"></i><span class="DejavoWL-menu-item-inner"  data-count="<?= DejavoWL::get_count(); ?>"></span></a>
                </li>
            <?php }
        global $dej_purchasable;
        if ($data['show_cart'] && class_exists('woocommerce') and $dej_purchasable) { ?>

                <li class="cart-show <?= $align_cart ?>"><a class="header-cart-icon" href="#"><i class="dej-shopping-cart"></i>
                        <span class="icon_count" data-count="<?= WC()->cart->get_cart_contents_count(); ?>"></span></a>
                    <?php if ($data['mini_cart'] ==='yes') { ?><div class="cart_box"><?php woocommerce_mini_cart(); ?></div><?php } ?>
                </li>
            <?php } ?>
        <?php if ($data['show_menu']) { ?><li class="dej_mobile_menu"><a class="mobile_menu" href="#"><i class="dej-align-left"></i></a></li><?php } ?>
        </ul>

        <?php
    }
}
