<?php
defined('ABSPATH') || exit;
class dej_HeaderMenu_1 extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'dej_menu';
    }

    public function get_title()
    {
        return esc_html__('منو', 'dejavo');
    }


    public function get_icon()
    {
        return 'dej-menu-burger';
    }

    public function get_categories()
    {
        return ['dejavo-header'];
    }


    public function get_keywords()
    {
        return ['منو', 'menu'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'nav_section',
            [
                'label' => esc_html__('نوار اصلی', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'justify_content',
            [
                'label' => esc_html__( 'چیدمان', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '' => esc_html__( 'Default', 'dejavo' ),
                    'flex-start' => esc_html__( 'start', 'dejavo' ),
                    'flex-end'  => esc_html__( 'end', 'dejavo' ),
                    'center' => esc_html__( 'center', 'dejavo' ),
                    'space-between' => esc_html__( 'between', 'dejavo' ),
                    'space-around' => esc_html__( 'around', 'dejavo' ),
                    'space-evenly' => esc_html__( 'evenly', 'dejavo' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu' => 'justify-content: {{VALUE}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'nav_padding',
            [
                'label' => esc_html__('فاصله از داخل نوار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'nav_item_padding',
            [
                'label' => esc_html__('فاصله از داخل آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'nav_bg_color',
            [
                'label' => esc_html__('رنگ پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu ' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'nav_link_color',
            [
                'label' => esc_html__('رنگ لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu > .menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_nav_link',
            [
                'label' => esc_html__('رنگ هاور لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu > .menu-item > a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'nav_icon_color',
            [
                'label' => esc_html__('رنگ آیکن نوار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu > .menu-item > a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'nav_hover_icon_color',
            [
                'label' => esc_html__('رنگ آیکن نوار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu > .menu-item > a:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'sep_color',
            [
                'label' => esc_html__('رنگ جداکننده', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu > .menu-item.separator_menu:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'bor_head_be',
            [
                'label' => esc_html__('مرز نوار اصلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .mega_menu',
            ]
        );


        $this->add_control(
            'bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر نوار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'nav_font_size',
            [
                'label' => esc_html__('اندازه فونت متن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu > .menu-item > a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'nav_icon_font_size',
            [
                'label' => esc_html__('اندازه فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 40,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu > .menu-item > a i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'btn_icon_menu',
            [
                'label' => esc_html__('نمایش دکمه آیکن انتها منو ؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('پشتیبانی : 09121234567', 'dejavo'),
                'default' => esc_html__('پشتیبانی : 09121234567', 'dejavo'),
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => esc_html__('آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'dej-phone-call',
                ],
            ]
        );
        $this->add_control(
            'link',
            [
                'label' => esc_html__('لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('tel:09121234567', 'dejavo'),
                'default' => [
                    'url' => 'tel:09121234567',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn_icon_menu a i' => 'color: {{VALUE}}'
                ]
            ]
        );
        $this->add_control(
            'hover_icon_color',
            [
                'label' => esc_html__('رنگ هاور آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn_icon_menu a:hover i' => 'color: {{VALUE}}'
                ]
            ]
        );


        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn_icon_menu a' => 'color: {{VALUE}} ;',
                ],
            ]
        );


        $this->add_control(
            'hover_title_color',
            [
                'label' => esc_html__('رنگ هاور عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .btn_icon_menu a:hover' => 'color: {{VALUE}} ;',
                ],
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'classic_section',
            [
                'label' => esc_html__('زیر منو کلاسیک', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'classic_padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .simple_menu .sub-menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'classic_bg_color',
            [
                'label' => esc_html__('رنگ پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .simple_menu .sub-menu' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'classic_link_color',
            [
                'label' => esc_html__('رنگ لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .simple_menu .sub-menu > .menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_classic_link',
            [
                'label' => esc_html__('رنگ هاور لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .simple_menu .sub-menu > .menu-item > a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'classic_icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .simple_menu .sub-menu > .menu-item > a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'classic_hover_icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .simple_menu .sub-menu > .menu-item > a:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'classic_bor_head_be',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'classic_border',
                'selector' => '{{WRAPPER}} .simple_menu .sub-menu',
            ]
        );


        $this->add_control(
            'classic_bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'classic_radius',
            [
                'label' => esc_html__('کادر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .simple_menu .sub-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'classic_font_size',
            [
                'label' => esc_html__('اندازه فونت متن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .simple_menu .sub-menu li a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'classic_i_font_size',
            [
                'label' => esc_html__('اندازه فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 40,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .simple_menu .sub-menu li a i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow3',
                'selector' => '{{WRAPPER}} .simple_menu .sub-menu',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'm2_section',
            [
                'label' => esc_html__('مگا منو (دو سطحی)', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'm2_padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'devices' => ['desktop'],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le > .sub-menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'm2_l1_padding',
            [
                'label' => esc_html__('فاصله از داخل سطح یک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'devices' => ['desktop'],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le .sub-menu.le_0 > .menu-item > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'm2_bg_color',
            [
                'label' => esc_html__('رنگ پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'devices' => ['desktop'],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le > .sub-menu' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm2_link_color',
            [
                'label' => esc_html__('رنگ لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le .sub-menu.le_1 > .menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_m2_link',
            [
                'label' => esc_html__('رنگ هاور لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le .sub-menu.le_1 > .menu-item > a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm2_icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le .sub-menu.le_0 > .menu-item > a i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm2_hover_icon_color',
            [
                'label' => esc_html__('رنگ هاور آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le .sub-menu.le_0 > .menu-item > a:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm2_l1_bg_color',
            [
                'label' => esc_html__('رنگ پس زمینه سطح اول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le .sub-menu.le_0 > .menu-item > a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'm2_l1_link_color',
            [
                'label' => esc_html__('رنگ لینک سطح اول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le .sub-menu.le_0 > .menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm2_l1_hover_link',
            [
                'label' => esc_html__('رنگ هاور لینک سطح اول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le .sub-menu.le_0 > .menu-item > a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm2_bor_head_be',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'm2_border',
                'selector' => '{{WRAPPER}} .mega_menu_2le > .sub-menu',
            ]
        );


        $this->add_control(
            'm2_bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'm2_l1_bor_head_be',
            [
                'label' => esc_html__('مرز سطح اول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'm2_l1_border',
                'selector' => '{{WRAPPER}} .mega_menu_2le > .sub-menu > .menu-item > a',
            ]
        );
        $this->add_control(
            'hover_m2l1_bor_link',
            [
                'label' => esc_html__('رنگ هاور مرز سطح اول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le > .sub-menu > .menu-item > a:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'm2_l1_bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'm2_radius',
            [
                'label' => esc_html__('کادر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le > .sub-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'm2_l1_radius',
            [
                'label' => esc_html__('کادر سطح اول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le > .sub-menu  > .menu-item a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'm2_font_size',
            [
                'label' => esc_html__('اندازه فونت لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le .sub-menu.le_1 > .menu-item > a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'm2_l1_font_size',
            [
                'label' => esc_html__('اندازه فونت لینک سطح اول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le .sub-menu.le_0 > .menu-item > a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'm2_i_font_size',
            [
                'label' => esc_html__('اندازه فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 40,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_2le .sub-menu.le_0 > .menu-item > a i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow2',
                'selector' => '{{WRAPPER}} .mega_menu_2le .sub-menu.le_0',
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'm3_section',
            [
                'label' => esc_html__('مگا منو (سه سطحی)', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'm3_bg',
            [
                'label' => esc_html__('رنگ پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le > .sub-menu > .menu-item > .sub-menu, {{WRAPPER}} .mega_menu_3le > .sub-menu' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm3_l1_bg',
            [
                'label' => esc_html__('رنگ پس زمینه نوار تب', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le.dej-side-tab .sub-menu.le_0:before, {{WRAPPER}} .mega_menu_3le.dej-top-tab .sub-menu.le_0:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm3_link_color',
            [
                'label' => esc_html__('رنگ لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le .sub-menu.le_2 > .menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_m3_link',
            [
                'label' => esc_html__('رنگ هاور لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le .sub-menu.le_2 > .menu-item > a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm3_icon_color',
            [
                'label' => esc_html__('رنگ آیکن سطح دوم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le .sub-menu.le_1 > .menu-item > a i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm3_hover_icon_color',
            [
                'label' => esc_html__('رنگ هاور آیکن سطح دوم ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le .sub-menu.le_1 > .menu-item > a:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm3_l2_bg_color',
            [
                'label' => esc_html__('رنگ پس زمینه سطح دوم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le .sub-menu.le_1 > .menu-item > a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'm3_l2_link_color',
            [
                'label' => esc_html__('رنگ لینک سطح دوم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le .sub-menu.le_1 > .menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm3_l2_hover_link',
            [
                'label' => esc_html__('رنگ هاور لینک سطح دوم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le .sub-menu.le_1 > .menu-item > a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'm3_l1_icon_color',
            [
                'label' => esc_html__('رنگ آیکن سطح اول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le.dej-side-tab > .sub-menu.le_0 > .menu-item > a i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm3_l1_hover_icon_color',
            [
                'label' => esc_html__('رنگ هاور آیکن سطح اول ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le.dej-side-tab > .sub-menu.le_0 > .menu-item > a:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm3_l1_link_color',
            [
                'label' => esc_html__('رنگ لینک سطح اول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le.dej-side-tab > .sub-menu.le_0 > .menu-item > a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'm3_l1_hover_link',
            [
                'label' => esc_html__('رنگ هاور لینک سطح اول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le.dej-side-tab > .sub-menu.le_0 > .menu-item > a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'm3_bor_head_be',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'm3_border',
                'selector' => '{{WRAPPER}} .mega_menu_3le > .sub-menu',
            ]
        );


        $this->add_control(
            'm3_bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'm3_l1_bor_head_be',
            [
                'label' => esc_html__('مرز سطح اول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'm3_l1_border',
                'selector' => '{{WRAPPER}} .mega_menu_3le.dej-side-tab .sub-menu.le_0:before, {{WRAPPER}} .mega_menu_3le.dej-top-tab .sub-menu.le_0:before',
            ]
        );

        $this->add_control(
            'm3_l1_bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'm3_l2_bor_head_be',
            [
                'label' => esc_html__('مرز سطح دوم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'm3_l2_border',
                'selector' => '{{WRAPPER}} .mega_menu_3le .sub-menu.le_1 > .menu-item > a',
            ]
        );
        $this->add_control(
            'hover_m3_l2_bor_link',
            [
                'label' => esc_html__('رنگ هاور مرز سطح دوم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le .sub-menu.le_1 > .menu-item > a:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'm3_l2_bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'm3_radius',
            [
                'label' => esc_html__('کادر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le > .sub-menu > .menu-item > .sub-menu, {{WRAPPER}} .mega_menu_3le > .sub-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'm3_l1_radius',
            [
                'label' => esc_html__('کادر سطح اول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le.dej-side-tab .sub-menu.le_0:before, {{WRAPPER}} .mega_menu_3le.dej-top-tab .sub-menu.le_0:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'm3_l2_radius',
            [
                'label' => esc_html__('کادر سطح دوم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le .sub-menu.le_1 > .menu-item > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'm3_l2_font_size',
            [
                'label' => esc_html__('اندازه فونت سطح سوم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 12,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le .sub-menu.le_2 > .menu-item > a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'm3_l1_font_size',
            [
                'label' => esc_html__('اندازه فونت سطح دوم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 13,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le .sub-menu.le_1 > .menu-item > a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'm3_l0_font_size',
            [
                'label' => esc_html__('اندازه فونت سطح اول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'devices' => ['desktop'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le .sub-menu.le_0 > .menu-item > a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'm3_i_font_size',
            [
                'label' => esc_html__('اندازه فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'devices' => ['desktop'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 40,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mega_menu_3le .sub-menu.le_0 > .menu-item > a i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow1',
                'selector' => '{{WRAPPER}} .mega_menu_3le .sub-menu.le_0',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'mega_el_section',
            [
                'label' => esc_html__('مگا منو (المنتوری)', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'mega_el_padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'devices' => ['desktop'],
                'selectors' => [
                    '{{WRAPPER}} .mega_elementor' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'mega_el_bg_color',
            [
                'label' => esc_html__('رنگ پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mega_elementor' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'mega_el_bor_head_be',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'mega_el_border',
                'selector' => '{{WRAPPER}} .mega_elementor',
            ]
        );


        $this->add_control(
            'mega_el_bor_head_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'mega_el_radius',
            [
                'label' => esc_html__('کادر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .mega_elementor' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .mega_elementor',
            ]
        );


        $this->end_controls_section();


    }


    protected function render()
    {
        $data = $this->get_settings_for_display();

        if ( ! empty( $data['link']['url'] ) ) {
            $this->add_link_attributes( 'link', $data['link'] );
        }
        if (has_nav_menu('main_menu')) {
            $walker = new Dej_Walker_Nav_Menu;
            if (!wp_is_mobile()) { ?>
                <ul class="mega_menu">
                    <?php wp_nav_menu(array('container' => 'true', 'theme_location' => 'main_menu', 'depth' => 4, 'items_wrap' => '%3$s', 'walker' => $walker)); ?>
                    <?php if ($data['btn_icon_menu']) { ?><div class="btn_icon_menu"><a <?php echo $this->get_render_attribute_string( 'link' ); ?>><?= $data['title'] ?> <i class="<?= $data['icon']['value'] ?>"></i></a></div> <?php } ?>
                </ul>
                <script>
                    jQuery(document).ready((function ($) {
                        var maxHeight = -1; var megaMenu =  $('.dej-side-tab .le_1');
                        megaMenu.each(function() {if ($(this).height() > maxHeight) {maxHeight = $(this).height();}});
                        megaMenu.height(maxHeight); $('.dej-side-tab .le_0').height(maxHeight);
                        <?php if (dej_options('active_sticky_nav')) { ?>
                        $('.mega_menu').parents('.e-parent').addClass('dej_sticky_menu');
                        <?php } else { ?>
                        $('.mega_menu').parents('.e-parent').addClass('dej_menu_zindex');
                        <?php }  ?>
                    }));

                </script>
                <?php
            }
        }
    }
}
