<?php
defined('ABSPATH') || exit;
class dej_BlogSlider_1 extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'dej_blog_slider';
    }

    public function get_title()
    {
        return esc_html__('اسلایدر وبلاگ', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-book-open-reader';
    }


    public function get_categories()
    {
        return ['dejavo'];
    }


    public function get_keywords()
    {
        return ['بلاگ', 'وبلاگ'];
    }


    protected function register_controls()
    {
        $post_cat = [];
        $cats = get_terms("category");
        if (!is_wp_error($cats) && !empty($cats)) {
            foreach ($cats as $cat) {
                $post_cat[$cat->term_id] = $cat->name;
            }
        }

        $this->start_controls_section(
            'content_section', [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان اصلی', 'dejavo'),
                'default' => esc_html__('مجله بلاگی', 'dejavo'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => esc_html__('تعداد مطالب', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 8,
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__('مرتب سازی بر اساس', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC' => esc_html__('نزولی', 'dejavo'),
                    'ASC' => esc_html__('صعودی', 'dejavo'),
                ],
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('مرتب سازی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'rand' => esc_html__('تصادفی', 'dejavo'),
                    'date' => esc_html__('تاریخ', 'dejavo'),
                    'modified' => esc_html__('بروزرسانی', 'dejavo'),
                ],
            ]
        );
        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('فیلتر دسته بندی ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'category',
            [
                'label' => esc_html__('دسته بندی ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'condition' => [
                    'show_cat' => 'yes',
                ],
                'options' => $post_cat,
            ]
        );
        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('متن دکمه', 'dejavo'),
                'default' => esc_html__('موارد بیشتر', 'dejavo'),
                'label_block' => true,

            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('لینک دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('/blog', 'dejavo'),
                'default' => [
                    'url' => '/blog/',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'mob_scroll',
            [
                'label' => esc_html__( 'حالت اسکرول افقی در موبایل ؟', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'hide_scrollbar',
            [
                'label' => esc_html__( 'مخفی کردن اسکرول بار در موبایل ؟', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'mob_scroll' => 'yes',
                ],
            ]
        );


        $this->add_control(
            'img_zoom',
            [
                'label' => esc_html__('بزرگنمایی هاور تصویر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );


        $this->add_control(
            'number-in-page',
            [
                'label' => esc_html__('تعداد قابل مشاهده', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 3,
                'max' => 5,
                'step' => 1,
                'default' => 4,
            ]
        );
        $this->add_control(
            'number-in-page-laptop',
            [
                'label' => esc_html__('تعداد قابل مشاهده لپ تاپ کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 3,
            ]
        );
        $this->add_control(
            'number-in-page-tablet',
            [
                'label' => esc_html__('تعداد قابل مشاهده تبلت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 3.5,
                'step' => 0.1,
                'default' => 2,
            ]
        );
        $this->add_control(
            'number-in-page-mobile',
            [
                'label' => esc_html__('تعداد قابل مشاهده موبایل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 2.3,
                'step' => 0.1,
                'default' => 2,
            ]
        );
        $this->add_control(
            'scroll-time',
            [
                'label' => esc_html__('زمان تاخیر اسکرول خودکار ( میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 3000,
                'max' => 12000,
                'step' => 200,
                'default' => 6000,
            ]
        );
        $this->add_control(
            'scroll-speed',
            [
                'label' => esc_html__('سرعت اسکرول ( میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 400,
                'max' => 1600,
                'step' => 100,
                'default' => 1000,
            ]
        );
        $this->add_control(
            'free-mode',
            [
                'label' => esc_html__('اسکرول آزاد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('چرخش خودکار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 3,
                'max' => 30,
                'step' => 1,
                'default' => 15,
            ]
        );
        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('نمایش فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );


        $this->add_control(
            'show_dots',
            [
                'label' => esc_html__('نمایش نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );


        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .blog_slider_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'head-padding',
            [
                'label' => esc_html__('فاصله خارجی عنوان و دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title-padding',
            [
                'label' => esc_html__('فاصله درونی عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .blog_slider_1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .post_card_1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title, {{WRAPPER}} .dej_heading_1 .title .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'more_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه موارد بیشتر و فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more, {{WRAPPER}} .dej_heading_1 .arrows' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__( 'مرز ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .blog_slider_1',
            ]
        );

        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'item_bor_opt_be',
            [
                'label' => esc_html__( 'مرز آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .post_card_1',
            ]
        );

        $this->add_control(
            'item_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'title_bor_opt_be',
            [
                'label' => esc_html__('مرز عنوان ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'title_border',
                'selector' => '{{WRAPPER}} .blog_slider_1 .title',
            ]
        );

        $this->add_control(
            'title_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => esc_html__(' رنگ پس زمینه', 'dejavo'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .blog_slider_1',
            ]
        );




        $this->add_control(
            'head_options',
            [
                'label' => esc_html__('نوار عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_icon',
            [
                'label' => esc_html__('آیکن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-book-alt',
                    'library' => '',
                ],
            ]
        );
        $this->add_control(
            'next_icon',
            [
                'label' => esc_html__('آیکن بعدی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-right',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'prev_icon',
            [
                'label' => esc_html__('آیکن قبلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-left',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_bg',
            [
                'label' => esc_html__('رنگ پس زمینه عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title .icon' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'more_color',
            [
                'label' => esc_html__('رنگ متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'more_hover_color',
            [
                'label' => esc_html__('رنگ هاور متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more:hover' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'more_bg',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_more_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'arrows_color',
            [
                'label' => esc_html__('رنگ فلشها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrows_bg',
            [
                'label' => esc_html__('رنگ پس زمینه فلشها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('سایز فونت آیکن ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'h3_font_size',
            [
                'label' => esc_html__('سایز فونت عنوان ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'h3_line_height',
            [
                'label' => esc_html__('ارتفاع متن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'h3_font_weight',
            [
                'label' => esc_html__('وزن فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 300,
                        'max' => 900,
                        'step' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 500,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'font-weight: {{SIZE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'more_font_size',
            [
                'label' => esc_html__('سایز فونت متن موارد بیشتر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrows_font_size',
            [
                'label' => esc_html__('سایز فونت فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .blog_slider_1',
            ]
        );


        $this->end_controls_section();


    }


    protected function render()
    {
        global $post;

        $data = $this->get_settings_for_display();
        $title = $data['title'];
        $btn_url = $data['btn_link']['url'];
        $space_between = $data['space_between'] ?? 15;
        $title_icon = $data['title_icon']['value'] ?? '';
        $next_icon = $data['next_icon']['value'] ?? '';
        $prev_icon = $data['prev_icon']['value'] ?? '';
        $img_zoom = $data['img_zoom'] ? 'img_zoom' : '';
        $wid_id = $this->get_id_int();

        $data_swiper = ['spaceBetween' => $space_between, 'watchSlidesProgress' => true ];
        if ($data['free-mode'] == 'yes') { $data_swiper['freeMode'] = true; }
        if ($data['autoplay'] == 'yes') {$data_swiper['autoplay'] = ['delay' => $data['scroll-time'], 'disableOnInteraction' => false, 'pauseOnMouseEnter' => true];}
        if ($data['show_arrow'] == 'yes') {$data_swiper['navigation'] = ['nextEl' => ".dejavo_next_Arrow.id{$wid_id}", 'prevEl' => ".dejavo_prev_Arrow.id{$wid_id}"];}
        if ($data['show_dots'] == 'yes') {$data_swiper['pagination'] = ['el' => ".swiper-pagination.sp{$wid_id}", 'clickable' => true];}
        $data_swiper['breakpoints'] = ['0' => ['slidesPerView' => $data['number-in-page-mobile'] ,'speed' => 300,'slidesPerGroup' => 1], '576' => ['slidesPerView' => $data['number-in-page-tablet'] ], '768' => ['slidesPerView' => $data['number-in-page-laptop'], 'speed' => $data['scroll-speed']], '992' => ['slidesPerView' => $data['number-in-page'], 'speed' =>  $data['scroll-speed'] ]];


        $this->add_render_attribute( [
            'swiper-opt' => [
                'class' => 'dej_swiper swiper',
                'id' => 'DejavoSwiper'.$wid_id,
                'dir' => 'rtl',
                'data-swiper' => wp_json_encode($data_swiper)
            ],
        ] );


        $hide_scrollbar = '';
        if ($data['hide_scrollbar'] == 'yes') {
            $hide_scrollbar = ' scrollbar-hidden';
        }
        $this->add_render_attribute( [
            'mobile-opt' => [
                'class' => 'mob_wrapper' . $hide_scrollbar,
            ],
        ] );


        if (wp_is_mobile() and $data['mob_scroll']) {
            $wrapper_class = 'mobile-opt';
        } else {
            $wrapper_class = 'swiper-opt';
        }
        ?>

        <div class="blog_slider_1">

            <?php if ($title) { ?>
                <div class="dej_heading_1">
                    <div class="title">
                        <?php if ($title_icon) { ?><div class="icon"><i class="<?= $title_icon ?>"></i></div><?php } ?>
                        <h3><?= $title ?></h3>
                    </div>
                    <div class="arrow_more">
                        <?php  if (!empty($btn_url)){ ?>
                            <a class="more <?php if($wrapper_class === 'mobile-opt') { echo 'mob_type';} ?>" href="<?= $btn_url ?>"><?= $data['btn_title'] ?></a>
                        <?php }
                        if ($data['show_arrow'] === 'yes' and  $wrapper_class === 'swiper-opt') { ?>
                            <div class="arrows"><div class="dejavo_next_Arrow id<?= $wid_id; ?>"><i class="<?= $next_icon ?>"></i></div><div class="dejavo_prev_Arrow id<?= $wid_id; ?>"><i class="<?= $prev_icon ?>"></i></div></div>
                        <?php }  ?>
                    </div>
                </div>
            <?php }  ?>

            <div class="slides">
                <div <?= $this->get_render_attribute_string( $wrapper_class ) ?>>
                    <div class="swiper-wrapper">
                        <?php $args = array('post_type' => 'post', 'post_status' => 'publish', 'posts_per_page' => $data['number'], 'order' => $data['order'], 'orderby' => $data['orderby'],);
                        if (!empty($data['category'])) {
                            $args['tax_query'] = array(
                                array('taxonomy' => 'category', 'field' => 'term_id', 'terms' => $data['category'],)
                            );
                        }
                        $loop = new \WP_Query($args);
                        if ($loop->have_posts()) {
                            while ($loop->have_posts()) {
                                $loop->the_post();
                                $post_id =$post->ID;
                                $category_detail = get_the_category($post_id);
                                $cat_opt = get_term_meta($category_detail[0]->term_id, 'dej_category_options', true);

                                ?>
                                <div class="post_card_1 item<?= $post_id ?> swiper-slide <?= $img_zoom ?>" style="cursor:pointer" onclick="window.location.href='<?php the_permalink(); ?>'">
                                    <?php echo '<div class="cat">' . $category_detail[0]->cat_name . '</div>'; ?>
                                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('medium_large'); ?></a>
                                    <h3 class="title"><a href="<?php the_permalink(); ?>"><?php the_title() ?></a></h3>
                                </div>
                                <?php if ($cat_opt && $cat_opt['dej_cat_color']) { ?>
                                    <style>
                                        <?= '.post_card_1.item' . $post_id .':hover' ?> {  border-color: <?= $cat_opt['dej_cat_color'] ?> !important; }
                                        <?= '.post_card_1.item' .  $post_id . ' .cat' ?>  {  background: <?= $cat_opt['dej_cat_color'] ?> !important; }
                                    </style>
                                <?php } ?>

                            <?php }

                        } else { ?>
                            <p class="not_found">موردی یافت نشد</p>
                        <?php }
                        wp_reset_postdata(); ?>

                    </div>
                </div>
                <?php if ($data['show_dots'] == 'yes' and $wrapper_class === 'swiper-opt') { ?><div class="swiper-pagination sp<?= $wid_id; ?>"></div><?php }  ?>
            </div>
            <?php if (\Elementor\Plugin::$instance->editor->is_edit_mode()) { ?><script> dej_initSwipers(); </script> <?php } ?>
        </div>

        <?php
    }

}
