<?php
defined('ABSPATH') || exit;

class dej_CategoryBox_1 extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'dej_category_1';
    }

    public function get_title()
    {
        return esc_html__('دسته بندی سفارشی', 'dejavo');
    }


    public function get_icon()
    {
        return 'dej-chart-tree';
    }


    public function get_categories()
    {
        return ['dejavo'];
    }


    public function get_keywords()
    {
        return ['دسته بندی'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('دسته بندی ', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'cat_list',
            [
                'label' => esc_html__('آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'title',
                        'label' => esc_html__('عنوان', 'dejavo'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('عنوان', 'dejavo'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'subtitle',
                        'label' => esc_html__('عنوان دوم', 'dejavo'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('عنوان دوم', 'dejavo'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'image',
                        'label' => esc_html__('تصویر', 'dejavo'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'name' => 'link',
                        'label' => esc_html__('لینگ', 'dejavo'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
                    ],
                    [
                        'name' => 'bg_color',
                        'label' => esc_html__('رنگ پس زمینه تصویر', 'dejavo'),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} {{CURRENT_ITEM}} .image' => 'background-color: {{VALUE}}'
                        ],
                    ],
                    [
                        'name' => 'h5_color',
                        'label' => esc_html__('رنگ عنوان', 'dejavo'),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} {{CURRENT_ITEM}} .content h5, {{WRAPPER}} {{CURRENT_ITEM}} .content h5 a' => 'color: {{VALUE}}'
                        ],
                    ],

                    [
                        'name' => 'text_color',
                        'label' => esc_html__('رنگ متن', 'dejavo'),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} {{CURRENT_ITEM}} p a, {{WRAPPER}} {{CURRENT_ITEM}} .content p' => 'color: {{VALUE}}'
                        ],
                    ],
                ],

                'default' => [
                    [
                        'title' => esc_html__('عنوان #1', 'dejavo'),
                    ],
                ],

                'title_field' => '{{{ title }}}',
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__('استایل هاور', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '0' => esc_html__('هیچ', 'dejavo'),
                    '1' => esc_html__('یک', 'dejavo'),
                    '2' => esc_html__('دو', 'dejavo'),
                    '3' => esc_html__('سه', 'dejavo'),
                    '4' => esc_html__('چهار', 'dejavo'),
                    '5' => esc_html__('پنج', 'dejavo'),
                    '6' => esc_html__('شش', 'dejavo'),
                ],
            ]
        );


        $this->add_control(
            'img_size',
            [
                'label' => esc_html__('اندازه تصویر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'thumbnail',
                'options' => [
                    'woocommerce_gallery_thumbnail' => esc_html__('100px cropped', 'dejavo'),
                    'thumbnail' => esc_html__('150px', 'dejavo'),
                    'medium' => esc_html__('300px', 'dejavo'),
                    'woocommerce_thumbnail' => esc_html__('300px cropped', 'dejavo'),
                    'woocommerce_single' => esc_html__('600حط', 'dejavo'),
                    'full' => esc_html__('اصلی', 'dejavo'),
                ],
            ]
        );


        $this->add_control(
            'active_slider',
            [
                'label' => esc_html__( 'حالت اسلایدری', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'بله', 'dejavo' ),
                'label_off' => esc_html__( 'خیر', 'dejavo' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_btn',
            [
                'label' => esc_html__( 'دکمه نمایش در حالت خالی بودن عنوان دوم؟', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'بله', 'dejavo' ),
                'label_off' => esc_html__( 'خیر', 'dejavo' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );


        $this->add_control(
            'desktop_cols',
            [
                'label' => esc_html__('تعداد ستون', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 12,
                'step' => 1,
                'default' => 8,
            ]
        );
        $this->add_control(
            'laptop_cols',
            [
                'label' => esc_html__('تعداد ستون لپ تاپ کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 8,
                'step' => 1,
                'default' => 6,
            ]
        );
        $this->add_control(
            'tablet_cols',
            [
                'label' => esc_html__('تعداد ستون تبلت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 6,
                'step' => 1,
                'default' => 3,
            ]
        );
        $this->add_control(
            'mobile_cols',
            [
                'label' => esc_html__('تعداد ستون موبایل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 4,
                'step' => 1,
                'default' => 3,
            ]
        );
        $this->add_control(
            'number-in-scroll',
            [
                'label' => esc_html__('تعداد در هر اسکرول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 6,
                'step' => 1,
                'default' => 1,
            ]
        );
        $this->add_control(
            'scroll-time',
            [
                'label' => esc_html__('زمان تاخیر اسکرول خودکار (برحسب میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 3000,
                'max' => 12000,
                'step' => 200,
                'default' => 6000,
            ]
        );
        $this->add_control(
            'scroll-speed',
            [
                'label' => esc_html__('سرعت اسکرول (برحسب میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 400,
                'max' => 1600,
                'step' => 100,
                'default' => 700,
            ]
        );
        $this->add_control(
            'free-mode',
            [
                'label' => esc_html__('اسکرول آزاد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('نمایش فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );


        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('چرخش خودکار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 80,
                'step' => 1,
                'default' => 30,
            ]
        );

        $this->add_control(
            'next_icon',
            [
                'label' => esc_html__('آیکن بعدی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-right',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'prev_icon',
            [
                'label' => esc_html__('آیکن قبلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-left',
                    'library' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .category_box_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('فاصله از داخل آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'img_padding',
            [
                'label' => esc_html__('فاصله از داخل تصاویر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .item .image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => esc_html__('فاصله از داخل فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .dejavo_next_Arrow, {{WRAPPER}} .category_box_1 .dejavo_prev_Arrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
            'hr0',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'more_options0',
            [
                'label' => esc_html__( 'گوشه ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .category_box_1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'img_border_radius',
            [
                'label' => esc_html__('کادر تصاویر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .item .image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_bor_rad1',
            [
                'label' => esc_html__('کادر فلش راست', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .dejavo_next_Arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'arrow_bor_rad2',
            [
                'label' => esc_html__('کادر فلش چپ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .dejavo_prev_Arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'font_size',
            [
                'label' => esc_html__('سایز فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 13,
                ],
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .content h5, {{WRAPPER}} .category_box_1 .content h5 a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'p_font_size',
            [
                'label' => esc_html__('سایز فونت زیر عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 12,
                ],
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .content p, {{WRAPPER}} .category_box_1 .content p a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .category_box_1',
            ]
        );
        $this->add_control(
            'item_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیتم ها', 'avina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .item' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_item_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه آیتم ها', 'avina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .item:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'img_bg',
            [
                'label' => esc_html__('رنگ پس زمینه تصویر آیتم ها', 'avina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .item .image' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_img_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه تصویر آیتم ها', 'avina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .item:hover .image' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_item_h5',
            [
                'label' => esc_html__('رنگ هاور عنوان', 'avina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .item:hover .content h5, {{WRAPPER}} .category_box_1 .item:hover .content h5 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_item_p',
            [
                'label' => esc_html__('رنگ هاور زیر عنوان', 'avina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .item:hover .content p, {{WRAPPER}} .category_box_1 .item:hover .content p a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'arrow_color',
            [
                'label' => esc_html__('رنگ فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .dejavo_next_Arrow i, {{WRAPPER}} .category_box_1 .dejavo_prev_Arrow i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_arrow_color',
            [
                'label' => esc_html__('رنگ هاور فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .dejavo_next_Arrow:hover i, {{WRAPPER}} .category_box_1 .dejavo_prev_Arrow:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_bg',
            [
                'label' => esc_html__('رنگ پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .dejavo_next_Arrow, {{WRAPPER}} .category_box_1 .dejavo_prev_Arrow' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_icon_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .dejavo_next_Arrow:hover, {{WRAPPER}} .category_box_1 .dejavo_prev_Arrow:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrows_font_size',
            [
                'label' => esc_html__('سایز فونت فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .dejavo_next_Arrow i, {{WRAPPER}} .category_box_1 .dejavo_prev_Arrow i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'more_options',
            [
                'label' => esc_html__( 'مرز آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .category_box_1 .item',
            ]
        );
        $this->add_control(
            'hover_border_color',
            [
                'label' => esc_html__('رنگ هاور مرز', 'avina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .item:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hr2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'img_bor_h',
            [
                'label' => esc_html__( 'مرز تصویر آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'img_bor',
                'selector' => '{{WRAPPER}} .category_box_1 .item .image',
            ]
        );
        $this->add_control(
            'hover_img_bor',
            [
                'label' => esc_html__('رنگ هاور مرز تصویر', 'avina'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .category_box_1 .item:hover .image' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'item_shadow_h',
            [
                'label' => esc_html__( 'سایه آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .category_box_1 .item',
            ]
        );

        $this->add_control(
            'img_shadow_h',
            [
                'label' => esc_html__( 'سایه تصویر آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'img_shadow',
                'selector' => '{{WRAPPER}} .category_box_1 .item .image',
            ]
        );


        $this->end_controls_section();

    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $active_slider = $data['active_slider'] ?? 1;
        $items = $data['cat_list'];
        $style = $data['style'] ?? 1;
        $img_size = $data['img_size'] ?? 'thumbnail';
        $space_between = intval($data['space_between']) ?? 20;
        $wid_id = $this->get_id_int();



        $data_swiper = ['spaceBetween' => $space_between, 'watchSlidesProgress' => true ];
        if ($data['free-mode'] == 'yes') { $data_swiper['freeMode'] = true; }
        if ($data['autoplay'] == 'yes') {$data_swiper['autoplay'] = ['delay' => $data['scroll-time'], 'disableOnInteraction' => false, 'pauseOnMouseEnter' => true];}
        if ($data['show_arrow'] == 'yes') {$data_swiper['navigation'] = ['nextEl' => ".dejavo_next_Arrow.id{$wid_id}", 'prevEl' => ".dejavo_prev_Arrow.id{$wid_id}"];}
        $data_swiper['breakpoints'] = ['0' => ['slidesPerView' => $data['mobile_cols'] ,'speed' => 300,'slidesPerGroup' => 2, 'spaceBetween' => intval($space_between/5)], '576' => ['slidesPerView' => $data['tablet_cols'], 'spaceBetween' => intval($space_between/3) ], '768' => ['slidesPerView' => $data['laptop_cols'], 'speed' => $data['scroll-speed'], 'spaceBetween' => intval($space_between/2)], '992' => ['slidesPerView' => $data['desktop_cols'], 'speed' =>  $data['scroll-speed'], 'spaceBetween' => $space_between ]];


        $this->add_render_attribute( [
            'swiper-opt' => [
                'class' => 'dej_swiper swiper',
                'id' => 'DejavoSwiper'.$wid_id,
                'dir' => 'rtl',
                'data-swiper' => wp_json_encode($data_swiper)
            ],
        ] );

        $cols = 'mob_col'. $data['mobile_cols'] . ' tab_col'. $data['tablet_cols'] . ' lap_col'. $data['laptop_cols'] . ' col'. $data['desktop_cols'];


        if ($items) { ?>
            <div class="category_box_1 <?php
            if ($active_slider) {
                echo 'category-carousel';
            } else{
            echo 'd_grid ' . $cols;
            }
            echo ' style' . $style
            ?>">
                <?php if ($active_slider) { ?>
                <div <?= $this->get_render_attribute_string( 'swiper-opt' ) ?>>
                    <div class="swiper-wrapper">
                        <?php } ?>
                        <?php foreach ($items as $item) {
                            $link = $item['link']['url'];
                            $before_url = $link ? '<a href="' . $link . '">'  : '';
                            $after_url = $link ? '</a>' : '';
                            ?>
                            <?php if ($active_slider) { echo '<div class="swiper-slide">'; } ?>
                            <div class="item elementor-repeater-item-<?= esc_attr($item['_id']) ?>">
                                <div class="image"><?= $before_url . wp_get_attachment_image($item['image']['id'], $img_size) . $after_url ?></div>
                                <div class="content">
                                    <?php if ($item['title']){ ?> <h5><?= $before_url . $item['title'] . $after_url ?> </h5> <?php } ?>
                                    <?php if ($item['subtitle']) { ?><p><?= $before_url . $item['subtitle']; ?> <i class="dej-arrow-left"></i><?= $after_url ?></p>
                                    <?php } elseif($data['show_btn']) { ?> <p><?= $before_url ?>نمایش <i class="dej-arrow-left"></i><?= $after_url ?></p><?php } ?>
                                </div>
                            </div>

                            <?php if ($active_slider) { echo '</div>';}
                        } ?>

                        <?php if ($active_slider) { ?>
                    </div>
                    <?php if ($data['show_arrow'] == 'yes') { ?> <div class="dejavo_next_Arrow id<?= $wid_id; ?>"><i class="<?= $data['next_icon']['value'] ?>"></i></div><div class="dejavo_prev_Arrow id<?= $wid_id; ?>"><i class="<?= $data['prev_icon']['value'] ?>"></i></div><?php }  ?>
                </div>
            <?php } ?>

            </div>
            <?php if (\Elementor\Plugin::$instance->editor->is_edit_mode() and $active_slider) { ?><script> dej_initSwipers(); </script> <?php }
        }
    }

}
