<?php
defined('ABSPATH') || exit;

class dej_IconBox_1 extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'dej_icon_box_1';
    }

    public function get_title()
    {
        return esc_html__('آیکن باکس ', 'dejavo');
    }


    public function get_icon()
    {
        return 'dej-info';
    }


    public function get_categories()
    {
        return ['dejavo'];
    }


    public function get_keywords()
    {
        return ['آیکن', 'باکس'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('آیکن باکس', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $iconbox = new \Elementor\Repeater();

        $iconbox->add_control(
            'title',
            [
                'label' => esc_html__('عنوان ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان اصلی', 'dejavo'),
                'label_block' => true,
            ]
        );
        $iconbox->add_control(
            'subtitle',
            [
                'label' => esc_html__('زیر عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان دوم', 'dejavo'),
                'label_block' => true,
            ]
        );
        $iconbox->add_control(
            'icon',
            [
                'label' => esc_html__('آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
            ]
        );
        $iconbox->add_control(
            'link',
            [
                'label' => esc_html__('لینک دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
            ]
        );

        $iconbox->add_control(
            'item_bg_head',
            [
                'label' => esc_html__('پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $iconbox->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_bg',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}.item',
            ]
        );
        $iconbox->add_control(
            'hover_item_bg_head',
            [
                'label' => esc_html__('هاور پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $iconbox->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'hover_item_bg',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}.item:hover',
            ]
        );

        $iconbox->add_control(
            'icon_bg',
            [
                'label' => esc_html__('پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.item .icon' => 'background-color: {{VALUE}}'
                ]
            ]
        );
        $iconbox->add_control(
            'hover_icon_bg',
            [
                'label' => esc_html__('هاور پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.item:hover .icon' => 'background-color: {{VALUE}}'
                ]
            ]
        );

        $iconbox->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.item .icon i' => 'color: {{VALUE}}'
                ]
            ]
        );
        $iconbox->add_control(
            'hover_icon_color',
            [
                'label' => esc_html__('رنگ هاور آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.item:hover .icon i' => 'color: {{VALUE}}'
                ]
            ]
        );


        $iconbox->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.item .content h6, {{WRAPPER}} {{CURRENT_ITEM}}.item .content h6 a' => 'color: {{VALUE}} ;',
                ],
            ]
        );
        $iconbox->add_control(
            'subtitle_color',
            [
                'label' => esc_html__('رنگ زیر عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.item  .content p' => 'color: {{VALUE}} ;',
                ],
            ]
        );

        $iconbox->add_control(
            'hover_title_color',
            [
                'label' => esc_html__('رنگ هاور عناوین', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.item:hover .content h6, {{WRAPPER}} {{CURRENT_ITEM}}.item:hover .content h6 a, {{WRAPPER}} {{CURRENT_ITEM}}.item:hover .content p' => 'color: {{VALUE}} ;',
                ],
            ]
        );


        $iconbox->add_control(
            'item_border_head',
            [
                'label' => esc_html__( 'مرز آیتم', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $iconbox->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}.item',
            ]
        );

        $iconbox->add_control(
            'hover_border_color',
            [
                'label' => esc_html__('رنگ هاور مرز آیتم', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.item:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $iconbox->add_control(
            'item_bor_line_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $iconbox->add_control(
            'icon_border_head',
            [
                'label' => esc_html__( 'مرز آیکن', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $iconbox->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'icon_border',
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}.item .icon',
            ]
        );
        $iconbox->add_control(
            'hover_icon_border',
            [
                'label' => esc_html__('رنگ هاور مرز آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.item:hover .icon' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $iconbox->add_control(
            'icon_bor_line_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );



        $this->add_control(
            'icons',
            [
                'label' => esc_html__('آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $iconbox->get_controls(),           /* Use our repeater */
                'default' => [

                    'title' => esc_html__('عنوان', 'dejavo'),
                    'subtitle' => esc_html__('زیر عنوان', 'dejavo'),
                    'icon'  => [
                        'value' => 'dej-alarm-clock',
                    ],
                    'link' => [
                        'url' => '',
                        'is_external' => true,
                        'nofollow' => true,
                        'custom_attributes' => '',
                    ],

                ],
                'title_field' => '{{{ title }}}',
            ]
        );


        $this->end_controls_section();
        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'style',
            [
                'label' => esc_html__('سبک نمایش', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('یک', 'dejavo'),
                    '2' => esc_html__('دو', 'dejavo'),
                    '3' => esc_html__('سه', 'dejavo'),
                    '4' => esc_html__('چهار', 'dejavo'),
                ],
            ]
        );


        $this->add_responsive_control(
            'gap',
            [
                'label' => esc_html__('فاصله بین آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .icon_box' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'desktop_cols',
            [
                'label' => esc_html__('تعداد ستون', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 12,
                'step' => 1,
                'default' => 8,
            ]
        );
        $this->add_control(
            'laptop_cols',
            [
                'label' => esc_html__('تعداد ستون لپ تاپ کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 8,
                'step' => 1,
                'default' => 6,
            ]
        );
        $this->add_control(
            'tablet_cols',
            [
                'label' => esc_html__('تعداد ستون تبلت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 6,
                'step' => 1,
                'default' => 3,
            ]
        );
        $this->add_control(
            'mobile_cols',
            [
                'label' => esc_html__('تعداد ستون موبایل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 4,
                'step' => 1,
                'default' => 3,
            ]
        );
        $this->add_control(
            'hover_animation',
            [
                'label' => esc_html__( 'انیمیش هاور آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::ANIMATION,
            ]
        );
        $this->add_control(
            'anim_duration',
            [
                'label' => esc_html__('مدت انیمیشن (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 4000,
                'step' => 100,
                'default' => 1200,
                'selectors' => [
                    '{{WRAPPER}} .icon_box .item .icon' => 'animation-duration: {{SIZE}}ms !important; transition-duration: {{SIZE}}ms !important;',
                ],
            ]
        );


        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .icon_box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('فاصله آیتم ها از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .icon_box .item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_padding',
            [
                'label' => esc_html__('فاصله آیکن ها از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .icon_box .item .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .icon_box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .icon_box .item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_border_radius',
            [
                'label' => esc_html__('کادر آیکن ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .icon_box .item .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'be_head1',
            [
                'label' => esc_html__( 'مرز ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .icon_box',
            ]
        );

        $this->add_control(
            'af_head1',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'be_head2',
            [
                'label' => esc_html__( 'مرز آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border2',
                'selector' => '{{WRAPPER}} .icon_box .item',
            ]
        );
        $this->add_control(
            'hover_item_bor',
            [
                'label' => esc_html__('رنگ هاور مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .icon_box .item:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'af_head2',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .icon_box',
            ]
        );




        $this->add_responsive_control(
            'h6_font_size',
            [
                'label' => esc_html__('سایز فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .item .content h6' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'p_font_size',
            [
                'label' => esc_html__('سایز فونت زیر عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 12,
                ],
                'selectors' => [
                    '{{WRAPPER}} .item .content p' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('سایز فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 60,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 40,
                ],
                'selectors' => [
                    '{{WRAPPER}} .item .icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .icon_box > a, {{WRAPPER}} .icon_box .item',
            ]
        );

        $this->end_controls_section();

    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $style = $data['style'];
        $items = $data['icons'];
        $wid_id = $this->get_id_int();
        $cols = 'mob_col'. $data['mobile_cols'] . ' tab_col'. $data['tablet_cols'] . ' lap_col'. $data['laptop_cols'] . ' col'. $data['desktop_cols'];
        if ($items) { ?>
            <div class="icon_box <?= $wid_id . ' style' . $style . ' d_grid ' . $cols ?>">
            <?php foreach ($items as $item) {
                $link = $item['link']['url'];
                $icon = $item['icon']['value'];
                $before_url = $link ? '<a href="' . $link . '">'  : '';
                $after_url = $link ? '</a>' : '';  ?>
                <?= $before_url ?>
                <div class="elementor-repeater-item-<?= esc_attr($item['_id']) ?> item">
                    <?php if ($icon) { ?><div class="icon"><i class="<?= $icon ?>"></i></div><?php } ?>
                    <div class="content">
                        <?php if ($item['title']) { ?><h6><?= $item['title'] ?></h6>
                        <?php  } if ($item['subtitle']) { ?><p><?= $item['subtitle'] ?></p><?php } ?>
                    </div>
                </div>
                <?= $after_url ?>
            <?php  } ?>
        </div>
            <script>
                jQuery(document).ready(function($){
                    var icon_item = $('.icon_box.<?= $wid_id ?> .item');
                    icon_item.mouseover(function () { $(this).children('.icon').addClass('<?= $data['hover_animation'] ?>'); });
                    icon_item.mouseout(function () { $(this).children('.icon').removeClass('<?= $data['hover_animation'] ?>'); });
                });
            </script>
        <?php
        }

    }
}
