<?php
defined('ABSPATH') || exit;
class dej_Productlist_1 extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'dej_product_list_1';
    }

    public function get_title()
    {
        return esc_html__('لیست محصولات', 'dejavo');
    }

    public function get_icon()
    {
        return 'eicon-post-list';
    }

    public function get_categories()
    {
        return ['dejavo'];
    }


    protected function register_controls()
    {
        $product_cat = [];
        $cats = get_terms("product_cat");
        if (!is_wp_error($cats) && !empty($cats)) {
            foreach ($cats as $cat) {
                $product_cat[$cat->term_id] = $cat->name;
            }
        }
        $product_tag = [];
        $tags = get_terms("product_tag");
        if (!is_wp_error($tags) && !empty($tags)) {
            foreach ($tags as $tag) {
                $product_tag[$tag->term_id] = $tag->name;
            }
        }
        $this->start_controls_section(
            'content_section', [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان اصلی', 'dejavo'),
                'default' => esc_html__('محصولات جدید', 'dejavo'),
                'label_block' => true,
            ]
        );


        $this->add_control(
            'number',
            [
                'label' => esc_html__('تعداد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 2,
                'max' => 64,
                'step' => 4,
                'default' => 8,
            ]
        );
        $this->add_control(
            'order',
            [
                'label' => esc_html__('ترتیب', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC' => esc_html__('نزولی', 'dejavo'),
                    'ASC' => esc_html__('صعودی', 'dejavo'),
                ],
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('مرتب سازی', 'avina'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'rand' => esc_html__('تصادفی', 'avina'),
                    'date' => esc_html__('تاریخ', 'avina'),
                    'modified' => esc_html__('بروزرسانی', 'avina'),
                    'meta_value_num' => esc_html__('قیمت', 'avina'),
                    'popularity' => esc_html__('محبوبیت', 'avina'),
                ],
            ]
        );

        $this->add_control(
            'min_price',
            [
                'label' => esc_html__( 'کمترین قیمت', 'avina' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 1000,
            ]
        );
        $this->add_control(
            'max_price',
            [
                'label' => esc_html__( 'بیشترین قیمت *', 'avina' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1000,
                'step' => 1000,
            ]
        );
        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('فیلتر دسته بندی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'category',
            [
                'label' => esc_html__('دسته بندی ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'condition' => [
                    'show_cat' => 'yes',
                ],
                'options' => $product_cat,
                'multiple' => true,
            ]
        );
        $this->add_control(
            'show_tag',
            [
                'label' => esc_html__('فیلتر برچسب', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'tags',
            [
                'label' => esc_html__('برچسب ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'condition' => [
                    'show_tag' => 'yes',
                ],
                'options' => $product_tag,
                'multiple' => true,
            ]
        );


        $this->add_control(
            'show_special',
            [
                'label' => esc_html__('فقط نمایش تخفیف دار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'show_in_stock',
            [
                'label' => esc_html__('فقط نمایش موجود در انبار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'hide_empty_price',
            [
                'label' => esc_html__('مخفی کردن بدون قیمت و رایگان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('لینک دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );

        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('متن دکمه', 'dejavo'),
                'default' => esc_html__('مشاهده همه', 'dejavo'),
                'label_block' => true,

            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'img_zoom',
            [
                'label' => esc_html__('بزرگنمایی هاور تصویر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => true,
            ]
        );

        $this->add_control(
            'show_icons',
            [
                'label' => esc_html__('نمایش آیکن ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_rating',
            [
                'label' => esc_html__('نمایش امتیاز ستاره ای', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_price',
            [
                'label' => esc_html__('نمایش قیمت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_discount',
            [
                'label' => esc_html__('نمایش تخفیف', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'desktop_cols',
            [
                'label' => esc_html__( 'تعداد ستون', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7',
                    '8' => '8',
                ],
            ]
        );
        $this->add_control(
            'laptop_cols',
            [
                'label' => esc_html__( 'تعداد ستون لپ تاپ', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '3',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                    '7' => '7',
                ],
            ]
        );

        $this->add_control(
            'tablet_cols',
            [
                'label' => esc_html__( 'تعداد ستون تبلت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '2',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                ],
            ]
        );

        $this->add_control(
            'mobile_cols',
            [
                'label' => esc_html__( 'تعداد ستون موبایل', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                ],
            ]
        );
        $this->add_control(
            'item_space',
            [
                'label' => esc_html__('فاصله بین آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 5,
                'max' => 50,
                'step' => 1,
                'default' => 10,
                'selectors' => [
                    '{{WRAPPER}} .d_grid' => 'gap: {{SIZE}}px',
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_list_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'head-padding',
            [
                'label' => esc_html__('فاصله خارجی عنوان و دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title-padding',
            [
                'label' => esc_html__('فاصله درونی عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_list_1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_border_radius',
            [
                'label' => esc_html__('کادر گوشه عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title, {{WRAPPER}} .dej_heading_1 .title .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'more_border_radius',
            [
                'label' => esc_html__('کادر گوشه موارد بیشتر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more_link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'img_border_radius',
            [
                'label' => esc_html__('کادر تصویر آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item .image a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'badge_border_radius',
            [
                'label' => esc_html__('کادر تخفیف', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item .badge' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__('مرز ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .product_list_1',
            ]
        );

        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'item_bor_opt_be',
            [
                'label' => esc_html__('مرز آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .product_list_1 .item',
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'item_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'img_bor_opt_be',
            [
                'label' => esc_html__('مرز تصویر آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'img_border',
                'selector' => '{{WRAPPER}} .product_list_1 .item .image a',
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'img_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'title_bor_opt_be',
            [
                'label' => esc_html__('مرز عنوان ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'title_border',
                'selector' => '{{WRAPPER}} .dej_heading_1 .title',
            ]
        );

        $this->add_control(
            'title_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'more_bor_opt_be',
            [
                'label' => esc_html__('مرز دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'more_border',
                'selector' => '{{WRAPPER}} .product_list_1 .more_link',
            ]
        );

        $this->add_control(
            'more_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .product_list_1',
            ]
        );



        $this->add_control(
            'item_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_item_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'hover_item_bor',
            [
                'label' => esc_html__('رنگ هاور مرز آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_img_item_bor',
            [
                'label' => esc_html__('رنگ هاور مرز تصویر آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item:hover .image a' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_item_color',
            [
                'label' => esc_html__('رنگ عنوان آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item .title a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_title_item_color',
            [
                'label' => esc_html__('رنگ هاور عنوان آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_list_1 .item:hover .title a' => 'color: {{VALUE}}',
                ],
            ]
        );



        $this->add_control(
            'head_options',
            [
                'label' => esc_html__('نوار عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_control(
            'title_icon',
            [
                'label' => esc_html__('آیکن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-crown',
                    'library' => '',
                ],
            ]
        );
        $this->add_control(
            'more_icon',
            [
                'label' => esc_html__('آیکن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-arrow-left',
                    'library' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('سایز فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'h3_font_size',
            [
                'label' => esc_html__('سایز فونت عنوان ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'h3_line_height',
            [
                'label' => esc_html__('ارتفاع متن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'h3_font_weight',
            [
                'label' => esc_html__('وزن فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 300,
                        'max' => 900,
                        'step' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 500,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'font-weight: {{SIZE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'more_font_size',
            [
                'label' => esc_html__('سایز فونت متن موارد بیشتر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more_link' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_bg',
            [
                'label' => esc_html__('رنگ پس زمینه عنوان ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن عنوان ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title .icon' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'more_color',
            [
                'label' => esc_html__('رنگ متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more_link' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'more_hover_color',
            [
                'label' => esc_html__('رنگ هاور متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more_link:hover' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'more_bg',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more_link' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_more_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more_link:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_more_bor',
            [
                'label' => esc_html__('رنگ هاور مرز دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more_link:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .product_list_1',
            ]
        );
        $this->end_controls_section();


    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $title = $data['title'];
        $btn_url = $data['btn_link']['url'];
        $cols = 'mob_col'. $data['mobile_cols'] . ' tab_col'. $data['tablet_cols'] . ' lap_col'. $data['laptop_cols'] . ' col'. $data['desktop_cols'];
        $title_icon = $data['title_icon']['value'] ?? '';
        $more_icon = $data['more_icon']['value'] ?? '';
        $img_zoom = $data['img_zoom'] ? 'img_zoom' : '';
        $show_icons = $data['show_icons'];
        $show_rating = $data['show_rating'];
        $show_price = $data['show_price'];
        $show_discount = $data['show_discount'];


        $number = $data['number'] ?? 12;
        $order = $data['order'] ?? 'DESC';
        $orderby = $data['orderby'] ?? 'date';
        $cats = $data['category'] ?? '';
        $tags = $data['tags'] ?? '';

        $in_stock = $data['show_in_stock'] ?? '';
        $on_sale = $data['show_special'] ?? '';
        $hide_empty_price = $data['hide_empty_price'] ?? '';
        $empty_price_arr = $zero_price_arr = $in_stock_arr = $backorders_arr = $min_max = [];
        $meta_key = ($orderby == 'meta_value_num') ? '_price' : '';
        $max_price = $data['max_price'] ?? '';
        $min_price = $data['min_price'] ?? 0;

        $args = [ 'post_type' => 'product', 'post_status' => 'publish', 'posts_per_page' => $number, 'order' => $order, 'orderby' => $orderby, 'meta_key'  => $meta_key];

        if ($data['show_cat'] == 'yes' && !empty($cats)) {
            $args['tax_query'] = [['taxonomy' => 'product_cat', 'field' => 'term_id', 'terms' => $cats]];
        }

        elseif ($data['show_tag'] == 'yes' && !empty($tags)) {
            $args['tax_query'] = [['taxonomy' => 'product_tag', 'field' => 'term_id', 'terms' => $tags]];
        }

        if ($on_sale == 'yes') {
            $args['post__in'] = array_merge( [ 0 ], wc_get_product_ids_on_sale());
        }
        if ($hide_empty_price == 'yes') {
            $empty_price_arr = ['key' => '_price', 'value' => '', 'type' => 'numeric', 'compare' => '!='];
            $zero_price_arr = ['key' => '_price', 'value' => 0, 'type' => 'numeric', 'compare' => '!='];
        }
        if ($max_price) {
            $min_max = ['key' => '_price', 'value' => [$min_price, $max_price], 'compare' => 'BETWEEN', 'type' => 'NUMERIC'];
        }
        if ($in_stock == 'yes') {
            $in_stock_arr = ['key' => '_stock_status', 'value' => 'instock'];
            $backorders_arr = ['key' => '_backorders', 'value' => 'no'];
        }
        $args['meta_query'] = [$empty_price_arr,$zero_price_arr,$in_stock_arr,$backorders_arr, $min_max];
        $loop = new WP_Query($args);

            ?>

            <div class="product_list_1">

                <?php if ($title) { ?>
                    <div class="dej_heading_1">
                        <div class="title">
                            <?php if ($title_icon) { ?>
                                <div class="icon"><i class="<?= $title_icon ?>"></i></div><?php } ?>
                            <h3><?= $title ?></h3>
                        </div>

                        <?php if (!empty($btn_url)) { ?>
                            <a class="more_link"
                               href="<?= $btn_url ?>"><?= $data['btn_title'] ?> <?php if ($more_icon) { ?><i
                                    class="<?= $more_icon ?>"></i><?php } ?></a>
                        <?php } ?>
                    </div>
                <?php } ?>

                <div class="d_grid <?= $cols ?>">
                    <?php if ($loop->have_posts()) {
                        while ($loop->have_posts()) {
                            $loop->the_post();
                            global $product;
                            $product_title = $product->get_title(); $product_id = $product->get_id(); ?>
                            <div class="item <?= $img_zoom ?>">
                                <?php if ($show_discount and $product->is_on_sale()) {
                                    woocommerce_show_product_sale_flash();
                                } ?>
                                <div class="image">
                                    <a href="<?php the_permalink(); ?>"><?= $product->get_image('woocommerce_gallery_thumbnail') ?></a>
                                </div>
                                <div class="info">
                                    <div class="title">
                                        <h4>
                                            <a href="<?php the_permalink(); ?>"><?= wp_trim_words($product_title, 14, '..') ?></a>
                                        </h4>
                                    </div>
                                    <?php if ($show_rating) { dejavo_star_rating(); } ?>
                                    <?php if ($show_price) { ?>
                                        <div class="price <?php if ($show_icons) { echo ' show_icons';} ?>"><?php woocommerce_template_loop_price(); ?></div><?php } ?>
                                    <?php if ($show_icons) { ?>
                                        <ul class="icons">
                                        <?php echo sprintf('<li class="hint--top-left" aria-label="%s"><a href="%s" data-quantity="1" class="%s" %s><i class="dej-shopping-bag"></i></a></li>',
                                            esc_html($product->add_to_cart_text()),
                                            esc_url($product->add_to_cart_url()),
                                            esc_attr(implode(' ', array_filter(array(
                                                '', 'product_type_' . $product->get_type(),
                                                $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                                                $product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart' : '',
                                            )))),
                                            wc_implode_html_attributes(array(
                                                'data-product_id' => $product_id,
                                                'data-product_sku' => $product->get_sku(),
                                                'aria-label' => $product->add_to_cart_description(),
                                                'rel' => 'nofollow',
                                            ))
                                        ); ?>
                                        <?php if (class_exists('DejavoWL')) { ?><li class="hint--top" aria-label="<?php _e('علاقه مندی', 'dejavo') ?>"><?= DejavoWL::wl_btn($product_id) ?></li>
                                        <?php } if (class_exists('DejavoCP')) { ?><li class="hint--top" aria-label="<?php _e('مقایسه', 'dejavo') ?>"><?= DejavoCP::cp_btn($product_id) ?></li>
                                        <?php } if (class_exists('DejavoQV')) { ?><li class="hint--top-right" aria-label="<?php _e('نمایش سریع', 'dejavo') ?>"><?= DejavoQV::qv_btn($product_id) ?></li><?php } ?>

                                        </ul><?php } ?>
                                </div>

                            </div>
                        <?php }
                    }
                    wp_reset_postdata(); ?>

                </div>
            </div>
            <?php
    }

}
