<?php
defined('ABSPATH') || exit;

class dej_ProductTab extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'dej_product_tab';
    }

    public function get_title()
    {
        return esc_html__('تب محصولات', 'dejavo');
    }


    public function get_icon()
    {
        return 'dej-exchange';
    }


    public function get_categories()
    {
        return ['dejavo'];
    }


    public function get_keywords()
    {
        return ['محصولات', 'تب'];
    }
    public function get_script_depends() {
        return ['swiper' ];
    }
    protected function register_controls()
    {
        $product_cat = [];
        $cats = get_terms("product_cat");
        if (!is_wp_error($cats) && !empty($cats)) {
            foreach ($cats as $cat) {
                $product_cat[$cat->term_id] = $cat->name;
            }
        }

        $product_tag = [];
        $tags = get_terms("product_tag");
        if (!is_wp_error($tags) && !empty($tags)) {
            foreach ($tags as $tag) {
                $product_tag[$tag->term_id] = $tag->name;
            }
        }

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان اصلی', 'dejavo'),
                'default' => esc_html__('اسلایدر محصولات', 'dejavo'),
                'label_block' => true,
            ]
        );


        $tabs = new \Elementor\Repeater();


        $tabs->add_control(
            'cat',
            [
                'label' => esc_html__('دسته', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $product_cat,
                'multiple' => false,
            ]
        );


        $tabs->add_control(
            'icon',
            [
                'label' => esc_html__('آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
            ]
        );


        $this->add_control(
            'tabs',
            [
                'label' => esc_html__('تب ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $tabs->get_controls(), 
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => esc_html__('تعداد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 64,
                'step' => 1,
                'default' => 12,
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__('مرتب سازی بر اساس', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC' => esc_html__('نزولی', 'dejavo'),
                    'ASC' => esc_html__('صعودی', 'dejavo'),
                ],
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('مرتب سازی', 'avina'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'rand' => esc_html__('تصادفی', 'avina'),
                    'date' => esc_html__('تاریخ', 'avina'),
                    'modified' => esc_html__('بروزرسانی', 'avina'),
                    'meta_value_num' => esc_html__('قیمت', 'avina'),
                    'popularity' => esc_html__('محبوبیت', 'avina'),
                ],
            ]
        );

        $this->add_control(
            'min_price',
            [
                'label' => esc_html__( 'کمترین قیمت', 'avina' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 1000,
            ]
        );
        $this->add_control(
            'max_price',
            [
                'label' => esc_html__( 'بیشترین قیمت *', 'avina' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1000,
                'step' => 1000,
            ]
        );
        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__( 'فیلتر دسته بندی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'category',
            [
                'label' => esc_html__('دسته بندی ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'condition' => [
                    'show_cat' => 'yes',
                ],
                'options' => $product_cat,
                'multiple' => true,
            ]
        );
        $this->add_control(
            'show_tag',
            [
                'label' => esc_html__( 'فیلتر برچسب', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'tags',
            [
                'label' => esc_html__('برچسب ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'condition' => [
                    'show_tag' => 'yes',
                ],
                'options' => $product_tag,
                'multiple' => true,
            ]
        );

        $this->add_control(
            'show_special',
            [
                'label' => esc_html__('فقط نمایش تخفیف دار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'show_in_stock',
            [
                'label' => esc_html__('فقط نمایش موجود در انبار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'hide_empty_price',
            [
                'label' => esc_html__('مخفی کردن بدون قیمت و رایگان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__('لینک دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
            ]
        );

        $this->add_control(
            'btn_title',
            [
                'label' => esc_html__('متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('متن دکمه', 'dejavo'),
                'default' => esc_html__('مشاهده همه', 'dejavo'),
                'label_block' => true,

            ]
        );



        $this->end_controls_section();


        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'product_card',
            [
                'label' => esc_html__('کارد محصول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('یک', 'dejavo'),
                    '2' => esc_html__('دو', 'dejavo'),
                    '3' => esc_html__('سه', 'dejavo'),
                    '4' => esc_html__('چهار', 'dejavo'),
                ],
            ]
        );

        $this->add_control(
            'mob_card',
            [
                'label' => esc_html__( 'نمایش کارد ویژه موبایل ؟', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'mob_scroll',
            [
                'label' => esc_html__( 'حالت اسکرول افقی در موبایل ؟', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'hide_scrollbar',
            [
                'label' => esc_html__( 'مخفی کردن اسکرول بار در موبایل ؟', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'mob_scroll' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'desktop_cols',
            [
                'label' => esc_html__('تعداد ستون', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 6,
                'step' => 1,
                'default' => 5,
            ]
        );
        $this->add_control(
            'laptop_cols',
            [
                'label' => esc_html__('تعداد ستون لپ تاپ کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 3,
            ]
        );
        $this->add_control(
            'tablet_cols',
            [
                'label' => esc_html__('تعداد ستون تبلت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 3,
                'step' => 1,
                'default' => 2,
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'mob_scroll',
                            'operator' => '!==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'mobile_cols',
            [
                'label' => esc_html__('تعداد ستون موبایل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 2.5,
                'step' => 0.1,
                'default' => 2,
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'mob_scroll',
                            'operator' => '!==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );
        $this->add_control(
            'number-in-scroll',
            [
                'label' => esc_html__('تعداد در هر اسکرول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 6,
                'step' => 1,
                'default' => 1,
            ]
        );

        $this->add_control(
            'scroll-time',
            [
                'label' => esc_html__('زمان تاخیر اسکرول خودکار (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 3000,
                'max' => 12000,
                'step' => 200,
                'default' => 6000,
            ]
        );
        $this->add_control(
            'scroll-speed',
            [
                'label' => esc_html__('سرعت اسکرول (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 300,
                'max' => 1600,
                'step' => 100,
                'default' => 500,
            ]
        );
        $this->add_control(
            'free-mode',
            [
                'label' => esc_html__('اسکرول آزاد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('نمایش فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_dots',
            [
                'label' => esc_html__('نمایش نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('چرخش خودکار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 50,
                'step' => 1,
                'default' => 4,
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'head-padding',
            [
                'label' => esc_html__('فاصله خارجی عنوان و دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title-padding',
            [
                'label' => esc_html__('فاصله درونی عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر گوشه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر گوشه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_slider_1 .product-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_border_radius',
            [
                'label' => esc_html__('کادر گوشه عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title, {{WRAPPER}} .dej_heading_1 .title .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'more_border_radius',
            [
                'label' => esc_html__('کادر گوشه موارد بیشتر و فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more, {{WRAPPER}} .dej_heading_1 .arrows' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__( 'مرز ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .product_slider_1',
            ]
        );

        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'item_bor_opt_be',
            [
                'label' => esc_html__( 'مرز آیتم ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .product_slider_1 .product-card',
            ]
        );

        $this->add_control(
            'hover_item_border',
            [
                'label' => esc_html__('رنگ هاور مرز آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_slider_1 .product-card:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .product_slider_1',
            ]
        );


        $this->add_control(
            'bg_item',
            [
                'label' => esc_html__('رنگ پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_slider_1 .product-card .main-bg, {{WRAPPER}} .product_slider_1 .product-card' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_bg_item',
            [
                'label' => esc_html__('رنگ هاور پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_slider_1 .product-card:hover .main-bg, {{WRAPPER}} .product_slider_1 .product-card:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'img_height',
            [
                'label' => esc_html__('تعیین ارتفاع تصاویر', 'avina'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 150,
                        'max' => 450,
                        'step' => 10,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-card .image' => 'height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );


        $this->add_control(
            'head_options',
            [
                'label' => esc_html__( 'نوار عنوان', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'next_icon',
            [
                'label' => esc_html__('آیکن بعدی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-right',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'prev_icon',
            [
                'label' => esc_html__('آیکن قبلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-left',
                    'library' => '',
                ],
            ]
        );


        $this->add_control(
            'title_icon',
            [
                'label' => esc_html__('آیکن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-crown',
                    'library' => '',
                ],
            ]
        );



        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_bg',
            [
                'label' => esc_html__('رنگ پس زمینه عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title .icon' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'more_color',
            [
                'label' => esc_html__('رنگ متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'more_hover_color',
            [
                'label' => esc_html__('رنگ هاور متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more:hover' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'more_bg',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_more_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'arrows_color',
            [
                'label' => esc_html__('رنگ فلشها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrows_bg',
            [
                'label' => esc_html__('رنگ پس زمینه فلشها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'bullet_bg',
            [
                'label' => esc_html__('رنگ نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_slider_1 .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__( 'سایز فونت آیکن ', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'h3_font_size',
            [
                'label' => esc_html__( 'سایز فونت عنوان ', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'h3_line_height',
            [
                'label' => esc_html__( 'ارتفاع متن عنوان', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'h3_font_weight',
            [
                'label' => esc_html__( 'وزن فونت عنوان', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' =>  ['px', 'em'],
                'range' => [
                    'px' =>[
                        'min' => 300,
                        'max' => 900,
                        'step' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 500,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'font-weight: {{SIZE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'more_font_size',
            [
                'label' => esc_html__('سایز فونت متن موارد بیشتر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrows_font_size',
            [
                'label' => esc_html__('سایز فونت فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .product_slider_1',
            ]
        );


        $this->end_controls_section();

    }
    function dej_get_tab_data (){
        global $wp_query;
        $method = $wp_query->get('dej_ajax');
        if (!$method) {
            return;
        }

        if ($method == 'tabs_data') {
            $cat_id = sanitize_text_field($_POST['cat_id']);
            if (!empty($cat_id)) {
                $query['tax_query'] = [['taxonomy' => 'product_cat', 'field' => 'term_id', 'terms' => $cat_id]];
            }
        }

        exit();
    }
    function dej_product_tab ($query, $widget_data, $wrapper, $wrapper_attr){

        $tabs = $widget_data['tabs'] ?? '';
        $title = $widget_data['title'] ?? '';
        $title_icon = $widget_data['title_icon'] ?? '';
        $next_icon = $widget_data['next_icon'] ?? '';
        $prev_icon = $widget_data['title_icon'] ?? '';
        $w_id = $widget_data['id'];
        $btn_title = $widget_data['btn_title'];
        $card = $widget_data['card'];
        $dots = $widget_data['dots'];
        $arrow = $widget_data['arrow'];

        $loop = new WP_Query($query);
        ?>
        <div class="dej_tabs_btn">
            <?php
            foreach ($tabs as $tab) {
                $term = get_term_by( 'id', $tab['cat'], 'product_cat', 'ARRAY_A' ); ?>

                <button class="dej_tab_btn dejavo_outline_btn" data-cat-id="<?= $tab['cat'] ?>"><?= $term['name'] ?></button>
                <?php
            }
            ?>
        </div>

        <div class="product_tabs">
            <?php if ($title) { ?>
                <div class="dej_heading_1">
                    <div class="title">
                        <?php if ($title_icon) { ?><div class="icon"><i class="<?= $title_icon ?>"></i></div><?php } ?>
                        <h3><?= $title ?></h3>
                    </div>

                    <div class="arrow_more">
                        <?php  if (!empty($btn_url)){ ?>
                            <a class="more <?php if($wrapper === 'mobile-opt') { echo 'mob_type';} ?>" href="<?= $btn_url ?>"><?= $btn_title ?></a>
                        <?php }
                        if ($arrow === 'yes' and  $wrapper === 'swiper-opt') { ?>
                            <div class="arrows"><div class="dejavo_next_Arrow id<?= $w_id ?>"><i class="<?= $next_icon ?>"></i></div><div class="dejavo_prev_Arrow id<?= $w_id ?>"><i class="<?= $prev_icon ?>"></i></div></div>
                        <?php }  ?>
                    </div>
                </div>
            <?php } ?>

            <div class="slides">
                <div <?= $wrapper_attr ?> >
                    <div class="products_slider swiper-wrapper">
                        <?php while ($loop->have_posts()){ $loop->the_post(); ?>
                            <div class="item swiper-slide">
                                <?php if($wrapper === 'mobile-opt'){
                                    get_template_part('template/product/mob-card',  $card );
                                } else {
                                    get_template_part('template/product/card',  $card );
                                } ?>
                            </div>
                        <?php } wp_reset_postdata(); wp_reset_query(); ?>
                    </div>
                </div>
                <?php if ($dots == 'yes' and $wrapper === 'swiper-opt') { ?><div class="swiper-pagination sp<?= $w_id ?>"></div><?php }  ?>
            </div>
            <script> dej_initSwipers(); </script>
        </div>
        <?php
    }
    protected function render()
    {
        $data = $this->get_settings_for_display();
        $tabs = $data['tabs'];
        $product_card = $data['product_card'] ?? 1;
        $title = $data['title'];
        $btn_url = $data['btn_link']['url'] ?? '#';
        $btn_title = $data['btn_title'] ?? '';
        $title_icon = $data['title_icon']['value'] ?? '';
        $next_icon = $data['next_icon']['value'] ?? '';
        $prev_icon = $data['prev_icon']['value'] ?? '';
        $space_between = $data['space_between'] ?? 4;
        $show_arrow = $data['show_arrow'] ?? 'yes';
        $show_dots = $data['show_dots'] ?? 'yes';
        $wid_id = $this->get_id_int();

        $wid_data = [ 'id'=> $wid_id, 'tabs' => $tabs, 'card'=> $product_card, 'title' => $title, 'btn_url' => $btn_url, 'btn_title' => $btn_title, 'title_icon' => $title_icon, 'next_icon' => $next_icon, 'prev_icon'=> $prev_icon, 'dots' => $show_dots, 'arrow' => $show_arrow];



        $data_swiper = ['spaceBetween' => $space_between, 'watchSlidesProgress' => true ];
        if ($data['free-mode'] == 'yes') { $data_swiper['freeMode'] = true; }
        if ($data['autoplay'] == 'yes') {$data_swiper['autoplay'] = ['delay' => $data['scroll-time'], 'disableOnInteraction' => false, 'pauseOnMouseEnter' => true];}
        if ($data['show_arrow'] == 'yes') {$data_swiper['navigation'] = ['nextEl' => ".dejavo_next_Arrow.id{$wid_id}", 'prevEl' => ".dejavo_prev_Arrow.id{$wid_id}"];}
        if ($data['show_dots'] == 'yes') {$data_swiper['pagination'] = ['el' => ".swiper-pagination.sp{$wid_id}", 'clickable' => true];}
        $data_swiper['breakpoints'] = ['0' => ['slidesPerView' => $data['mobile_cols'] ,'speed' => 300,'slidesPerGroup' => 1], '576' => ['slidesPerView' => $data['tablet_cols'] ], '768' => ['slidesPerView' => $data['laptop_cols'], 'speed' => $data['scroll-speed']], '992' => ['slidesPerView' => $data['desktop_cols'], 'speed' =>  $data['scroll-speed'], 'slidesPerGroup' => $data['number-in-scroll'] ]];


        $dir = is_rtl() ? 'rtl' : '';

        $this->add_render_attribute( [
            'swiper-opt' => [
                'class' => 'dej_swiper swiper',
                'id' => 'DejavoSwiper' . $wid_id,
                'dir' => $dir,
                'data-swiper' => wp_json_encode($data_swiper)
            ],
        ] );

        $hide_scrollbar = '';
        if ($data['hide_scrollbar'] == 'yes') {
            $hide_scrollbar = ' scrollbar-hidden';
        }
        $this->add_render_attribute( [
            'mobile-opt' => [
                'class' => 'mob_wrapper' . $hide_scrollbar,
            ],
        ] );


        if (wp_is_mobile() and $data['mob_scroll']) {
            $wrapper_class = 'mobile-opt';
        } else {
            $wrapper_class = 'swiper-opt';
        }

        $wrapper_attr = $this->get_render_attribute_string( $wrapper_class );









        $number = $data['number'] ?? 12;
        $order = $data['order'] ?? 'DESC';
        $orderby = $data['orderby'] ?? 'date';
        $cats = $data['category'] ?? '';
        $tags = $data['tags'] ?? '';

        $in_stock = $data['show_in_stock'] ?? '';
        $on_sale = $data['show_special'] ?? '';
        $hide_empty_price = $data['hide_empty_price'] ?? '';
        $empty_price_arr = $zero_price_arr = $in_stock_arr = $backorders_arr = $min_max = [];
        $meta_key = ($orderby == 'meta_value_num') ? '_price' : '';
        $max_price = $data['max_price'] ?? '';
        $min_price = $data['min_price'] ?? 0;



        $args = [ 'post_type' => 'product', 'post_status' => 'publish', 'posts_per_page' => $number, 'order' => $order, 'orderby' => $orderby, 'meta_key'  => $meta_key];

        if ($data['show_cat'] == 'yes' && !empty($cats)) {
            $args['tax_query'] = [['taxonomy' => 'product_cat', 'field' => 'term_id', 'terms' => $cats]];
        }

        elseif ($data['show_tag'] == 'yes' && !empty($tags)) {
            $args['tax_query'] = [['taxonomy' => 'product_tag', 'field' => 'term_id', 'terms' => $tags]];
        }

        if ($on_sale == 'yes') {
            $args['post__in'] = array_merge( [ 0 ], wc_get_product_ids_on_sale());
        }
        if ($hide_empty_price == 'yes') {
            $empty_price_arr = ['key' => '_price', 'value' => '', 'type' => 'numeric', 'compare' => '!='];
            $zero_price_arr = ['key' => '_price', 'value' => 0, 'type' => 'numeric', 'compare' => '!='];
        }
        if ($max_price) {
            $min_max = ['key' => '_price', 'value' => [$min_price, $max_price], 'compare' => 'BETWEEN', 'type' => 'NUMERIC'];
        }
        if ($in_stock == 'yes') {
            $in_stock_arr = ['key' => '_stock_status', 'value' => 'instock'];
            $backorders_arr = ['key' => '_backorders', 'value' => 'no'];
        }
        $args['meta_query'] = [$empty_price_arr,$zero_price_arr,$in_stock_arr,$backorders_arr, $min_max];



        dej_product_tab($args, $wid_data,  $wrapper_class, $wrapper_attr);



    }

    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);

        add_action('template_redirect',   [$this,'dej_get_tab_data']);


    }


}
