<?php
defined('ABSPATH') || exit;

class dej_PostMeta extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_post_meta';
    }

    public function get_title()
    {
        return esc_html__('متا پست', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-database';
    }

    public function get_categories()
    {
        return ['dejavo-post'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );



        $this->add_responsive_control(
            'flex_dir',
            [
                'label' => esc_html__( 'جهت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'column' => [
                        'title' => esc_html__( 'عمودی', 'dejavo' ),
                        'icon' => 'dej-arrows-alt-v',
                    ],
                    'row' => [
                        'title' => esc_html__( 'افقی', 'dejavo' ),
                        'icon' => 'dej-arrows-alt-h',
                    ],
                ],
                'default' => 'row',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .post_meta' => 'flex-direction: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'show_cat',
            [
                'label' => esc_html__('نمایش دسته', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_view',
            [
                'label' => esc_html__('نمایش بازدید', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_author',
            [
                'label' => esc_html__('نمایش نویسنده', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('نمایش تاریخ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_comment',
            [
                'label' => esc_html__('نمایش نظرات', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .post_meta',
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post_meta li i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => esc_html__('رنگ متن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post_meta li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'a_color',
            [
                'label' => esc_html__('رنگ لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post_meta li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_a_color',
            [
                'label' => esc_html__('رنگ هاور لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post_meta li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__( 'مرز', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .post_meta',
            ]
        );


        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .post_meta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .post_meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_font_size',
            [
                'label' => esc_html__('اندازه فونت متن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 13,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post_meta li, {{WRAPPER}} .post_meta li a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('اندازه فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 13,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post_meta li i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .post_meta',
            ]
        );


        $this->end_controls_section();

    }

    protected function render()
    {
        $data = $this->get_settings_for_display();

        if (is_single()) {
            $post_id = get_the_ID();
            setPostViews($post_id);
            $categories = get_categories($post_id) ?? '';
            $author =   get_the_author_meta('display_name') ?? '';
            $author_url =  get_author_posts_url(get_the_author_meta('ID')) ?? '';
            ?>
            <ul class="post_meta">
            <?php if ($data['show_date']) { ?><li><i class="dej-calendar"></i><span><?= esc_html__('در: ', 'dejavo') . get_the_date() ?></span></li>
            <?php } if ($data['show_author']) { ?><li><i class="dej-edit"></i><span><?= esc_html__('توسط: ', 'dejavo') ?><a href="<?= $author_url ?>"><?= $author ?></a></span></li>
            <?php } if ($data['show_view']) { ?><li><i class="dej-eye"></i><span><?= getPostViews($post_id) ?></span></li>
            <?php } if ($data['show_comment']) { ?><li><i class="dej-comment"></i><a href="#comments"><span><?= show_comments_count($post_id) ?></span></a></li>
            <?php } if ($data['show_cat']) { ?><li><i class="dej-list"></i><span>
                <?php
                if (count($categories) > 1) {
                    echo esc_html__('دسته ها: ', 'dejavo');
                } else {
                    echo esc_html__('دسته: ', 'dejavo');
                }

                $co = 1;   foreach($categories as $cat){
                    $cat_name = $cat->name;
                    echo $cat_name;
                    if (count($categories) > 1 and $co < count($categories)) {
                        echo ', ';
                    }
                    $co++;
                }

                ?>
                    </span></li> <?php } ?>
            </ul>
           <?php

        }
    }
}
