<?php
defined('ABSPATH') || exit;

class dej_PostRelated extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'dej_post_related';
    }

    public function get_title()
    {
        return esc_html__('مطالب مرتیط', 'dejavo');
    }


    public function get_icon()
    {
        return 'eicon-posts-carousel';
    }


    public function get_categories()
    {
        return ['dejavo-post'];
    }



    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('مطالب مرتبط', 'dejavo'),
                'default' => esc_html__('مطالب مرتبط', 'dejavo'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'number',
            [
                'label' => esc_html__('تعداد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 18,
                'step' => 1,
                'default' => 10,
            ]
        );
        $this->add_control(
            'order',
            [
                'label' => esc_html__('مرتب سازی بر اساس', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC' => esc_html__('نزولی', 'dejavo'),
                    'ASC' => esc_html__('صعودی', 'dejavo'),
                ],
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('مرتب سازی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'rand' => esc_html__('تصادفی', 'dejavo'),
                    'date' => esc_html__('تاریخ', 'dejavo'),
                    'modified' => esc_html__('بروزرسانی', 'dejavo'),
                ],
            ]
        );



        $this->end_controls_section();


        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'card',
            [
                'label' => esc_html__('سبک نمایش', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('یک', 'dejavo'),
//                    '2' => esc_html__('دو', 'dejavo'),
//                    '3' => esc_html__('سه', 'dejavo'),
                ],
            ]
        );

        $this->add_control(
            'number-in-page',
            [
                'label' => esc_html__('تعداد قابل مشاهده', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 6,
                'step' => 1,
                'default' => 4,
            ]
        );
        $this->add_control(
            'number-in-page-laptop',
            [
                'label' => esc_html__('تعداد قابل مشاهده لپ تاپ کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 3,
            ]
        );
        $this->add_control(
            'number-in-page-tablet',
            [
                'label' => esc_html__('تعداد قابل مشاهده تبلت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 3,
                'step' => 1,
                'default' => 2,
            ]
        );
        $this->add_control(
            'number-in-page-mobile',
            [
                'label' => esc_html__('تعداد قابل مشاهده موبایل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 2.5,
                'step' => 0.1,
                'default' => 1.2,
            ]
        );
        $this->add_control(
            'number-in-scroll',
            [
                'label' => esc_html__('تعداد در هر اسکرول', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 6,
                'step' => 1,
                'default' => 1,
            ]
        );

        $this->add_control(
            'scroll-time',
            [
                'label' => esc_html__('زمان تاخیر اسکرول خودکار (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 3000,
                'max' => 12000,
                'step' => 200,
                'default' => 6000,
            ]
        );
        $this->add_control(
            'scroll-speed',
            [
                'label' => esc_html__('سرعت اسکرول (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 300,
                'max' => 1600,
                'step' => 100,
                'default' => 500,
            ]
        );
        $this->add_control(
            'free-mode',
            [
                'label' => esc_html__('اسکرول آزاد', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('نمایش فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_dots',
            [
                'label' => esc_html__('نمایش نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('چرخش خودکار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'space_between',
            [
                'label' => esc_html__('فاصله بین آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 50,
                'step' => 1,
                'default' => 8,
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .post_related' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر پس زمینه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .post_related' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .post_related .product-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'title_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title, {{WRAPPER}} .dej_heading_1 .title .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'more_border_radius',
            [
                'label' => esc_html__('کادر پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__('مرز ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .post_related',
            ]
        );

        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .post_related',
            ]
        );



        $this->add_control(
            'head_options',
            [
                'label' => esc_html__('نوار عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'next_icon',
            [
                'label' => esc_html__('آیکن بعدی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-right',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'prev_icon',
            [
                'label' => esc_html__('آیکن قبلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-left',
                    'library' => '',
                ],
            ]
        );


        $this->add_control(
            'title_icon',
            [
                'label' => esc_html__('آیکن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-minus',
                    'library' => '',
                ],
            ]
        );


        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_bg',
            [
                'label' => esc_html__('رنگ پس زمینه عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title .icon' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'arrows_color',
            [
                'label' => esc_html__('رنگ فلشها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows' => 'color:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrows_bg',
            [
                'label' => esc_html__('رنگ پس زمینه فلشها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'bullet_bg',
            [
                'label' => esc_html__('رنگ نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post_related .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('سایز فونت آیکن ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'h3_font_size',
            [
                'label' => esc_html__('سایز فونت عنوان ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'h3_line_height',
            [
                'label' => esc_html__('ارتفاع متن عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 13,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'h3_font_weight',
            [
                'label' => esc_html__('وزن فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 300,
                        'max' => 900,
                        'step' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 500,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .title h3' => 'font-weight: {{SIZE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'more_font_size',
            [
                'label' => esc_html__('سایز فونت متن موارد بیشتر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .more' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrows_font_size',
            [
                'label' => esc_html__('سایز فونت فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_heading_1 .arrows i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_section();

    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
       // $card = $data['card'];
        $title_icon = $data['title_icon']['value'] ?? '';
        $next_icon = $data['next_icon']['value'] ?? '';
        $prev_icon = $data['prev_icon']['value'] ?? '';
        $space_between = $data['space_between'] ?? 15;
        $title = $data['title'] ?? '';

        global $post;

        $args = array(
            'posts_per_page' => $data['number'],
            'post__not_in'   => array( get_the_ID() ),
            'no_found_rows'  => true,
        );

        $cats = wp_get_post_terms( get_the_ID(), 'category' );
        $cats_ids = array();
        foreach( $cats as $related_cat ) {
            $cats_ids[] = $related_cat->term_id;
        }
        if ( ! empty( $cats_ids ) ) {
            $args['category__in'] = $cats_ids;
        }
        $query = new wp_query( $args );

        if (is_single() ) {
            ?>
            <div class="post_related">
                <?php if ($title) { ?>
                    <div class="dej_heading_1">
                        <div class="title">
                            <?php if ($title_icon) { ?>
                                <div class="icon"><i class="<?= $title_icon ?>"></i></div><?php } ?>
                            <h3><?= $title ?></h3>
                        </div>

                        <div class="arrow_more">
                            <?php
                            if ($data['show_arrow'] == 'yes') { ?>
                                <div class="arrows">
                                    <div class="dejavo_next_Arrow id<?= $this->get_id_int(); ?>"><i
                                                class="<?= $next_icon ?>"></i></div>
                                    <div class="dejavo_prev_Arrow id<?= $this->get_id_int(); ?>"><i
                                                class="<?= $prev_icon ?>"></i></div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>

                <div class="slides">
                    <div dir="rtl" class="swiper dejavoSwiper<?= $this->get_id_int(); ?>">
                        <div class="post_slider swiper-wrapper">
                            <?php foreach( $query->posts as $post ) { setup_postdata( $post );
                                 ?>
                                <div class="swiper-slide">
                                    <?php get_template_part('template/post/card'); ?>
                                </div>
                            <?php } wp_reset_postdata();
                             ?>
                        </div>
                    </div>
                    <?php if ($data['show_dots'] == 'yes') { ?>
                        <div class="swiper-pagination sp<?= $this->get_id_int(); ?>"></div><?php } ?>
                </div>

            </div>

            <script>
                var swiper = new Swiper(".dejavoSwiper<?= $this->get_id_int(); ?>", {
                    spaceBetween: <?= $space_between ?>,
                    watchSlidesProgress: true,
                    <?php if ($data['free-mode'] == 'yes') { ?>freeMode: true,<?php } ?>
                    <?php if ($data['autoplay'] == 'yes') { ?>
                    autoplay: {
                        delay: <?= $data['scroll-time'] ?>,
                        disableOnInteraction: true,
                        pauseOnMouseEnter: true,
                    },<?php }  ?>
                    <?php if ($data['show_arrow'] == 'yes') { ?>
                    navigation: {
                        nextEl: ".dejavo_next_Arrow.id<?= $this->get_id_int(); ?>",
                        prevEl: ".dejavo_prev_Arrow.id<?= $this->get_id_int(); ?>",
                    },<?php }  ?>
                    <?php if ($data['show_dots'] == 'yes') { ?>
                    pagination: {el: ".swiper-pagination.sp<?= $this->get_id_int(); ?>", clickable: true,},<?php }  ?>
                    breakpoints: {
                        0: {slidesPerView: <?= $data['number-in-page-mobile'] ?>, speed: 300, slidesPerGroup: 1},
                        640: {slidesPerView: <?= $data['number-in-page-tablet'] ?>,},
                        768: {
                            slidesPerView: <?= $data['number-in-page-laptop'] ?>,
                            speed: <?= $data['scroll-speed'] ?>,
                        },
                        1024: {
                            slidesPerView: <?= $data['number-in-page'] ?>,
                            speed: <?= $data['scroll-speed'] ?>,
                            slidesPerGroup: <?= $data['number-in-scroll'] ?>,
                        },
                    },
                });
            </script>
            <?php
        }
    }
}
