<?php
defined('ABSPATH') || exit;

class dej_ActionIcons extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'dej_action_icons';
    }

    public function get_title()
    {
        return esc_html__('آیکن های مقایسه علاقه مندی', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-heart';
    }


    public function get_categories()
    {
        return ['dejavo-single-product'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('آیکن باکس', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'show_share',
            [
                'label' => esc_html__('نمایش اشتراک گذاری', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_wish',
            [
                'label' => esc_html__('نمایش علاقه مندی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_compare',
            [
                'label' => esc_html__('نمایش مقایسه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_video',
            [
                'label' => esc_html__('نمایش ویدیو', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );



        $this->end_controls_section();
        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_action_icons' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('فاصله از داخل آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_action_icons li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_action_icons' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_action_icons li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'more_options',
            [
                'label' => esc_html__('مرز آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .dej_action_icons li a',
            ]
        );

        $this->add_control(
            'hover_border_color',
            [
                'label' => esc_html__('رنگ هاور مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_action_icons li:hover a' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .dej_action_icons',
            ]
        );

        $this->add_control(
            'item_bg',
            [
                'label' => esc_html__('رنگ پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_action_icons li a' => 'background-color: {{VALUE}} ;',
                ],
            ]
        );


        $this->add_control(
            'hover_item_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه آیتم ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_action_icons li:hover a' => 'background-color: {{VALUE}} ;',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_action_icons li a i' => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'hover_icon_color',
            [
                'label' => esc_html__('رنگ  هاور آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej_action_icons li:hover a i' => 'color: {{VALUE}}'
                ]
            ]
        );


        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('سایز فونت آیکن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 60,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 22,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_action_icons li a i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .dej_action_icons li a',
            ]
        );


        $this->end_controls_section();

    }


    protected function render()
    {
        $data = $this->get_settings_for_display();
        $show_compare = $data['show_compare'];
        $show_wish = $data['show_wish'];
        $show_video = $data['show_video'];
        $show_share = $data['show_share'];
        if (is_product()) {
        global $product;
            $product_id = $product->get_id();
            $meta = get_post_meta($product_id, 'dej_product_options', true) ?? '';
            $video_link = $video_code = '';
            if ($meta) {
                $video_link = $meta['dej_product_video_link'] ?? '';
                $video_code = $meta['dej_product_video_code'] ?? '';
            }

            ?>
            <ul class="dej_action_icons">
                <?php if ( $show_video and ($video_link or $video_code)) { ?>
                    <li id="video-popups" class="hint--top"
                        aria-label="ویدیو"><a href="#dejavo_video" data-effect="mfp-move-from-top">
                            <i class="dej-play"></i></a></li>
                <?php } if ($show_share) { ?>
                    <li id="share-popups" class="hint--top" aria-label="اشتراک گذاری"><a href="#dejavo_share" data-effect="mfp-move-from-top">
                            <i class="dej-share"></i></a></li>
                <?php }
                if (class_exists('DejavoWL') and $show_wish) { ?>
                    <li class="hint--top" aria-label="افزودن به علاقه مندیها"><?= DejavoWL::wl_btn($product_id) ?> </li>
                <?php }
                if (class_exists('DejavoCP') and $show_compare) { ?>
                    <li class="hint--top"
                        aria-label="مقایسه"><?= DejavoCP::cp_btn($product_id) ?></li>
                <?php } ?>
            </ul>


            <?php if ($show_share) { ?>
            <div id="dejavo_share" class="dejavo_popup share mfp-with-anim mfp-hide">
                <div class="content">
                    <p class="title">محصول <?php the_title() ?> را برای دوستانتان از روشهای زیر
                        ارسال کنید</p>
                    <ul class="social_icons">

                        <li class="dejavo-whatsapp hint--top" aria-label="واتساپ"><a
                                    href="https://wa.me/?text=<?php the_permalink() ?> <?= the_title() ?>"><i
                                        class="dejbrand-whatsapp"></i></a></li>
                        <li class="dejavo-telegam hint--top" aria-label="تلگرام"><a
                                    href="https://t.me/share/url?url=<?php the_permalink() ?>&text=<?php the_title() ?>"><i
                                        class="dejbrand-telegram"></i></a></li>
                        <li class="dejavo-facebook hint--top" aria-label="فیسبوک"><a
                                    href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink() ?>"><i
                                        class="dejbrand-facebook"></i></a></li>
                        <li class="dejavo-twitter hint--top" aria-label="توییتر"><a
                                    href="https://twitter.com/intent/tweet?url=<?php the_permalink() ?>&text=<?php the_title() ?>"><i
                                        class="dejbrand-twitter"></i></a></li>
                        <li class="dejavo-mail hint--top" aria-label="ایمیل"><a
                                    href="mailto:?&subject=<?= the_title() ?>&body=<?= the_title() ?> <?php the_permalink() ?>"><i
                                        class="dej-envelope"></i></a></li>
                        <li class="DejavoWL-share-link hint--top" aria-label="جهت کپی کردن لینک کلیک کنید">
                            <input type="url" id="DejavoWL_copy_url"
                                   value="<?php echo home_url() . '/?p=' . $product_id ?>" readonly=""><i
                                    class="dej-copy"></i>
                        </li>
                    </ul>

                </div>

            </div>
            <?php } if ($show_video and ($video_link or $video_code)) { ?>
            <div id="dejavo_video" class="dejavo_popup video mfp-with-anim mfp-hide">
                <div class="content">
                    <p class="title">ویدیو معرفی <?php echo $product->get_title(); ?></p>
                <?php
                if ($video_link) { ?>
                <video width="100%" height="100%" controls><source src="<?= $video_link ?>" type="video/mp4"><source src="<?= $video_link ?>" type="video/ogg"></video></li>
            <?php }  elseif ($video_code) { echo ' <div class="dej_video_code">' . $video_code . '</div>'; } ?>

                </div>

            </div>

            <?php
        }
        }

    }

}
