<?php
defined('ABSPATH') || exit;
class dej_ProductEnTitle extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_product_en_title';
    }

    public function get_title()
    {
        return esc_html__('عنوان + انگلیسی', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-a';
    }

    public function get_categories()
    {
        return ['dejavo-single-product'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .product_en_title',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product_en_title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__('مرز', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .product_en_title',
            ]
        );


        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_en_title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .product_en_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_font_size',
            [
                'label' => esc_html__('اندازه فونت متن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product_en_title' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_section();

    }

    protected function render()
    {
        if (is_product()) {
            global $product;
            ?>
            <div class="single_product_title">
                <h1><?php echo $product->get_title(); ?></h1>
            </div>
            <?php
            $meta = get_post_meta($product->get_id(), 'dej_product_options', true);
            $dej_product_en_title = $meta['dej_product_en_title'] ?? false;
            if ($dej_product_en_title) { ?>
                <div class="product_en_title"><span class="english_title"><?= $dej_product_en_title; ?></span>
                    <div class="dash_line"></div>
                </div>
                <?php
            }

        }
    }
}
