<?php
defined('ABSPATH') || exit;
class dej_ProductImageGallery extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_product_gallery';
    }

    public function get_title()
    {
        return esc_html__('گالری تصاویر محصول', 'dejavo');
    }


    public function get_icon()
    {
        return 'dej-gallery';
    }

    public function get_categories()
    {
        return ['dejavo-single-product'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'show_share',
            [
                'label' => esc_html__('نمایش اشتراک گذاری', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_wish',
            [
                'label' => esc_html__('نمایش علاقه مندی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_compare',
            [
                'label' => esc_html__('نمایش مقایسه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_video',
            [
                'label' => esc_html__('نمایش ویدیو', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'effect',
            [
                'label' => esc_html__(' انیمیشن تعویض', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'true',
                'options' => [
                    'true' => esc_html__('fade', 'dejavo'),
                    'false' => esc_html__('slide', 'dejavo'),
                ],
            ]
        );
        $this->add_control(
            'show_lightbox',
            [
                'label' => esc_html__('نمایش لایت باکس', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_lens',
            [
                'label' => esc_html__('نمایش لنز بزرگنمایی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'no',
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'show_lightbox',
                            'operator' => '!==',
                            'value' => 'yes',
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('نمایش فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_arrow2',
            [
                'label' => esc_html__('نمایش فلش ها تصاویر کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_dots',
            [
                'label' => esc_html__('نمایش نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'dejavo'),
                'label_off' => esc_html__('مخفی', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('تعویض خودکار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'hover_autoplay',
            [
                'label' => esc_html__('توقف تعویض خودکار هنگام هاور', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'autoplay_speed',
            [
                'label' => esc_html__('سرعت تعویض', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1000,
                'max' => 10000,
                'step' => 500,
                'default' => 3500,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );


        $this->add_responsive_control(
            'thumb_number',
            [
                'label' => esc_html__('تعداد تصاویر کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 3,
                'max' => 7,
                'step' => 1,
                'default' => 5,
            ]
        );


        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => esc_html__('فاصله از داخل فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => ['desktop', 'tablet', 'mobile'],
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej-gallery-for .dejavo_next_Arrow, {{WRAPPER}} .dej-gallery-for.dejavo_prev_Arrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر تصویر اصلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej-gallery-for, {{WRAPPER}} .dej-gallery-for img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('کادر تصاویر کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej-gallery-nav .slick-slide img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_border_radius',
            [
                'label' => esc_html__('کادر فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej-gallery-for .dejavo_next_Arrow, {{WRAPPER}} .dej-gallery-for .dejavo_prev_Arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__('مرز تصویر اصلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .dej-gallery-for',
            ]
        );

        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'item_bor_opt_be',
            [
                'label' => esc_html__('مرز تصاویر کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .dej-gallery-nav .slick-slide img',
            ]
        );

        $this->add_control(
            'item_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .dej-product-gallery-slider',
            ]
        );

        $this->add_control(
            'next_icon',
            [
                'label' => esc_html__('آیکن بعدی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-right',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'prev_icon',
            [
                'label' => esc_html__('آیکن قبلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-left',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'arrow_color',
            [
                'label' => esc_html__('رنگ فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej-gallery-for .dejavo_next_Arrow i, {{WRAPPER}} .dej-gallery-for .dejavo_prev_Arrow i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_arrow_color',
            [
                'label' => esc_html__('رنگ هاور فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej-gallery-for .dejavo_next_Arrow:hover i, {{WRAPPER}} .dej-gallery-for .dejavo_prev_Arrow:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_bg',
            [
                'label' => esc_html__('رنگ پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej-gallery-for .dejavo_next_Arrow, {{WRAPPER}} .dej-gallery-for .dejavo_prev_Arrow' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_icon_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej-gallery-for .dejavo_next_Arrow:hover, {{WRAPPER}} .dej-gallery-for .dejavo_prev_Arrow:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'bullet_bg',
            [
                'label' => esc_html__('رنگ نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dej-gallery-for .slick-dots li button:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrows_font_size',
            [
                'label' => esc_html__('سایز فونت فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej-gallery-for .dejavo_next_Arrow i, {{WRAPPER}} .dej-gallery-for .dejavo_prev_Arrow i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_section();

    }


    protected function render()
    {

        $data = $this->get_settings_for_display();
        $show_lightbox = $data['show_lightbox'];
        $show_lens = $data['show_lens'];
        $show_compare = $data['show_compare'];
        $show_wish = $data['show_wish'];
        $show_video = $data['show_video'];
        $show_share = $data['show_share'];
        $slider_rtl = (is_rtl()) ? 'true' : 'false';
        if (is_product()) {
            global $product;
            $product_id = $product->get_id();
            $meta = get_post_meta($product_id, 'dej_product_options', true) ?? '';
            $video_link = $video_code = '';
            if ($meta) {
                $video_link = $meta['dej_product_video_link'] ?? '';
                $video_code = $meta['dej_product_video_code'] ?? '';
            }


            $html = '';
            $wrapper_classes = apply_filters('woocommerce_single_product_image_gallery_classes', array(
                'dej-product-gallery-slider',
                'woocommerce-product-gallery',
                'dej--' . (has_post_thumbnail() ? 'with-images' : 'without-images'),
                'images',

            ));

            $thumb_ids = [];
            $variable_thumb_ids = [];

            $main_thumb_id = intval($product->get_image_id());
            if ($main_thumb_id) {
                $thumb_ids[] = $main_thumb_id;
            }
            if ($product->is_type('variable') && ($children = $product->get_visible_children())) {
                foreach ($children as $child) {
                    if (($child_product = wc_get_product($child)) && (has_post_thumbnail($child) and $child_product_image = $child_product->get_image_id())) {
                        $variable_thumb_ids[] = intval($child_product_image);
                    }
                }
            }
            $variable_thumb_ids = array_unique($variable_thumb_ids);
            $thumb_ids = array_merge($thumb_ids, $variable_thumb_ids, $product->get_gallery_image_ids());
            $thumb_ids = array_unique($thumb_ids);
            ?>

            <div class="<?php echo esc_attr(implode(' ', array_map('sanitize_html_class', $wrapper_classes))); ?>" <?php echo esc_attr($slider_rtl == 'true' ? 'dir=rtl' : ''); ?> >
                <?php
                if ($show_video || $show_share || $show_wish || $show_compare) { ?>
                    <ul class="dej_action_icons_gallery">
                        <?php if ($show_video and ($video_link or $video_code)) { ?>
                            <li id="video-popups" class="hint--left" aria-label="ویدیو"><a href="#dejavo_video"
                                                                                           data-effect="mfp-move-from-top"><i
                                            class="dej-play"></i></a></li>
                        <?php }
                        if ($show_share) { ?>
                            <li id="share-popups" class="hint--left" aria-label="اشتراک گذاری"><a href="#dejavo_share"
                                                                                                  data-effect="mfp-move-from-top"><i
                                            class="dej-share"></i></a></li>
                        <?php }
                        if (class_exists('DejavoWL') and $show_wish) { ?>
                            <li class="hint--left"
                                aria-label="افزودن به علاقه مندیها"><?= DejavoWL::wl_btn($product_id) ?> </li>
                        <?php }
                        if (class_exists('DejavoCP') and $show_compare) { ?>
                            <li class="hint--left"
                                aria-label="مقایسه"><?= DejavoCP::cp_btn($product_id) ?></li>
                        <?php } ?>
                    </ul>
                <?php }

                if (has_post_thumbnail()) {

                    echo '<div class="dej-gallery-for">';

                    if ($variable_thumb_ids) {
                        $image = wp_get_attachment_image($main_thumb_id, 'woocommerce_single', true, array(
                            "class" => "attachment-shop_single size-shop_single wp-post-image zoom",
                            "data-zoom_src" => wp_get_attachment_image_src($main_thumb_id, 'full')[0],
                            'alt' => trim(wp_strip_all_tags(get_post_meta($main_thumb_id, '_wp_attachment_image_alt', true))),
                            'data-thumb' => wp_get_attachment_image_url($main_thumb_id, 'large'),
                            'data-large_image' => wp_get_attachment_image_url($main_thumb_id, 'large'),
                            'data-zoom-image' => wp_get_attachment_image_url($main_thumb_id, 'large'),
                        ));

                        $lightbox_src = wc_get_product_attachment_props($main_thumb_id);


                        if ($show_lightbox and !$show_lens) {
                            $html .= '<div class="single-product-main-image">';
                            $html .= '<a class="dej-lightbox-icon" data-fancybox="dej-lightbox"  href="' . $lightbox_src['url'] . '"     data-mobile=["clickContent:close","clickSlide:close"]  data-animation-effect="zoom" data-loop="true">' . $image . '</a></div>';
                            echo apply_filters('woocommerce_single_product_image_thumbnail_html', $html, $main_thumb_id);

                        } else {
                            $html .= '<div class="single-product-main-image">' . $image . '</div>';
                            echo apply_filters('woocommerce_single_product_image_thumbnail_html', $html, $main_thumb_id);
                        }
                    }

                    if ($thumb_ids) {
                        foreach ($thumb_ids as $attachment_id) {
                            $thumbnail_image = wp_get_attachment_image(
                                $attachment_id, 'woocommerce_single', true, [
                                    "class" => "attachment-shop_single zoom",
                                    "data-zoom_src" => wp_get_attachment_image_src($attachment_id, 'full')[0],
                                    'data-src' => wp_get_attachment_image_url($attachment_id, 'large'),
                                    'alt' => trim(wp_strip_all_tags(get_post_meta($attachment_id, '_wp_attachment_image_alt', true))),
                                ]
                            );
                            $lightbox_src = wc_get_product_attachment_props($attachment_id);

                            $attachment_html = '';
                            if ($show_lightbox and !$show_lens) {
                                $attachment_html .= '<div><a class="dej-lightbox-icon" data-fancybox="dej-lightbox"   href="' . $lightbox_src['url'] . '"   data-mobile=["clickContent:close","clickSlide:close"] data-click-slide="close" data-animation-effect="zoom" data-loop="true" data->' . $thumbnail_image . '</a></div>';
                                echo apply_filters('woocommerce_single_product_image_thumbnail_html', $attachment_html, $main_thumb_id);

                            } else {
                                $attachment_html .= '<div>' . $thumbnail_image . '</div>';
                                echo apply_filters('woocommerce_single_product_image_thumbnail_html', $attachment_html, $main_thumb_id);

                            }


                        }
                    }

                    echo "</div>";
                } else {
                    $html = sprintf('<img src="%s" alt="%s" class="wp-post-image" />', esc_url(wc_placeholder_img_src('woocommerce_single')), esc_html__('Awaiting product image', 'woocommerce'));
                    echo $html;
                }

                //echo apply_filters('woocommerce_single_product_image_thumbnail_html', $html, $main_thumb_id);
                // do_action( 'woocommerce_product_thumbnails' );

                if (has_post_thumbnail()) {
                    echo '<div class="dej-gallery-nav">';

                    if ($variable_thumb_ids) {
                        $image = wp_get_attachment_image($main_thumb_id, 'thumbnail', true, [
                            "class" => "dej-thumb-main-image",
                            'alt' => trim(wp_strip_all_tags(get_post_meta($main_thumb_id, '_wp_attachment_image_alt', true))),
                        ]);
                        echo '<div>' . $image . '</div>';
                    }
                    if ($thumb_ids and count($thumb_ids) > 1) {
                        foreach ($thumb_ids as $attachment_id) {
                            $thumbnail_image = wp_get_attachment_image($attachment_id, 'thumbnail', true, [
                                'alt' => trim(wp_strip_all_tags(get_post_meta($attachment_id, '_wp_attachment_image_alt', true))),
                            ]);
                            echo '<div>' . $thumbnail_image . '</div>';
                        }
                    }
                    echo "</div>";

                }
                ?>

            </div>
            <?php

            $arrows = $data['show_arrow'] ? 'true' : 'false';
            $arrows2 = $data['show_arrow2'] ? 'true' : 'false';
            $animation = $data['effect'] ?? 'true';
            $slider_dots = $data['show_dots'] ? 'true' : 'false';
            $autoPlay = $data['autoplay'] ? 'true' : 'false';
            $autoplay_speed = $data['autoplay_speed'] ?? 4000;
            $slider_autoplay_pause = $data['hover_autoplay'] ? 'true' : 'false';
            $num_thubm = $data['thumb_number'] ?? 5;
            $slider_rtl = (is_rtl()) ? 'true' : 'false';
            $nextArrow = "nextArrow:'<div class=\"dejavo_next_Arrow\"><i class=\" {$data['next_icon']['value']} \"></i></div>',";
            $prevArrow = " prevArrow:'<div class=\"dejavo_prev_Arrow\"><i class=\" {$data['prev_icon']['value']} \"></i></div>',";
            $dej_sliderJs = "jQuery(document).ready(function(){
        jQuery('.dej-gallery-for').slick({
            slidesToShow:1,
            slidesToScroll:1,
            arrows:{$arrows},
            fade:{$animation},
            rtl: $slider_rtl,
			dots: $slider_dots,
			pauseOnHover: $slider_autoplay_pause,
			pauseOnDotsHover: $slider_autoplay_pause,
			dotsClass:'slick-dots dej-dots',
            infinite:false,
            adaptiveHeight:true,
            autoplay:{$autoPlay},
			autoplaySpeed: $autoplay_speed,
            draggable:true,
            {$nextArrow}
           {$prevArrow}
            asNavFor:'.dej-gallery-nav',

        });";

            $dej_sliderNavJs = "jQuery('.dej-gallery-nav').slick({
            slidesToShow:{$num_thubm},
            slidesToScroll: 1,
            asNavFor:'.dej-gallery-for',
            arrows:{$arrows2},
            rtl: $slider_rtl,
            infinite:false,
            focusOnSelect:true,
            responsive: [
					{
					breakpoint: 1025,
					settings: {
						variableWidth: false,
						slidesToShow: 4,
						swipeToSlide :true,
					}
					},
					{
					breakpoint: 767,
					settings: {
						variableWidth: false,
						swipeToSlide :true,
					}
					}
				],
        });

      });";

            ?>
            <script>
                <?php echo $dej_sliderJs;
                echo $dej_sliderNavJs;
                if ($show_lens) { ?>
                jQuery(document).ready((function ($) {
                    if ($(window).width() > 760) {
                        $('.zoom').magnify({speed: 400, touchBottomOffset: 95,});
                    }
                }));
                <?php } else { ?>
                jQuery(document).ready((function ($) {
                    if (typeof $.fn.zoom == 'function') {
                        if ($(window).width() > 760) {
                            $('.dej-gallery-for img').each(function () {
                                $(this).wrap("<div class='zoomtoo-container' data-zoom-image=" + $(this).data("zoom_src") + "></div>");
                            });
                            $('.zoomtoo-container').zoom({
                                magnify: 1,
                                on: 'mouseover',
                            })
                        }
                    }
                }));
                <?php } ?>
            </script>

            <?php
            $custom_css = '';
            if (count($thumb_ids) <= $num_thubm) {
                $custom_css .= "
					.dej-gallery-nav .slick-track {
						transform: inherit !important;
					}
				";
            }

            if (count($thumb_ids) < 2) {
                $custom_css .= " .dej-dots { display: none !important; } ";
            }
            if ($show_lightbox) {
                $custom_css .= ".dej-gallery-for .slick-slide{cursor:pointer !important;} .elementor-lightbox {display: none !important;}";
            } else {
                $custom_css .= ".dej-gallery-for .slick-slide{cursor: default !important;}";
            }
            ?>
            <style>
                <?= $custom_css ?>
            </style>
            <?php if ($show_share) { ?>
                <div id="dejavo_share" class="dejavo_popup mfp-with-anim mfp-hide">
                    <div class="content">
                        <p class="title">محصول <?php the_title(); ?> را برای دوستانتان از روشهای زیر
                            ارسال کنید</p>
                        <ul class="social_icons">

                            <li class="dejavo-whatsapp hint--top" aria-label="واتساپ"><a
                                        href="https://wa.me/?text=<?php the_permalink() ?> <?php the_title() ?>"><i
                                            class="dejbrand-whatsapp"></i></a></li>
                            <li class="dejavo-telegam hint--top" aria-label="تلگرام"><a
                                        href="https://t.me/share/url?url=<?php the_permalink() ?>&text=<?php the_title() ?>"><i
                                            class="dejbrand-telegram"></i></a></li>
                            <li class="dejavo-facebook hint--top" aria-label="فیسبوک"><a
                                        href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink() ?>"><i
                                            class="dejbrand-facebook"></i></a></li>
                            <li class="dejavo-twitter hint--top" aria-label="توییتر"><a
                                        href="https://twitter.com/intent/tweet?url=<?php the_permalink() ?>&text=<?php the_title() ?>"><i
                                            class="dejbrand-twitter"></i></a></li>
                            <li class="dejavo-mail hint--top" aria-label="ایمیل"><a
                                        href="mailto:?&subject=<?= the_title() ?>&body=<?= the_title() ?> <?php the_permalink() ?>"><i
                                            class="dej-envelope"></i></a></li>
                            <li class="DejavoWL-share-link hint--top" aria-label="جهت کپی کردن لینک کلیک کنید">
                                <input type="url" id="DejavoWL_copy_url"
                                       value="<?php echo home_url() . '/?p=' . $product_id ?>" readonly=""><i
                                        class="dej-copy"></i>
                            </li>
                        </ul>

                    </div>

                </div>
                <?php
            }
            if ($show_video and ($video_link or $video_code)) { ?>
                <div id="dejavo_video" class="dejavo_popup video mfp-with-anim mfp-hide">
                    <div class="content">
                        <p class="title">ویدیو معرفی <?php echo $product->get_title(); ?></p>
                        <?php
                        if ($video_link) { ?>
                            <video width="100%" height="100%" controls>
                                <source src="<?= $video_link ?>" type="video/mp4">
                                <source src="<?= $video_link ?>" type="video/ogg">
                            </video></li>
                        <?php } elseif ($video_code) {
                            echo ' <div class="dej_video_code">' . $video_code . '</div>';
                        } ?>

                    </div>

                </div>

                <?php
            }
        }

    }
}
