<?php
defined('ABSPATH') || exit;
class dej_ProductLabel extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'dej_product_label';
    }

    public function get_title()
    {
        return esc_html__('لیبل ها', 'dejavo');
    }

    public function get_icon()
    {
        return 'dej-label';
    }

    public function get_categories()
    {
        return ['dejavo-single-product'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر لیبل ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dej_single_labels .item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'font_size',
            [
                'label' => esc_html__('سایز فونت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 13,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dej_single_labels .item' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .dej_single_labels .item',
            ]
        );


        $this->end_controls_section();

    }

    protected function render()
    {
        if (is_product()) {
            global $product;
            dej_product_labels($product->get_id());
        }
    }
}
