<?php
 defined('ABSPATH') || exit;

class dej_Slider_1 extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'dej-slider1';
    }


    public function get_title()
    {
        return esc_html__('اسلایدر 1', 'dejavo');
    }


    public function get_icon()
    {
        return 'dej-rectangle-horizontal';
    }

    public function get_categories()
    {
        return ['dejavo'];
    }


    public function get_keywords()
    {
        return ['slider'];
    }

    /**
     * Register list widget controls.
     *
     * Add input fields to allow the user to customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('اسلایدر', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        /* Start repeater */

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'bg_des',
            [
                'label' => esc_html__( 'پس زمینه اسلاید', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );


        $repeater->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}',
            ]
        );



        $repeater->add_control(
            'image2',
            [
                'label' => esc_html__('تصویر درون اسلاید', 'dejavo'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );


        $repeater->add_control(
            'title_head',
            [
                'label' => esc_html__( 'عناوین', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $repeater->add_control(
            'title1',
            [
                'label' => esc_html__('عنوان کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('عنوان کوچک', 'dejavo'),
                'label_block' => true,
            ]
        );




        $repeater->add_control(
            'title2',
            [
                'label' => esc_html__('عنوان بزرگ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,

            ]
        );



        $repeater->add_control(
            'desc',
            [
                'label' => esc_html__('توضیحات', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('توضیحات', 'dejavo'),
                'label_block' => true,

            ]
        );




        $repeater->add_control(
            'btn_title',
            [
                'label' => esc_html__('متن دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('متن دکمه', 'dejavo'),
                'label_block' => true,

            ]
        );

        $repeater->add_control(
            'btn_link',
            [
                'label' => esc_html__('لینک دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
            ]
        );

        $repeater->add_control(
            'title_btn_bor',
            [
                'label' => esc_html__( 'مرز دکمه', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .slide_btn',
            ]
        );

        $repeater->add_control(
            'title_color',
            [
                'label' => esc_html__( 'رنگ بندی', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $repeater->add_control(
            'title1_color',
            [
                'label' => esc_html__('رنگ عنوان کوچک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .slide_text h4' => 'color: {{VALUE}}'
                ],
            ]
        );
        $repeater->add_control(
            'title2_color',
            [
                'label' => esc_html__('رنگ عنوان بزرگ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .slide_text h2' => 'color: {{VALUE}}'
                ],
            ]
        );

        $repeater->add_control(
            'desc_color',
            [
                'label' => esc_html__('رنگ توضیحات', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .slide_text p' => 'color: {{VALUE}}'
                ],
            ]
        );


        $repeater->add_control(
            'btn_color',
            [
                'label' => esc_html__('رنگ دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .slide_btn' => 'color: {{VALUE}}'
                ],
            ]
        );



        $repeater->add_control(
            'btn_hover_color',
            [
                'label' => esc_html__('رنگ هاور دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .slide_btn:hover' => 'color: {{VALUE}}; border-color: {{VALUE}}'
                ],
            ]
        );


        $repeater->add_control(
            'btn_bg',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .slide_btn' => ' background-color: {{VALUE}}',
                ],
            ]
        );
        $repeater->add_control(
            'hover_btn_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .slide_btn:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $repeater->add_control(
            'btn_bor_color',
            [
                'label' => esc_html__('رنگ مرز دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .slide_btn' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'hover_btn_bor_c',
            [
                'label' => esc_html__('رنگ هاور مرز دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .slide_btn:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $repeater->add_control(
            'anim_bg',
            [
                'label' => esc_html__('پس زمینه انیمیشنی ؟', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );


        $repeater->add_control(
            'title_anim',
            [
                'label' => esc_html__( 'انیمیشن ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $repeater->add_control(
            'img2_animation',
            [
                'label' => esc_html__( 'انیمیشن تصویر درون اسلاید', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::ANIMATION,
            ]
        );
        $repeater->add_control(
            'title1_animation',
            [
                'label' => esc_html__( 'انیمیشن عنوان کوچک', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::ANIMATION,
            ]
        );
        $repeater->add_control(
            'title2_animation',
            [
                'label' => esc_html__( 'انیمیشن عنوان بزرگ', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::ANIMATION,
            ]
        );
        $repeater->add_control(
            'desc_animation',
            [
                'label' => esc_html__( 'انیمیشن توضیحات', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::ANIMATION,
            ]
        );
        $repeater->add_control(
            'btn_animation',
            [
                'label' => esc_html__( 'انیمیشن دکمه', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::ANIMATION,
            ]
        );

        $repeater->add_control(
            'title_pos',
            [
                'label' => esc_html__( 'موقعیت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $repeater->add_control(
            'title_align',
            [
                'label' => esc_html__( 'موقعیت عناوین', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'p_left' => [
                        'title' => esc_html__( 'Left', 'dejavo' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'p_center' => [
                        'title' => esc_html__( 'Center', 'dejavo' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'p_right' => [
                        'title' => esc_html__( 'Right', 'dejavo' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'p_right',
                'toggle' => true,
            ]
        );
        $repeater->add_control(
            'img_align',
            [
                'label' => esc_html__( 'موقعیت تصویر', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'p_left' => [
                        'title' => esc_html__( 'Left', 'dejavo' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'p_center' => [
                        'title' => esc_html__( 'Center', 'dejavo' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'p_right' => [
                        'title' => esc_html__( 'Right', 'dejavo' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'p_left',
                'toggle' => true,
            ]
        );

        $repeater->add_responsive_control(
            'img2_max_height',
            [
                'label' => esc_html__( 'حداکثر ارتفاع تصویر درون اسلاید', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 700,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 400,
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .slide_img img' => 'max-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        /* End repeater */

        $this->add_control(
            'sliders',
            [
                'label' => esc_html__('اسلاید', 'dejavo'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ title1 }}}',
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__('سبک نمایش', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'style1',
                'options' => [
                    'style1' => esc_html__('یک', 'dejavo'),
                    'style2' => esc_html__('دو', 'dejavo'),
                    'style3' => esc_html__('سه', 'dejavo'),
                ],
            ]
        );


        $this->add_responsive_control(
            'slider_min_height',
            [
                'label' => esc_html__('حداقل ارفاع', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 200,
                        'max' => 700,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 450,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider, {{WRAPPER}} .dejavo_slider .swiper-slide' => 'min-height: {{SIZE}}{{UNIT}} ;',
                ],
            ]
        );

        $this->add_control(
            'scroll-time',
            [
                'label' => esc_html__( 'زمان هر اسلاید (میلی ثانیه)', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 3000,
                'max' => 12000,
                'step' => 500,
                'default' => 6000,
            ]
        );
        $this->add_control(
            'change_speed',
            [
                'label' => esc_html__('سرعت تعویض (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 300,
                'max' => 2500,
                'step' => 100,
                'default' => 700,
            ]
        );
        $this->add_control(
            'effect',
            [
                'label' => esc_html__(' انیمیشن تعویض', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'fade',
                'options' => [
                    'fade' => esc_html__('fade', 'dejavo'),
                    'slide' => esc_html__('slide', 'dejavo'),
                    'cube' => esc_html__('cube', 'dejavo'),
                    'coverflow' => esc_html__('coverflow', 'dejavo'),
                    'flip' => esc_html__('flip', 'dejavo'),
                    'cards' => esc_html__('cards', 'dejavo'),
                ],
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('چرخش خودکار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('نمایش فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'color_select',
            [
                'label' => esc_html__('رنگ فلش ها و نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('روشن', 'dejavo'),
                'label_off' => esc_html__('تیره', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_dots',
            [
                'label' => esc_html__('نمایش نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );


        $this->add_responsive_control(
            'width-cap',
            [
                'label' => esc_html__('حداکثر عرض کپشن', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 200,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 400,
                ],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .slide_text' => 'max-width: {{SIZE}}{{UNIT}} ;',
                ],
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => esc_html__('فاصله از داخل', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('کادر ویجت ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );




        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => esc_html__('فاصله درونی دکمه / اندازه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .slide_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'btn_radius',
            [
                'label' => esc_html__('کادر دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .slide_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
            'bor_opt_be',
            [
                'label' => esc_html__( 'مرز ویجت', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'selector' => '{{WRAPPER}} .dejavo_slider',
            ]
        );

        $this->add_control(
            'bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );




        $this->add_control(
            'bg_title',
            [
                'label' => esc_html__('رنگ پس زمینه ویجت', 'dejavo'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .dejavo_slider',
            ]
        );
        
        $this->add_control(
            'animation_options',
            [
                'label' => esc_html__( 'تنظیمات انیمیشن ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'img2_animation_duration',
            [
                'label' => esc_html__( 'مدت انیمیشن تصویر 1 (میلی ثانیه)', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 4000,
                'step' => 100,
                'default' => 1500,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .slide_img' => 'animation-duration: {{SIZE}}ms; transition-duration: {{SIZE}}ms',
                ],
            ]
        );

        $this->add_control(
            'img2_animation_delay',
            [
                'label' => esc_html__( 'تاخیر انیمیشن تصویر 1 (میلی ثانیه)', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 8000,
                'step' => 100,
                'default' => 300,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .slide_img' => 'animation-delay: {{SIZE}}ms; transition-delay: {{SIZE}}ms',
                ],
            ]
        );


        $this->add_control(
            'ti1_animation_duration',
            [
                'label' => esc_html__( 'مدت انیمیشن عنوان کوچک (میلی ثانیه)', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 4000,
                'step' => 100,
                'default' => 1000,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .slide_text h4' => 'animation-duration: {{SIZE}}ms; transition-duration: {{SIZE}}ms',
                ],
            ]
        );

        $this->add_control(
            'ti1_animation_delay',
            [
                'label' => esc_html__( 'تاخیر انیمیشن عنوان کوچک (میلی ثانیه)', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 8000,
                'step' => 100,
                'default' => 300,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .slide_text h4' => 'animation-delay: {{SIZE}}ms; transition-delay: {{SIZE}}ms',
                ],
            ]
        );

        $this->add_control(
            'ti2_animation_duration',
            [
                'label' => esc_html__( 'مدت انیمیشن عنوان بزرگ (میلی ثانیه)', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 4000,
                'step' => 100,
                'default' => 1000,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .slide_text h2' => 'animation-duration: {{SIZE}}ms; transition-duration: {{SIZE}}ms',
                ],
            ]
        );

        $this->add_control(
            'ti2_animation_delay',
            [
                'label' => esc_html__( 'تاخیر انیمیشن عنوان بزرگ (میلی ثانیه)', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 8000,
                'step' => 100,
                'default' => 500,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .slide_text h2' => 'animation-delay: {{SIZE}}ms; transition-delay: {{SIZE}}ms',
                ],
            ]
        );

        $this->add_control(
            'desc_animation_duration',
            [
                'label' => esc_html__( 'مدت انیمیشن توضیحات (میلی ثانیه)', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 4000,
                'step' => 100,
                'default' => 1000,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .slide_text p' => 'animation-duration: {{SIZE}}ms; transition-duration: {{SIZE}}ms',
                ],
            ]
        );

        $this->add_control(
            'desc_animation_delay',
            [
                'label' => esc_html__( 'تاخیر انیمیشن توضیحات (میلی ثانیه)', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 8000,
                'step' => 100,
                'default' => 800,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .slide_text p' => 'animation-delay: {{SIZE}}ms; transition-delay: {{SIZE}}ms',
                ],
            ]
        );

        $this->add_control(
            'btn_animation_duration',
            [
                'label' => esc_html__( 'مدت انیمیشن دکمه (میلی ثانیه)', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 4000,
                'step' => 100,
                'default' => 1200,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .slide_btn' => 'animation-duration: {{SIZE}}ms; transition-duration: {{SIZE}}ms',
                ],
            ]
        );

        $this->add_control(
            'btn_animation_delay',
            [
                'label' => esc_html__( 'تاخیر انیمیشن دکمه (میلی ثانیه)', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 8000,
                'step' => 100,
                'default' => 1000,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .slide_btn' => 'animation-delay: {{SIZE}}ms; transition-delay: {{SIZE}}ms',
                ],
            ]
        );


        $this->add_responsive_control(
            'h2_font_size',
            [
                'label' => esc_html__('سایز فونت عنوان ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 22,
                ],
                'selectors' => [
                    '{{WRAPPER}} .slide_text h2' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'h2_font_weight',
            [
                'label' => esc_html__('وزن فونت عنوان', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 300,
                        'max' => 900,
                        'step' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 800,
                ],
                'selectors' => [
                    '{{WRAPPER}} .slide_text h2' => 'font-weight: {{SIZE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'h4_font_size',
            [
                'label' => esc_html__('سایز فونت عنوان کوچک ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .slide_text h4' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'btn_font_size',
            [
                'label' => esc_html__('سایز فونت دکمه', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 35,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .slide_text .slide_btn' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'nav_section',
            [
                'label' => esc_html__('فلش ها', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
            'next_icon',
            [
                'label' => esc_html__('آیکن بعدی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-right',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'prev_icon',
            [
                'label' => esc_html__('آیکن قبلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-angle-left',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'arrow_color',
            [
                'label' => esc_html__('رنگ فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .dejavo_next_Arrow i, {{WRAPPER}} .dejavo_slider .dejavo_prev_Arrow i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_arrow_color',
            [
                'label' => esc_html__('رنگ هاور فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .dejavo_next_Arrow:hover i, {{WRAPPER}} .dejavo_slider .dejavo_prev_Arrow:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_bg',
            [
                'label' => esc_html__('رنگ پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .dejavo_next_Arrow, {{WRAPPER}} .dejavo_slider .dejavo_prev_Arrow' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_icon_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .dejavo_next_Arrow:hover, {{WRAPPER}} .dejavo_slider .dejavo_prev_Arrow:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'arrow_bor_rad1',
            [
                'label' => esc_html__('کادر فلش راست', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .dejavo_next_Arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'arrow_bor_rad2',
            [
                'label' => esc_html__('کادر فلش چپ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .dejavo_prev_Arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => esc_html__('فاصله از داخل فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .dejavo_next_Arrow, {{WRAPPER}} .dejavo_slider .dejavo_prev_Arrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();








        $this->start_controls_section(
            'dot_section',
            [
                'label' => esc_html__('نقطه ها', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'bullet_bor_opt_be',
            [
                'label' => esc_html__( 'مرز نقطه ها', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'bullet_border',
                'selector' => '{{WRAPPER}} .dejavo_slider .swiper-pagination',
            ]
        );

        $this->add_control(
            'bullet_bor_opt_af',
            [
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_control(
            'pagination_b_radius',
            [
                'label' => esc_html__('کادر نقطه ها ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .swiper-pagination' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'pagination_bg',
            [
                'label' => esc_html__('رنگ پس زمینه نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .swiper-pagination' => 'background-color: {{VALUE}}'
                ],
            ]
        );

        $this->add_control(
            'bullet_bg',
            [
                'label' => esc_html__('رنگ نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();


    }


    protected function render()
    {

        $data = $this->get_settings_for_display();
        $dejavo_style = $data['style'];
        $effect = $data['effect'] ?? 'fade';
        $slider_count = count($data['sliders']);
        $scroll_time = $data['scroll-time'] ?? 6000;
        $wid_id = $this->get_id_int();
        $dark = '';
        if (!$data['color_select'] == 'yes') { $dark = ' dark'; }

        $data_swiper = ['loop' => true, 'spaceBetween' => 5, 'watchSlidesProgress' => true, 'slidesPerView' => 1, 'centeredSlides' => true, 'grabCursor' => true, 'speed' => $data['change_speed'] , 'effect' => "$effect",];
        if ($data['autoplay'] == 'yes') {$data_swiper['autoplay'] = ['delay' => $scroll_time, 'disableOnInteraction' => false, 'pauseOnMouseEnter' => true];}
        if ($data['show_arrow'] == 'yes') {$data_swiper['navigation'] = ['nextEl' => ".dejavo_next_Arrow.id{$wid_id}", 'prevEl' => ".dejavo_prev_Arrow.id{$wid_id}"];}
        if ($data['show_dots'] == 'yes') {$data_swiper['pagination'] = ['el' => ".swiper-pagination.sp{$wid_id}", 'clickable' => true];}

        $dir = is_rtl() ? 'rtl' : 'ltr';

        $this->add_render_attribute( [
            'swiper-opt' => [
                'dir' => $dir,
                'class' => 'dejavo_slider ' . $dejavo_style . $dark .  ' dej_swiper swiper ',
                'id' => 'DejavoSwiper'.$wid_id,
                'data-swiper' => wp_json_encode($data_swiper)
            ],
        ] );
        ?>
        <div <?= $this->get_render_attribute_string( 'swiper-opt' ) ?>>
                    <div class="swiper-wrapper">
                        <?php  foreach ($data['sliders'] as $slide) {
                            $img_align = $slide['img_align'] ?? 'p_left';
                            $title_align = $slide['title_align'] ?? 'p_right';
                            ?>
                        <div class="<?php if ($slide['anim_bg'] ==='yes') {echo 'bg_gradient_animation';} ?>  elementor-repeater-item-<?=  esc_attr( $slide['_id'] ) ?> swiper-slide">
                            <div class="slide_inner <?php if (!empty($slide['image2']['id'])) { echo 'jc_center';} ?>">
                                <?php if (!empty($slide['image2']['id'])) { ?><div class="<?= $img_align ?> slide_img <?= $slide['img2_animation'] ?>"> <?= wp_get_attachment_image($slide['image2']['id'], 'original') ?></div><?php } ?>
                                <div class="slide_text <?= $title_align ?>">
                                    <?php if (!empty($slide['title1'])) { ?>
                                        <h4 class="<?= $slide['title1_animation'] ?>"><?= $slide['title1'] ?></h4>
                                    <?php } if (!empty($slide['title2'])) { ?>
                                        <h2 class="<?= $slide['title2_animation'] ?>"><?= $slide['title2'] ?></h2>
                                    <?php } if (!empty($slide['desc'])) { ?>
                                        <p class="<?= $slide['desc_animation'] ?>"><?= $slide['desc'] ?></p>
                                    <?php } if (!empty($slide['btn_link']['url']) && !empty($slide['btn_title'])){  ?>
                                        <a class="slide_btn <?= esc_attr($slide['btn_animation']) ?>" href="<?= $slide['btn_link']['url'] ?>" target="_blank"><?= $slide['btn_title'] ?> <i class="dej-arrow-alt-left"></i> </a>
                                    <?php } ?>
                                </div>

                            </div>
                    </div>

                <?php } ?>
                </div>
                    <?php if ($data['show_arrow'] == 'yes' && $slider_count>1) { ?> <div class="dejavo_next_Arrow id<?= $wid_id; ?>"><i class="<?= $data['next_icon']['value'] ?>"></i></div><div class="dejavo_prev_Arrow id<?= $wid_id; ?>"><i class="<?= $data['prev_icon']['value'] ?>"></i></div><?php }  ?>
                    <?php if ($data['show_dots'] == 'yes' && $slider_count>1) { ?><div class="swiper-pagination sp<?= $wid_id; ?>"></div><?php }  ?>

                </div>
        <?php
        if (\Elementor\Plugin::$instance->editor->is_edit_mode()) { ?><script> dej_initSwipers(); </script> <?php }
    }


}