<?php

defined('ABSPATH') || exit;

class dej_Slider_2 extends \Elementor\Widget_Base
{


    public function get_name()
    {
        return 'dej_slider_2';
    }


    public function get_title()
    {
        return esc_html__('اسلایدر 2', 'dejavo');
    }


    public function get_icon()
    {
        return 'dej-rectangle-horizontal';
    }





    public function get_categories()
    {
        return ['dejavo'];
    }


    public function get_keywords()
    {
        return ['slider'];
    }

    /**
     * Register list widget controls.
     *
     * Add input fields to allow the user to customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('اسلایدر', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        /* Start repeater */

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'img_head',
            [
                'label' => esc_html__( 'تصویر اسلاید', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $repeater->add_control(
            'image',
            [
                'label' => esc_html__('Choose Image', 'dejavo'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $repeater->add_control(
            'img_mob_head',
            [
                'label' => esc_html__( 'تصویر اسلاید ویژه موبایل', 'dejavo' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $repeater->add_control(
            'image_mob',
            [
                'label' => esc_html__('Choose Image', 'dejavo'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        

        $repeater->add_control(
            'slide_link',
            [
                'label' => esc_html__('لینک', 'dejavo'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__('https://your-link.com', 'dejavo'),
            ]
        );


        /* End repeater */

        $this->add_control(
            'sliders',
            [
                'label' => esc_html__('اسلاید', 'dejavo'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),           /* Use our repeater */
                'default' => [
                    'slide_link' => [
                        'url' => '#',
                        'is_external' => true,
                        'nofollow' => true,
                        'custom_attributes' => '',
                    ],
                    'image' => ['url' => \Elementor\Utils::get_placeholder_image_src(),],

                ],

            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'my_section',
            [
                'label' => esc_html__('استایل', 'dejavo'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('چرخش خودکار', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'dejavo'),
                'label_off' => esc_html__('خیر', 'dejavo'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'scroll-time',
            [
                'label' => esc_html__('زمان هر اسلاید (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 3000,
                'max' => 12000,
                'step' => 200,
                'default' => 6000,
            ]
        );
        $this->add_control(
            'scroll-speed',
            [
                'label' => esc_html__('سرعت اسکرول (میلی ثانیه)', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 300,
                'max' => 1600,
                'step' => 100,
                'default' => 700,
            ]
        );
        $this->add_control(
            'space',
            [
                'label' => esc_html__('فاصله بین اسلاید ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 50,
                'step' => 1,
                'default' => 10,
            ]
        );
        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('نمایش فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_dots',
            [
                'label' => esc_html__('نمایش نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'next_icon',
            [
                'label' => esc_html__('آیکن بعدی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-arrow-right',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'prev_icon',
            [
                'label' => esc_html__('آیکن قبلی', 'dejavo'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'default' => [
                    'value' => 'dej-arrow-left',
                    'library' => '',
                ],
            ]
        );

        $this->add_control(
            'arrow_color',
            [
                'label' => esc_html__('رنگ فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider2 .dejavo_next_Arrow i, {{WRAPPER}} .dejavo_slider2 .dejavo_prev_Arrow i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_arrow_color',
            [
                'label' => esc_html__('رنگ هاور فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider2 .dejavo_next_Arrow:hover i, {{WRAPPER}} .dejavo_slider2 .dejavo_prev_Arrow:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_bg',
            [
                'label' => esc_html__('رنگ پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider2 .dejavo_next_Arrow, {{WRAPPER}} .dejavo_slider2 .dejavo_prev_Arrow' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'arrow_icon_bg',
            [
                'label' => esc_html__('رنگ هاور پس زمینه فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider2 .dejavo_next_Arrow:hover, {{WRAPPER}} .dejavo_slider2 .dejavo_prev_Arrow:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'arrow_bor_rad1',
            [
                'label' => esc_html__('کادر فلش راست', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider2 .dejavo_next_Arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'arrow_bor_rad2',
            [
                'label' => esc_html__('کادر فلش چپ', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider2 .dejavo_prev_Arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => esc_html__('فاصله از داخل فلش ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider2 .dejavo_next_Arrow, {{WRAPPER}} .dejavo_slider2 .dejavo_prev_Arrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bullet_bg',
            [
                'label' => esc_html__('رنگ نقطه ها', 'dejavo'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dejavo_slider2 .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

    }


    protected function render()
    {

        $data = $this->get_settings_for_display();
        $slider_count = count($data['sliders']);
        $scroll_time = $data['scroll-time'] ?? 6000;
        $wid_id = $this->get_id_int();

        $data_swiper = ["loop"=>true,'spaceBetween'=>$data['space'],'watchSlidesProgress'=>true,'slidesPerView'=>'1.2','centeredSlides'=>true,'grabCursor'=>true,'speed'=> $data['scroll-speed']];
        if ($data['autoplay'] =='yes') {$data_swiper['autoplay'] = ['delay' => $scroll_time, 'disableOnInteraction' => false, 'pauseOnMouseEnter' => true];}
        if ($data['show_arrow'] =='yes') {$data_swiper['navigation'] = ['nextEl'=> ".dejavo_next_Arrow.id{$wid_id}", 'prevEl' => ".dejavo_prev_Arrow.id{$wid_id}"];}
        if ($data['show_dots'] =='yes') {$data_swiper['pagination'] = ['el' =>".swiper-pagination.sp{$wid_id}",'clickable'=>true];}
        $data_swiper['breakpoints'] = ['0' => ['slidesPerView'=>'1'],'576'=>['slidesPerView' =>'1.1'],'768'=>['slidesPerView' =>'1.2']];
        $dir = is_rtl() ? 'rtl' : 'ltr';
        $this->add_render_attribute( [
            'swiper-opt' => [
                'dir' => $dir,
                'class' => 'dejavo_slider2  dej_swiper swiper',
                'id' => 'DejavoSwiper'.$wid_id,
                'data-swiper' => wp_json_encode($data_swiper)
            ],
        ] );

        ?>
        <div <?= $this->get_render_attribute_string( 'swiper-opt' ) ?>>
            <div class="swiper-wrapper">
                <?php foreach ($data['sliders'] as $slide) {?>
                    <div class="swiper-slide">
                        <?php if ( !empty($slide['slide_link']['url']) ) { ?>
                        <a href="<?= $slide['slide_link']['url'] ?>"><?php }

                            if (wp_is_mobile() && $slide['image_mob']['id']) {
                               echo wp_get_attachment_image($slide['image_mob']['id'], 'original');
                            } elseif ($slide['image']['id']) {
                                echo wp_get_attachment_image($slide['image']['id'], 'original');
                            }
                        if ( !empty($slide['slide_link']['url']) ) { echo '</a>'; } ?>
                    </div>
                <?php } ?>
            </div>
            <?php if ($data['show_arrow'] == 'yes' && $slider_count>1) { ?> <div class="dejavo_next_Arrow id<?= $wid_id; ?>"><i class="<?= $data['next_icon']['value'] ?>"></i></div><div class="dejavo_prev_Arrow id<?= $wid_id; ?>"><i class="<?= $data['prev_icon']['value'] ?>"></i></div><?php }  ?>
            <?php if ($data['show_dots'] == 'yes' && $slider_count>1) { ?><div class="swiper-pagination sp<?= $wid_id; ?>"></div><?php }  ?>
        </div>
        <?php if (\Elementor\Plugin::$instance->editor->is_edit_mode()) { ?><script> dej_initSwipers(); </script> <?php }
    }

}