<?php

class DejavoBrandWidget extends WP_Widget
{

    public function __construct()
    {
        parent::__construct(
            'dejavo_brand_widget', // Base ID
            __('فیلتر برند (دژاوو)','dejavo'), // Name
            array('description' => __('فیلتر برند', 'dejavo'),) // Args
        );

    }

    public function widget($args, $instance)
    {
        if (is_shop() || is_product_taxonomy()) {

            $brand_opt = dej_options('dej_brand_slug', 'brand');
            $brand = 'pa_' . $brand_opt;


            $current_products = dejavo_current_products_query($brand);
            $result_brands = dejavo_get_products_attr($current_products, $brand);
            $current_br_filter = isset($_GET['br_filter']) ? explode(',', $_GET['br_filter']) : array();

            if (!empty($result_brands) and !is_wp_error($result_brands) and is_array($result_brands)) {

                echo $args['before_widget'];
                $title = apply_filters('widget_title', $instance['widget_title']);
                if (!empty($title)) {
                    echo $args['before_title'] . $title . $args['after_title'];
                }
                ?>
                <ul class="dejavo_filter_brand">
                    <?php
                    foreach ($result_brands as $brand) {
                        $term = get_term($brand);
                        $my_brand = get_term_meta($term->term_id, 'DejavoVS_image', true);
                        $tooltip = get_term_meta($term->term_id, 'DejavoVS_tooltip', true) ?: $term->name . ' (' . $term->count . ') ';
                        ?>
                        <li class="hint--top <?php echo in_array(esc_html__($term->term_id), $current_br_filter) ? 'active' : ''; ?>" aria-label="<?= esc_attr($tooltip) ?>">
                            <a rel="nofollow" href="<?= dejavo_get_filter_link('br_filter', $term->term_id); ?>">
                                <?php if ($my_brand) { echo '<img src="' . esc_url(wp_get_attachment_thumb_url($my_brand)) . '"/>'; } else { echo $tooltip; } ?></a></li>
                    <?php } ?>
                </ul>

                <?php
                echo $args['after_widget'];
            }
        }
    }

    public function form($instance)
    {

        $widget_title = isset($instance['widget_title']) ? esc_attr($instance['widget_title']) : __('فیلتر بر اساس برند', 'dejavo');
        ?>
        <p>
            <label for="<?php echo $this->get_field_name('widget_title'); ?>"><?php _e('عنوان', 'dejavo'); ?></label>
            <input id="<?php echo $this->get_field_id('widget_title'); ?>"
                   name="<?php echo $this->get_field_name('widget_title'); ?>" type="text"
                   value="<?php echo esc_attr($widget_title); ?>"/>
        </p>
        <p>
            <?php _e('نامک ویژگی برند را brand تنظیم کنید یا مقدار سفارشی را از تنظمات قالب وارد کنید (پیشفرض : brand)'); ?>
        </p>
        <?php
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['widget_title'] = (!empty($new_instance['widget_title'])) ? strip_tags($new_instance['widget_title']) : '';
        return $instance;
    }

}

function register_dej_brand_widget()
{
    register_widget('DejavoBrandWidget');
}

add_action('widgets_init', 'register_dej_brand_widget');

