<?php
class in_stock_widget extends WP_Widget {
	public function __construct() {
		parent::__construct(
			'dejavo_in_stock_widget', // Base ID
            __('فیلتر محصولات موجود (دژاوو)','dejavo'), // Name
			array( 'description' => __( 'فیلتر محصولات موجود', 'dejavo' ), ) // Args
		);
	}

	public function widget( $args, $instance ) {
        if( is_shop() || is_product_taxonomy() ) {
            echo $args['before_widget'];
            $class_active = 'woocommerce-widget-layered-nav-list__item--chosen chosen';
            $current_stock_status = isset( $_GET['stock_status'] ) ? explode( ',', $_GET['stock_status'] ) : array();
            ?>
            <ul class="woocommerce-widget-layered-nav-list not_titled">
                <li class="woocommerce-widget-layered-nav-list__item wc-layered-nav-term <?php echo in_array( 'instock', $current_stock_status ) ? $class_active : ''; ?>"><a rel="nofollow" href="<?php echo esc_attr( dejavo_get_filter_link( 'stock_status', 'instock' ) ); ?>"><?php echo $instance['in_stock_txt']; ?></a></li>
            </ul>
            <?php
            echo $args['after_widget'];
        }
    }

	public function form( $instance ) {

        $in_stock_txt = isset( $instance['in_stock_txt'] ) ? esc_attr( $instance['in_stock_txt'] ) : __('محصولات موجود در انبار', 'dejavo');
        ?>
        <p>
            <label for="<?php echo $this->get_field_name( 'in_stock_txt' ); ?>"><?php _e( 'عنوان', 'dejavo' ); ?></label>
            <input id="<?php echo $this->get_field_id( 'in_stock_txt' ); ?>" name="<?php echo $this->get_field_name( 'in_stock_txt' ); ?>" type="text" value="<?php echo esc_attr( $in_stock_txt ); ?>" />
        </p>
        <?php
    }

	public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['in_stock_txt'] = ( ! empty( $new_instance['in_stock_txt'] ) ) ? strip_tags( $new_instance['in_stock_txt'] ) : '';
        return $instance;
	}

}

function register_in_stock_widget() {
	register_widget( 'in_stock_widget' );
}
add_action( 'widgets_init', 'register_in_stock_widget' );

