<?php

class dejavo_recent_post extends WP_Widget {


	public function __construct() {
		parent::__construct(
			'recent_post_widget', // Base ID
            __('مطالب جدید (دژاوو)','dejavo'), // Name
			array( 'description' => __( 'مطالب جدید با عکس', 'dejavo' ), ) // Args
		);
	}


	public function widget( $args, $instance ) {
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );


		echo $args['before_widget'];
		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

        $num_post = $instance['num_post'];
        $show_date = $instance['show_date'];
        ?>
        <ul class="last_post_widget">
        <?php

		// The Query
		$next_args      = array(
			'post_type'      => 'post',
			'post_status'    => 'publish',
			'posts_per_page' => $num_post,
			'order'          => 'DESC',
			'orderby'        => 'publish_date',

		);
		$next_the_query = new WP_Query( $next_args );

		// The Loop
		if ( $next_the_query->have_posts() ) {
			while ( $next_the_query->have_posts() ) {
				$next_the_query->the_post(); ?>
            <li class="item">
                <div class="img">
                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('thumbnail'); ?></a>
                </div>
                <div class="content">
                    <h5 class="title"><a href="<?php the_permalink(); ?>"><?php the_title() ?></a>
                    </h5>
                    <?php if($show_date) { ?><span class="date"><?php echo get_the_date() ?></span> <?php } ?>
                </div>
            </li>

			<?php
            } wp_reset_postdata();
            ?>
            </ul>
            <?php

            echo $args['after_widget'];
	} }


	public function form( $instance ) {

        $title = !empty($instance[ 'title' ]) ?  $instance[ 'title' ] :  __('آخرین مطالب', 'dejavo');
		$num_post = !empty($instance[ 'num_post' ]) ?  $instance[ 'num_post' ] :  5;
		$show_date = !empty($instance[ 'show_date' ]) ?  $instance[ 'show_date' ] :  1;

        ?>
		<p>
			<label for="<?php echo $this->get_field_name( 'title' ); ?>"><?php _e( 'عنوان ابزارک' , 'dejavo'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_name( 'num_post' ); ?>"><?php _e( 'تعداد مطالب جهت نماش:' , 'dejavo'); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'num_post' ); ?>" name="<?php echo $this->get_field_name( 'num_post' ); ?>" type="text" value="<?php echo esc_attr( $num_post ); ?>" />
		</p>
		<p>

			<input <?php if($show_date): echo "checked"; endif;?> class="widefat" id="<?php echo $this->get_field_id( 'show_date' ); ?>"  name="<?php echo $this->get_field_name( 'show_date' ); ?>" type="checkbox" value="1" />
            <label for="<?php echo $this->get_field_name( 'show_date' ); ?>"><?php _e( 'نمایش تاریخ', 'dejavo' ); ?></label>
		</p>
		<?php
	}


	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( !empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['num_post'] = ( !empty( $new_instance['num_post'] ) ) ? strip_tags( $new_instance['num_post'] ) : '';
		$instance['show_date'] = ( !empty( $new_instance['show_date'] ) ) ? strip_tags( $new_instance['show_date'] ) : '';

		return $instance;
	}

}


function register_dejavo_recent_post() {
	register_widget( 'dejavo_recent_post' );
}
add_action( 'widgets_init', 'register_dejavo_recent_post' );
?>