<?php defined('ABSPATH') || exit; ?>
<div class="dejavo_breadcrumb mb-20">
    <div class="breadcrumb">
        <?php
        if (class_exists('woocommerce') and (is_product() || is_product_category() || is_shop() || is_product_taxonomy())) {
            ?> <a href="<?php bloginfo('url'); ?>"><i class="dej-marker"></i></a> <?php
            woocommerce_breadcrumb();
        } elseif (class_exists('woocommerce') and class_exists('WeDevs_Dokan') and dokan_is_store_page()) { ?>

            <a href="<?php bloginfo('url'); ?>"><i class="dej-marker"></i><?php bloginfo('name'); ?></a>

            <?php $store_user = dokan()->vendor->get(get_query_var('author'));
            echo esc_html_e('Store', 'dokan-lite') . ' ' . $store_user->get_shop_name();
        } else { ?>
            <a class="home" href="<?php bloginfo('url'); ?>"><i class="dej-marker"></i><?php bloginfo('name'); ?></a>

            <?php echo ' / '; if (!is_archive() && !is_search() && !is_page() && !is_home()) {
                the_category(' / '); echo ' / ';
            }
            if (is_archive()) { the_archive_title(); }
            elseif (is_search()) {  the_search_query(); }
            else { echo '<a href="' . get_the_permalink() . '">' . get_the_title() . '</a>'; } ?>
        <?php } ?>
    </div>

        <h2>
            <?php
            if (is_home()) {
                echo get_the_title(get_option('page_for_posts', true));
            } elseif (is_archive()) {
                the_archive_title();
            } elseif (is_search()) {
                 _e('نتایج جست و جو برای : ', 'dejavo');
                the_search_query();
            } elseif (class_exists('WeDevs_Dokan') && dokan_is_store_page()) {
                $store_user = dokan()->vendor->get(get_query_var('author'));
                echo esc_html_e('Store', 'dokan-lite') . ' : ' . $store_user->get_shop_name();
            } else {
                echo '<a href="' . get_the_permalink() . '">' . get_the_title() . '</a>';
            } ?>
        </h2>

</div>