<?php
defined('ABSPATH') || exit;
global $product;
$product_id = $product->get_id()
?>
<div class="product-card mob-card-1">
    <div class="main-bg"></div>
    <div class="image">
        <a href="<?php the_permalink() ?>"><?php dej_mob_card_image(); ?></a>
        <?php dej_product_labels($product_id, dej_options('show_dej_icon_label', true)); dejavo_simple_star_rating(); ?>
        <?php if (dejavo_contdown_timer()) { ?><div class="countdown_time" data-times="<?= dejavo_contdown_timer(); ?>"></div><?php } ?>
    </div>

    <div class="info">
        <?php dejavo_variation(true) ?>
        <div class="price-box"><?php if ($product->is_on_sale()) {woocommerce_show_product_sale_flash();} woocommerce_template_loop_price(); ?></div>
        <?php  dejavo_product_sale_info();  ?>
        <h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3>
        <ul class="icons">
                <?php echo sprintf('<li><a href="%s" data-quantity="1" class="%s" %s><i class="dej-shopping-bag"></i></a></li>',
                    esc_url($product->add_to_cart_url()),
                    esc_attr(implode(' ', array_filter(array(
                        '', 'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart' : '',
                    )))),
                    wc_implode_html_attributes(array(
                        'data-product_id' => $product_id,
                        'data-product_sku' => $product->get_sku(),
                        'aria-label' => $product->add_to_cart_description(),
                        'rel' => 'nofollow',
                    ))
                ); ?>
                <?php if (class_exists('DejavoWL')) { ?><li><?= DejavoWL::wl_btn($product_id) ?></li>
                <?php } if (class_exists('DejavoCP')) { ?><li><?= DejavoCP::cp_btn($product_id) ?></li>
                <?php } if (class_exists('DejavoQV')) { ?><li><?= DejavoQV::qv_btn($product_id) ?></li><?php } ?>
            </ul>
    </div>
</div>