<?php
defined('ABSPATH') || exit;
global $product;
$product_id = $product->get_id()
?>
<div class=" product-card card-4 mob">
    <div class="image">
        <?php dej_product_labels($product_id, dej_options('show_dej_icon_label', 1));
        dejavo_simple_star_rating(); ?>
        <a href="<?php the_permalink(); ?>"><?php dej_mob_card_image(); ?></a>
    </div>
    <div class="info">
        <?php dejavo_variation(true) ?>
        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
        <div class="list-icon">
            <div class="plus">
                <?php echo sprintf('<a aria-label="%s" href="%s" data-quantity="1" class="hint--top-left %s" %s><i class="dej-shopping-cart"></i></a>',
                    esc_html($product->add_to_cart_text()),
                    esc_url($product->add_to_cart_url()),
                    esc_attr(implode(' ', array_filter(array(
                        '', 'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart' : '',
                    )))),
                    wc_implode_html_attributes(array(
                        'data-product_id' => $product_id,
                        'data-product_sku' => $product->get_sku(),
                        'aria-label' => $product->add_to_cart_description(),
                        'rel' => 'nofollow',
                    ))
                );
                ?>
            </div>
            <div class="price">
                <?php woocommerce_template_loop_price();
                if ($product->is_on_sale()) {
                    woocommerce_show_product_sale_flash();
                } ?>
            </div>
        </div>
        <?php if (dejavo_product_percent_sold() || dejavo_product_percent_sold() === 0) { ?>
            <div class="product_sale">
                <div class="sale_bar">
                    <div class="sale_bar_amount" style="width:<?= dejavo_product_percent_sold() ?>%;" aria-valuenow="<?= dejavo_product_percent_sold() ?>" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
                <div class="percent_sold">
                    <div class="percent"><span><?= dejavo_product_percent_sold() . '%' ?></span><?= __('فروخته شده', 'dejavo') ?></div>
                    <?php if (dejavo_contdown_timer()) { ?><div class="countdown_time2" data-times="<?= dejavo_contdown_timer(); ?>"></div><?php } ?>
                </div>
            </div>
        <?php } ?>
    </div>
</div>