<?php defined('ABSPATH') || exit;
global $product;
$show_sale_info = dej_options('show_stock_in_card', 1);
$total_sold = $product->get_total_sales() ?? 0;
$total_quantity = $total_sold + floatval(dejavo_product_quantity());
if (dejavo_managing_stock_check() && $show_sale_info) {
    if ($total_quantity > 0) {
        $percent_sold = intval(($total_sold / $total_quantity) * 100);
        $percent_sold = min($percent_sold, 100);

    } else {
        $percent_sold = 0;
    }

    ?>
    <div class="hint--top product_sale" aria-label="<?php echo $percent_sold . __('% فروش رفته', 'dejavo'); ?>">
        <div class="sale_bar">
            <div class="sale_bar_amount" style="width:<?= $percent_sold ?>%;" aria-valuenow="<?= $percent_sold ?>" aria-valuemin="0"
                 aria-valuemax="100"></div>
        </div><div class="product_sale_info">
            <?php
            echo '<div class="product_total_sold">' . sprintf(__('فروش : %s', 'dejavo'), $total_sold) . '</div>';
            echo '<div class="product_total_quantity">' . sprintf(__('باقیمانده : %s', 'dejavo'), dejavo_product_quantity()) . '</div>';
            ?>
        </div>
    </div>
<?php }