<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
global $product; ?>
<div class="item">
    <div class="image">
        <a href="<?php the_permalink() ?>"><?php the_post_thumbnail('thumbnail'); ?></a>
    </div>
    <div class="info">
        <h4><a href="<?php the_permalink() ?>"><?= wp_trim_words($product->get_title(), 18, '..') ?></a></h4>
        <?php woocommerce_template_loop_price(); ?>
        <?= sprintf('<a href="%s" data-quantity="1" class="add-to-cart %s" %s><i class="dej-shopping-bag"></i> %s</a>',
            esc_url($product->add_to_cart_url()),
            esc_attr(implode(' ', array_filter(array(
                '', 'product_type_' . $product->get_type(),
                $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                $product->supports('ajax_add_to_cart') ? 'ajax_add_to_cart' : '',
            )))),
            wc_implode_html_attributes(array(
                'data-product_id' => $product->get_id(),
                'data-product_sku' => $product->get_sku(),
                'aria-label' => $product->add_to_cart_description(),
                'rel' => 'nofollow',
            )),
            esc_html($product->add_to_cart_text())
        );  ?>
    </div>
</div>