<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$allowed_html = array(
	'a' => array(
		'href' => array(),
	),
);

$my_orders_columns = apply_filters(
    'woocommerce_my_account_my_orders_columns',
    array(
        'order-number'  => esc_html__( 'Order', 'woocommerce' ),
        'order-date'    => esc_html__( 'Date', 'woocommerce' ),
        'order-status'  => esc_html__( 'Status', 'woocommerce' ),
        'order-total'   => esc_html__( 'Total', 'woocommerce' ),
        'order-actions' => '&nbsp;',
    )
);

$customer_orders = get_posts(
    apply_filters(
        'woocommerce_my_account_my_orders_query',
        array(
            'numberposts' => 3,
            'meta_key'    => '_customer_user',
            'meta_value'  => get_current_user_id(),
            'post_type'   => wc_get_order_types( 'view-orders' ),
            'post_status' => array_keys( wc_get_order_statuses() ),
        )
    )
);

$user = get_current_user_id();

$processing = wc_get_orders( array(
    'customer' => $user,
    'status'   => 'processing',
) );
$processing_count = !empty($processing) ? count($processing) : 0;

$completed = wc_get_orders( array(
    'customer' => $user,
    'status'   => 'completed',
) );
$completed_count = !empty($completed) ? count($completed) : 0;


?>
<div class="dejavo_dashboard_items d_grid mob_col1 tab_col2 lap_col3 col4">
    <div class="item">
        <div class="title"><?php _e('سفارش در حال انجام', 'dejavo') ?></div>
        <i class="dej-box-alt"></i>
        <div class="value"><?= $processing_count; ?> <?php _e('مورد', 'dejavo') ?></div>
    </div>
    <div class="item">
        <div class="title"><?php _e('سفارش تکمیل شده', 'dejavo') ?></div>
        <i class="dej-shopping-cart-check"></i>
        <div class="value"><?= $completed_count; ?> <?php _e('مورد', 'dejavo') ?> </div>
    </div>
    <div class="item">
        <div class="title"><?php _e('مبلغ کل سفارشات', 'dejavo') ?></div>
        <i class="dej-money"></i>
        <div class="value"><?= dejavo_user_total_spent(); ?> </div>
    </div>
    <div class="item">
        <div class="title"><?php _e('تعداد نظرات', 'dejavo') ?></div>
        <i class="dej-comment-alt"></i>
        <div class="value"><?= dejavo_total_cm_by_user(); ?> <?php _e('مورد', 'dejavo') ?></div>
    </div>

</div>


<?php if ( $customer_orders ) { ?>
    <div class="dejavo_dashboard_orders">
        <div class="inner">
            <header class="header">
                <div class="title"><?php echo apply_filters( 'woocommerce_my_account_my_orders_title', esc_html__( 'Recent orders', 'woocommerce' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></div>
            </header>
            <table class="table shop_table_responsive my_account_orders">
                <thead>
                <tr>
                    <?php foreach ( $my_orders_columns as $column_id => $column_name ) : ?>
                        <th class="<?php echo esc_attr( $column_id ); ?>"><span class="nobr"><?php echo esc_html( $column_name ); ?></span></th>
                    <?php endforeach; ?>
                </tr>
                </thead>
                <tbody>
                <?php
                foreach ( $customer_orders as $customer_order ) :
                    $order      = wc_get_order( $customer_order ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
                    $item_count = $order->get_item_count();
                    ?>
                    <tr class="order">
                        <?php foreach ( $my_orders_columns as $column_id => $column_name ) : ?>
                            <td class="<?php echo esc_attr( $column_id ); ?>" data-title="<?php echo esc_attr( $column_name ); ?>">
                                <?php if ( has_action( 'woocommerce_my_account_my_orders_column_' . $column_id ) ) : ?>
                                    <?php do_action( 'woocommerce_my_account_my_orders_column_' . $column_id, $order ); ?>

                                <?php elseif ( 'order-number' === $column_id ) : ?>
                                    <a href="<?php echo esc_url( $order->get_view_order_url() ); ?>">
                                        <?php echo _x( '#', 'hash before order number', 'woocommerce' ) . $order->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                                    </a>

                                <?php elseif ( 'order-date' === $column_id ) : ?>
                                    <time datetime="<?php echo esc_attr( $order->get_date_created()->date( 'c' ) ); ?>"><?php echo esc_html( wc_format_datetime( $order->get_date_created() ) ); ?></time>

                                <?php elseif ( 'order-status' === $column_id ) : ?>
                                    <?php echo '<span class="' . esc_html($order->get_status()) . '">' . esc_html( wc_get_order_status_name( $order->get_status() ) ) . '</span>'; ?>

                                <?php elseif ( 'order-total' === $column_id ) : ?>
                                    <?php
                                    /* translators: 1: formatted order total 2: total order items */
                                    printf( _n( '%1$s for %2$s item', '%1$s for %2$s items', $item_count, 'woocommerce' ), $order->get_formatted_order_total(), $item_count ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                    ?>

                                <?php elseif ( 'order-actions' === $column_id ) : ?>
                                    <?php
                                    $actions = wc_get_account_orders_actions( $order );

                                    if ( ! empty( $actions ) ) {
                                        foreach ( $actions as $key => $action ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
                                            echo '<a href="' . esc_url( $action['url'] ) . '" class="button ' . sanitize_html_class( $key ) . '">' . esc_html( $action['name'] ) . '</a>';
                                        }
                                    }
                                    ?>
                                <?php endif; ?>
                            </td>
                        <?php endforeach; ?>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php }

$notifications = dej_options('dej_notifications') ?? 0;
if ($notifications) { $last = array_reverse($notifications) ?>
    <div class="note">
        <div class="title"><i class="dej-bell-ring"></i>آخرین اطلاعیه : <?= $last[0]['title'] ?></div>
        <div class="content"><?php wp_trim_words($last[0]['content'], 100, ''); ?> <a href="<?= wc_get_account_endpoint_url('notes')?>">ادامه .. <i class="dej-arrow-left"></i></a></div>
    </div>
    <?php
}
$viewed_products = !empty($_COOKIE['woocommerce_recently_viewed']) ? (array)explode('|', wp_unslash($_COOKIE['woocommerce_recently_viewed'])) : array();
$viewed_products = array_reverse(array_filter(array_map('absint', $viewed_products)));
if ($viewed_products) {
    ?>
    <div class="dejavo_recent_product">
        <div class="heading_title"><h3><?php _e('بازدید های اخیر', 'dejavo') ?></h3></div>
        <div class="wrapper d_grid tab_col1 col2">
            <?php global $product;
            $args = array(
                'post_type' => 'product',
                'posts_per_page' => 4,
                'post__in' => $viewed_products
            );
            $loop = new WP_Query($args);
            while ($loop->have_posts()) {
                $loop->the_post();
                wc_get_template_part( 'content', 'dej-product' );
                 }
            wp_reset_postdata(); ?> </div>
    </div> <?php
}

	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_before_my_account' );

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_after_my_account' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
