<?php
/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.6.0
 */

if (!defined('ABSPATH')) {
    exit;
}

$icons = ['dashboard' => 'user', 'orders' => 'shopping-cart', 'downloads' => 'download',
    'edit-address' => 'location-alt', 'edit-account' => 'edit', 'wishlist' => 'heart',
    'compare' => 'shuffle', 'customer-logout' => 'sign-out', 'notes' => 'bell',
    'request-a-quote' => 'quote-right', 'rma-requests' => 'rotate-right', 'following' => 'following', 'support-tickets' => 'comments'];

do_action('woocommerce_before_account_navigation');
?>

<nav class="woocommerce-MyAccount-navigation">
    <div class="header">
        <h5 class="title"><?php _e('پروفایل کاربری', 'dejavo') ?></h5>
        <a href="javascript:void(0);" class="Dejavo_close"><i class="dej-cross-small"></i></a>
    </div>

    <ul>
        <?php foreach (wc_get_account_menu_items() as $endpoint => $label) : ?>
            <li class="<?php echo wc_get_account_menu_item_classes($endpoint); ?>">
                <a href="<?php echo esc_url(wc_get_account_endpoint_url($endpoint)); ?>">
                    <div class="icon"><i class="dej-<?php echo esc_html($icons[$endpoint]); ?>"></i></div>
                    <?php echo esc_html($label); ?></a>
            </li>
        <?php endforeach; ?>
    </ul>
</nav>

<?php do_action('woocommerce_after_account_navigation'); ?>
