<?php
/**
 * Product attributes
 *
 * Used by list_attributes() in the products class.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-attributes.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

if ( ! $product_attributes ) {
    return;
}

$divider = '<br>';
global $post, $product;
$has_row    = true;
$alt        = 1;
$alt2 		= 1;
$attributes = $product->get_attributes();


$args = array( 'posts_per_page' => -1, 'post_type' => 'attribute_group', 'post_status' => 'publish', 'orderby' => 'menu_order', 'suppress_filters' => 0);

$attribute_groups = get_posts( $args );


$temp = array();
$haveGroup = array();
if(!empty($attribute_groups)){
    foreach ($attribute_groups as $attribute_group) {

        // Name
        $attribute_group_name = $attribute_group->post_title;
        // icon
        $attributeGroupIcon = get_post_meta($attribute_group->ID, 'woocommerce_group_attributes_icon' , true);
        $icon = "";
        if(!empty($attributeGroupIcon)){
            $icon = '<i class="' . $attributeGroupIcon . ' attr-cat-icon"></i>';
        }else{
            $icon = '<i class="dej-angle-small-left attr-cat-icon"></i>';
        }

        $attributes_in_group = get_post_meta($attribute_group->ID, 'woocommerce_group_attributes_attributes');



        if(is_array($attributes_in_group[0])) {
            $attributes_in_group = $attributes_in_group[0];
        } else {
            $attributes_in_group = $attributes_in_group;
        }

        if(!empty($attributes_in_group)){
            foreach ($attributes_in_group as $attribute_in_group) {

                $attribute_in_group = wc_get_attribute($attribute_in_group);

                foreach ($attributes as $attribute) {

                    if($attribute['is_visible'] == 0){
                        continue;
                    }

                    if(is_object($attribute_in_group) && $attribute_in_group->slug == $attribute['name']){
                        unset($attributes[$attribute['name']]);
                        $temp[$attribute_group_name]['name'] = $attribute_group_name;
                        $temp[$attribute_group_name]['icon'] = $icon;
                        $temp[$attribute_group_name]['attributes'][] = $attribute;
                        $haveGroup[] = $attribute['name'];
                    } else {
                        $temp[$attribute['name']] = $attribute;
                    }
                }
            }
        }
    }
} else {
    $temp = $attributes;
}

foreach ($temp as $asd) {
    if(is_array($asd)) {
        continue;
    }
    $name = $asd->get_name();
    if(!in_array($name, $haveGroup)){
        $temp['other']['name'] = __('سایر مشخصات', 'dejavo');
        $temp['other']['icon'] = '<i class="dej-angle-small-left attribute-group-icon"></i>';
        $temp['other']['attributes'][] = $asd;
    }
    unset($temp[$name]);
}
 ob_start();

?>
    <div class="dej_attr">


<?php if ( $product->has_weight() ) { ?>
    <div class="attr_row attr_weight">
        <div class="attr_name_values">
            <div class="<?php if ( ( $alt = $alt * -1 ) == 1 ) echo 'odd'; ?>">
                <div class="attr_name"><?php _e( 'Weight', 'woocommerce' ) ?></div>
                <div class="attr_value product_weight"><?php echo esc_html( wc_format_weight( $product->get_weight() ) ); ?></div>
            </div>
        </div>
    </div>
<?php }  if ( $product->has_dimensions() ) { ?>
    <div class="attr_row attr_dimensions">
        <div class="attr_name_values">
            <div class="<?php if ( ( $alt = $alt * -1 ) == 1 ) echo 'odd'; ?>">
                <div class="attr_name"><?php _e( 'Dimensions', 'woocommerce' ) ?></div>
                <div class="attr_value product_dimensions"><?php echo esc_html( wc_format_dimensions( $product->get_dimensions( false ) ) ); ?></div>
            </div>
        </div>
    </div>
<?php }  foreach ($temp as $key => $attribute_group) :
    $alt = 1;
    $counter=500;
    if(isset($attribute_group['attributes'])){
        ?>
        <?php
        echo '<div class="attr_cat_name">';
        if(isset($attribute_group['icon']) && !empty($attribute_group['icon'])){
            echo $attribute_group['icon'];
        }
        echo __($attribute_group['name']);
        echo '</div>';
    }

   // var_dump( $attribute_group['attributes']);

    ?>

    <div class="attr_row attr_row_list">

    <div class="attr_name_values">
        <?php
        if(!is_array($attribute_group['attributes'])) {
            continue;
        }
        ksort($attribute_group['attributes']);

        foreach ( $attribute_group['attributes'] as $attribute ) {


            if ( empty( $attribute['is_visible'] ) || ( $attribute['is_taxonomy'] && ! taxonomy_exists( $attribute['name'] ) ) ) {
                continue;
            } else {
                $has_row = true;
            }

            if ( ( $alt = $alt * -1 ) == 1 ){
                echo ' <div class="odd">'; }
            else {
                echo ' <div>';
            }

            $hasImage = apply_filters('woocommerce_attribute_name_image', wc_attribute_label( $attribute->get_name() ), $attribute->get_id());
            if($hasImage) {
                $attribute_name = $hasImage;
            } else {
                $attribute_name = wc_attribute_label( $attribute->get_name() );
            }

            echo '<div class="attr_name">' . $attribute_name . '</div>';

            echo '<div class="attr_value">';

            $values = array();
            if ( $attribute->is_taxonomy() ) {
                $attribute_taxonomy = $attribute->get_taxonomy_object();
                $attribute_values = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'all' ) );

                foreach ( $attribute_values as $attribute_value ) {

                    $hasImage = apply_filters('woocommerce_attribute_value_image', esc_html( $attribute_value->name ), $attribute_value->term_id);
                    if(!empty($hasImage)) {
                        $value_name = $hasImage;
                    } else {
                        $value_name = esc_html( $attribute_value->name );
                    }

                    if ( $attribute_taxonomy->attribute_public ) {
                        $values[] = '<a href="' . esc_url( get_term_link( $attribute_value->term_id, $attribute->get_name() ) ) . '" rel="tag">' . $value_name . '</a>';
                    } else {
                        $values[] = $value_name;
                    }
                }
            } else {
                $values = $attribute->get_options();

                foreach ( $values as &$value ) {
                    $value = make_clickable( esc_html( $value ) );
                }
            }

            echo apply_filters( 'woocommerce_attribute', wpautop( wptexturize( implode( $divider, $values ) ) ), $attribute, $values );
            echo '</div>';
            echo '</div>';
        }
        echo '</div>';
        ?>
    </div>
<?php

    $counter++;
endforeach;
?>



    </div>
<?php
if ( $has_row ) {
    echo ob_get_clean();
} else {
    ob_end_clean();
}
